<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSyllabusDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('syllabus_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('syllabus_id')->unsigned()->nullable();
            $table->foreign('syllabus_id')->references('id')->on('syllabuses')->onDelete('cascade');
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->text('options')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('syllabus_details', function(Blueprint $table)
        {
            $table->dropForeign('syllabus_details_syllabus_id_foreign');
        });
        
        Schema::dropIfExists('syllabus_details');
    }
}
