(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[9567],{93834:(e,r,o)=>{"use strict";o.d(r,{Z:()=>i});var s=o(94015),t=o.n(s),n=o(23645),a=o.n(n)()(t());a.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/academic/course/form.vue"],names:[],mappings:"AAiOA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="courseForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'academic.course_name\')}}</label>\n                        <input class="form-control" type="text" v-model="courseForm.name" name="name" :placeholder="trans(\'academic.course_name\')">\n                        <show-error :form-name="courseForm" prop-name="name"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'academic.course_group\')}} </label> <button type="button" class="btn btn-xs btn-info pull-right" v-if="hasPermission(\'access-configuration\')" @click="showCourseGroupModal = true">{{trans(\'general.add_new\')}}</button>\n                        <v-select label="name" v-model="selected_course_group" name="course_group_id" id="course_group_id" :options="course_groups" :placeholder="trans(\'academic.select_course_group\')" @select="onCourseGroupSelect" @close="courseForm.errors.clear(\'course_group_id\')" @remove="courseForm.course_group_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!course_groups.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="courseForm" prop-name="course_group_id"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'academic.course_description\')}}</label>\n                        <input class="form-control" type="text" v-model="courseForm.description" name="description" :placeholder="trans(\'academic.course_description\')">\n                        <show-error :form-name="courseForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n                \x3c!-- <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'student.attendance_type\')}}</label>\n                        <select v-model="courseForm.attendance_type" class="custom-select col-12" name="attendance_type" @change="courseForm.errors.clear(\'attendance_type\')">\n                          <option v-for="option in attendance_types" v-bind:value="option.value">\n                            {{ option.text }}\n                          </option>\n                        </select>\n                        <show-error :form-name="courseForm" prop-name="attendance_type"></show-error>\n                    </div>\n                </div> --\x3e\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <div>{{trans(\'student.enable_registration\')}}</div>\n                        <switches class="m-t-10" v-model="courseForm.enable_registration" theme="bootstrap" color="success"></switches> \n                        <show-error :form-name="courseForm" prop-name="enable_registration"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <div>{{trans(\'student.enable_registration_fee\')}}</div>\n                        <switches class="m-t-10" v-model="courseForm.enable_registration_fee" theme="bootstrap" color="success"></switches> \n                        <show-error :form-name="courseForm" prop-name="enable_registration_fee"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3" v-if="courseForm.enable_registration_fee">\n                    <div class="form-group">\n                        <label for="">{{trans(\'student.registration_fee\')}}</label>\n                        <currency-input :position="default_currency.position" :symbol="default_currency.symbol" name="registration_fee" :placeholder="trans(\'student.registration_fee\')" v-model="courseForm.registration_fee" @input.native="courseForm.errors.clear(\'registration_fee\')"></currency-input>\n                        <show-error :form-name="courseForm" prop-name="registration_fee"></show-error>\n                    </div>\n                </div>\n            </div>\n\n            <div class="card-footer text-right">\n                <router-link to="/academic/course" class="btn btn-danger waves-effect waves-light " v-show="id">{{trans(\'general.cancel\')}}</router-link>\n                <button v-if="!id" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="id">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n\n        <transition name="modal" v-if="showCourseGroupModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'academic.add_new_course_group\')}}\n                                <span class="float-right pointer" @click="showCourseGroupModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <course-group-form @completed="getPreRequisite" @cancel="showCourseGroupModal = false"></course-group-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n\n<script>\n    import courseGroupForm from \'../../configuration/academic/course-group/form\'\n\n    export default {\n        components: {courseGroupForm},\n        data() {\n            return {\n                courseForm: new Form({\n                    name : \'\',\n                    description : \'\',\n                    course_group_id: \'\',\n                    attendance_type: helper.getConfig(\'default_attendance_type\'),\n                    enable_registration: \'\',\n                    enable_registration_fee: \'\',\n                    registration_fee: \'\'\n                }),\n                course_groups: [],\n                selected_course_group: null,\n                default_currency: helper.getConfig(\'default_currency\'),\n                attendance_types: [\n                    {\n                        "text": i18n.student.attendance_type_daily,\n                        "value": "daily"\n                    }\n                    // {\n                    //     "text": i18n.student.attendance_type_subject_wise,\n                    //     "value": "subject_wise"\n                    // }\n                ],\n                showCourseGroupModal: false\n            };\n        },\n        props: [\'id\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-course\') && !helper.hasPermission(\'edit-course\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            if(this.id)\n                this.get();\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            proceed(){\n                if(this.id)\n                    this.update();\n                else\n                    this.store();\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/course/pre-requisite\')\n                    .then(response => {\n                        this.course_groups = response;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.courseForm.post(\'/api/course\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.courseForm.attendance_type = helper.getConfig(\'default_attendance_type\');\n                        this.selected_course_group = null;\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/course/\'+this.id)\n                    .then(response => {\n                        this.courseForm.name = response.name;\n                        this.courseForm.description = response.description;\n                        this.courseForm.attendance_type = response.options ? response.options.attendance_type : helper.getConfig(\'default_attendance_type\');\n                        this.courseForm.enable_registration = response.options ? response.options.enable_registration : helper.getConfig(\'enable_registration\');\n                        this.courseForm.enable_registration_fee = response.options ? response.options.enable_registration_fee : helper.getConfig(\'enable_registration_fee\');\n                        this.courseForm.registration_fee = response.options ? response.options.registration_fee : helper.getConfig(\'registration_fee\');\n                        this.courseForm.course_group_id = response.course_group_id;\n                        this.selected_course_group = {id: response.course_group_id, name: response.course_group.name};\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/academic/course\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.courseForm.patch(\'/api/course/\'+this.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/academic/course\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            getConfig(config) {\n                return helper.getConfig(config);\n            },\n            onCourseGroupSelect(selectedOption){\n                this.courseForm.course_group_id = selectedOption.id;\n            },\n            hideCourseGroupForm(){\n                $(\'.add-course-group-form\').modal(\'hide\');\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const i=a},76517:(e,r,o)=>{"use strict";o.r(r),o.d(r,{default:()=>t});const s={components:{courseForm:o(57314).Z},data:function(){return{id:this.$route.params.id}},mounted:function(){helper.hasPermission("edit-course")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const t=(0,o(51900).Z)(s,(function(){var e=this,r=e.$createElement,o=e._self._c||r;return o("div",[o("div",{staticClass:"page-titles"},[o("div",{staticClass:"row"},[o("div",{staticClass:"col-12 col-sm-6"},[o("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("academic.edit_course")))])]),e._v(" "),o("div",{staticClass:"col-12 col-sm-6"},[o("div",{staticClass:"action-buttons pull-right"},[o("button",{staticClass:"btn btn-info btn-sm",on:{click:function(r){return e.$router.push("/academic/course")}}},[o("i",{staticClass:"fas fa-list"}),e._v(" "),o("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("academic.course")))])])])])])]),e._v(" "),o("div",{staticClass:"container-fluid"},[o("div",{staticClass:"card card-form"},[o("div",{staticClass:"card-body p-t-20"},[o("course-form",{attrs:{id:e.id}})],1)])])])}),[],!1,null,null,null).exports},57314:(e,r,o)=>{"use strict";o.d(r,{Z:()=>c});const s={components:{courseGroupForm:o(67113).Z},data:function(){return{courseForm:new Form({name:"",description:"",course_group_id:"",attendance_type:helper.getConfig("default_attendance_type"),enable_registration:"",enable_registration_fee:"",registration_fee:""}),course_groups:[],selected_course_group:null,default_currency:helper.getConfig("default_currency"),attendance_types:[{text:i18n.student.attendance_type_daily,value:"daily"}],showCourseGroupModal:!1}},props:["id"],mounted:function(){helper.hasPermission("create-course")||helper.hasPermission("edit-course")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.id&&this.get(),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},proceed:function(){this.id?this.update():this.store()},getPreRequisite:function(){var e=this,r=this.$loading.show();axios.get("/api/course/pre-requisite").then((function(o){e.course_groups=o,r.hide()})).catch((function(e){r.hide(),helper.showErrorMsg(e)}))},store:function(){var e=this,r=this.$loading.show();this.courseForm.post("/api/course").then((function(o){toastr.success(o.message),e.courseForm.attendance_type=helper.getConfig("default_attendance_type"),e.selected_course_group=null,e.$emit("completed"),r.hide()})).catch((function(e){r.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,r=this.$loading.show();axios.get("/api/course/"+this.id).then((function(o){e.courseForm.name=o.name,e.courseForm.description=o.description,e.courseForm.attendance_type=o.options?o.options.attendance_type:helper.getConfig("default_attendance_type"),e.courseForm.enable_registration=o.options?o.options.enable_registration:helper.getConfig("enable_registration"),e.courseForm.enable_registration_fee=o.options?o.options.enable_registration_fee:helper.getConfig("enable_registration_fee"),e.courseForm.registration_fee=o.options?o.options.registration_fee:helper.getConfig("registration_fee"),e.courseForm.course_group_id=o.course_group_id,e.selected_course_group={id:o.course_group_id,name:o.course_group.name},r.hide()})).catch((function(o){r.hide(),helper.showErrorMsg(o),e.$router.push("/academic/course")}))},update:function(){var e=this,r=this.$loading.show();this.courseForm.patch("/api/course/"+this.id).then((function(o){toastr.success(o.message),r.hide(),e.$router.push("/academic/course")})).catch((function(e){r.hide(),helper.showErrorMsg(e)}))},getConfig:function(e){return helper.getConfig(e)},onCourseGroupSelect:function(e){this.courseForm.course_group_id=e.id},hideCourseGroupForm:function(){$(".add-course-group-form").modal("hide")}}};var t=o(93379),n=o.n(t),a=o(93834),i={insert:"head",singleton:!1};n()(a.Z,i);a.Z.locals;const c=(0,o(51900).Z)(s,(function(){var e=this,r=e.$createElement,o=e._self._c||r;return o("div",[o("form",{on:{submit:function(r){return r.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(r){return e.courseForm.errors.clear(r.target.name)}}},[o("div",{staticClass:"row"},[o("div",{staticClass:"col-12 col-sm-3"},[o("div",{staticClass:"form-group"},[o("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.course_name")))]),e._v(" "),o("input",{directives:[{name:"model",rawName:"v-model",value:e.courseForm.name,expression:"courseForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:e.trans("academic.course_name")},domProps:{value:e.courseForm.name},on:{input:function(r){r.target.composing||e.$set(e.courseForm,"name",r.target.value)}}}),e._v(" "),o("show-error",{attrs:{"form-name":e.courseForm,"prop-name":"name"}})],1)]),e._v(" "),o("div",{staticClass:"col-12 col-sm-3"},[o("div",{staticClass:"form-group"},[o("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.course_group"))+" ")]),e._v(" "),e.hasPermission("access-configuration")?o("button",{staticClass:"btn btn-xs btn-info pull-right",attrs:{type:"button"},on:{click:function(r){e.showCourseGroupModal=!0}}},[e._v(e._s(e.trans("general.add_new")))]):e._e(),e._v(" "),o("v-select",{attrs:{label:"name",name:"course_group_id",id:"course_group_id",options:e.course_groups,placeholder:e.trans("academic.select_course_group")},on:{select:e.onCourseGroupSelect,close:function(r){return e.courseForm.errors.clear("course_group_id")},remove:function(r){e.courseForm.course_group_id=""}},model:{value:e.selected_course_group,callback:function(r){e.selected_course_group=r},expression:"selected_course_group"}},[e.course_groups.length?e._e():o("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),o("show-error",{attrs:{"form-name":e.courseForm,"prop-name":"course_group_id"}})],1)]),e._v(" "),o("div",{staticClass:"col-12 col-sm-3"},[o("div",{staticClass:"form-group"},[o("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.course_description")))]),e._v(" "),o("input",{directives:[{name:"model",rawName:"v-model",value:e.courseForm.description,expression:"courseForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:e.trans("academic.course_description")},domProps:{value:e.courseForm.description},on:{input:function(r){r.target.composing||e.$set(e.courseForm,"description",r.target.value)}}}),e._v(" "),o("show-error",{attrs:{"form-name":e.courseForm,"prop-name":"description"}})],1)]),e._v(" "),o("div",{staticClass:"col-12 col-sm-3"},[o("div",{staticClass:"form-group"},[o("div",[e._v(e._s(e.trans("student.enable_registration")))]),e._v(" "),o("switches",{staticClass:"m-t-10",attrs:{theme:"bootstrap",color:"success"},model:{value:e.courseForm.enable_registration,callback:function(r){e.$set(e.courseForm,"enable_registration",r)},expression:"courseForm.enable_registration"}}),e._v(" "),o("show-error",{attrs:{"form-name":e.courseForm,"prop-name":"enable_registration"}})],1)]),e._v(" "),o("div",{staticClass:"col-12 col-sm-3"},[o("div",{staticClass:"form-group"},[o("div",[e._v(e._s(e.trans("student.enable_registration_fee")))]),e._v(" "),o("switches",{staticClass:"m-t-10",attrs:{theme:"bootstrap",color:"success"},model:{value:e.courseForm.enable_registration_fee,callback:function(r){e.$set(e.courseForm,"enable_registration_fee",r)},expression:"courseForm.enable_registration_fee"}}),e._v(" "),o("show-error",{attrs:{"form-name":e.courseForm,"prop-name":"enable_registration_fee"}})],1)]),e._v(" "),e.courseForm.enable_registration_fee?o("div",{staticClass:"col-12 col-sm-3"},[o("div",{staticClass:"form-group"},[o("label",{attrs:{for:""}},[e._v(e._s(e.trans("student.registration_fee")))]),e._v(" "),o("currency-input",{attrs:{position:e.default_currency.position,symbol:e.default_currency.symbol,name:"registration_fee",placeholder:e.trans("student.registration_fee")},nativeOn:{input:function(r){return e.courseForm.errors.clear("registration_fee")}},model:{value:e.courseForm.registration_fee,callback:function(r){e.$set(e.courseForm,"registration_fee",r)},expression:"courseForm.registration_fee"}}),e._v(" "),o("show-error",{attrs:{"form-name":e.courseForm,"prop-name":"registration_fee"}})],1)]):e._e()]),e._v(" "),o("div",{staticClass:"card-footer text-right"},[o("router-link",{directives:[{name:"show",rawName:"v-show",value:e.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/academic/course"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.id?e._e():o("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(r){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),o("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.id?o("span",[e._v(e._s(e.trans("general.update")))]):o("span",[e._v(e._s(e.trans("general.save")))])])],1)]),e._v(" "),e.showCourseGroupModal?o("transition",{attrs:{name:"modal"}},[o("div",{staticClass:"modal-mask"},[o("div",{staticClass:"modal-wrapper"},[o("div",{staticClass:"modal-container modal-lg"},[o("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                            "+e._s(e.trans("academic.add_new_course_group"))+"\n                            "),o("span",{staticClass:"float-right pointer",on:{click:function(r){e.showCourseGroupModal=!1}}},[e._v("x")])]}))],2),e._v(" "),o("div",{staticClass:"modal-body"},[e._t("body",(function(){return[o("course-group-form",{on:{completed:e.getPreRequisite,cancel:function(r){e.showCourseGroupModal=!1}}}),e._v(" "),o("div",{staticClass:"clearfix"})]}))],2)])])])]):e._e()],1)}),[],!1,null,null,null).exports},67113:(e,r,o)=>{"use strict";o.d(r,{Z:()=>t});const s={components:{},data:function(){return{courseGroupForm:new Form({name:"",description:""})}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var e=this,r=this.$loading.show();this.courseGroupForm.post("/api/academic/course/group").then((function(o){toastr.success(o.message),e.$emit("completed"),r.hide()})).catch((function(e){r.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,r=this.$loading.show();axios.get("/api/academic/course/group/"+this.id).then((function(o){e.courseGroupForm.name=o.name,e.courseGroupForm.description=o.description,r.hide()})).catch((function(o){r.hide(),helper.showErrorMsg(o),e.$router.push("/configuration/academic/course/group")}))},update:function(){var e=this,r=this.$loading.show();this.courseGroupForm.patch("/api/academic/course/group/"+this.id).then((function(o){toastr.success(o.message),r.hide(),e.$router.push("/configuration/academic/course/group")})).catch((function(e){r.hide(),helper.showErrorMsg(e)}))}}};const t=(0,o(51900).Z)(s,(function(){var e=this,r=e.$createElement,o=e._self._c||r;return o("form",{on:{submit:function(r){return r.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(r){return e.courseGroupForm.errors.clear(r.target.name)}}},[o("div",{staticClass:"row"},[o("div",{staticClass:"col-12 col-sm-6"},[o("div",{staticClass:"form-group"},[o("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.course_group_name")))]),e._v(" "),o("input",{directives:[{name:"model",rawName:"v-model",value:e.courseGroupForm.name,expression:"courseGroupForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:e.trans("academic.course_group_name")},domProps:{value:e.courseGroupForm.name},on:{input:function(r){r.target.composing||e.$set(e.courseGroupForm,"name",r.target.value)}}}),e._v(" "),o("show-error",{attrs:{"form-name":e.courseGroupForm,"prop-name":"name"}})],1)]),e._v(" "),o("div",{staticClass:"col-12 col-sm-6"},[o("div",{staticClass:"form-group"},[o("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.course_group_description")))]),e._v(" "),o("input",{directives:[{name:"model",rawName:"v-model",value:e.courseGroupForm.description,expression:"courseGroupForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:e.trans("academic.course_group_description")},domProps:{value:e.courseGroupForm.description},on:{input:function(r){r.target.composing||e.$set(e.courseGroupForm,"description",r.target.value)}}}),e._v(" "),o("show-error",{attrs:{"form-name":e.courseGroupForm,"prop-name":"description"}})],1)])]),e._v(" "),o("div",{staticClass:"card-footer text-right"},[o("router-link",{directives:[{name:"show",rawName:"v-show",value:e.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/configuration/academic/course/group"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.id?e._e():o("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(r){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),o("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.id?o("span",[e._v(e._s(e.trans("general.update")))]):o("span",[e._v(e._s(e.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=0e79cc65c51779abbd4a