(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[1622],{42406:(e,t,n)=>{"use strict";n.d(t,{Z:()=>i});var s=n(94015),r=n.n(s),o=n(23645),a=n.n(o)()(r());a.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/calendar/event/form.vue"],names:[],mappings:"AA8XA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="eventForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <label for="">{{trans(\'calendar.event_title\')}}</label>\n                        <input class="form-control" type="text" v-model="eventForm.title" name="title" :placeholder="trans(\'calendar.event_title\')">\n                        <show-error :form-name="eventForm" prop-name="title"></show-error>\n                    </div>\n                    <div class="row">\n                        <div class="col-12 col-sm-6">\n                            <div class="form-group">\n                                <label for="">{{trans(\'calendar.event_type\')}} </label> <button type="button" class="btn btn-xs btn-info pull-right" v-if="hasPermission(\'access-configuration\')" @click="showEventTypeModal = true">{{trans(\'general.add_new\')}}</button>\n                                <v-select label="name" v-model="selected_event_type" name="event_type_id" id="event_type_id" :options="event_types" :placeholder="trans(\'calendar.select_event_type\')" @select="onEventTypeSelect" @close="eventForm.errors.clear(\'event_type_id\')" @remove="eventForm.event_type_id = \'\'">\n                                    <div class="multiselect__option" slot="afterList" v-if="!event_types.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                                <show-error :form-name="eventForm" prop-name="event_type_id"></show-error>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-6">\n                            <div class="form-group">\n                                <label for="">{{trans(\'calendar.event_venue\')}}</label>\n                                <input class="form-control" type="text" v-model="eventForm.venue" name="venue" :placeholder="trans(\'calendar.event_venue\')">\n                                <show-error :form-name="eventForm" prop-name="venue"></show-error>\n                            </div>\n                        </div>\n                    </div>\n                    <div class="row">\n                        <div class="col-12 col-sm-6">\n                            <div class="form-group">\n                                <label for="">{{trans(\'calendar.event_start_date\')}}</label>\n                                <label class="custom-control custom-checkbox float-right">\n                                    <input type="checkbox" class="custom-control-input" v-model="eventForm.no_time" value="1">\n                                    <span class="custom-control-label">{{trans(\'calendar.event_no_time\')}}</span>\n                                </label>\n                                <datepicker v-model="eventForm.start_date" :bootstrapStyling="true" @selected="eventForm.errors.clear(\'start_date\')" :placeholder="trans(\'calendar.event_start_date\')"></datepicker>\n                                <show-error :form-name="eventForm" prop-name="start_date"></show-error>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-6" v-if="!eventForm.no_time">\n                            <div class="form-group">\n                                <label for="">{{trans(\'calendar.event_start_time\')}}</label>\n                                <timepicker :hour.sync="start_time.hour" :minute.sync="start_time.minute" :meridiem.sync="start_time.meridiem"></timepicker>\n                            </div>\n                        </div>\n                    </div>\n                    <div class="row">\n                        <div class="col-12 col-sm-6">\n                            <div class="form-group">\n                                <label for="">{{trans(\'calendar.event_end_date\')}}</label>\n                                <datepicker v-model="eventForm.end_date" :bootstrapStyling="true" @selected="eventForm.errors.clear(\'end_date\')" :placeholder="trans(\'calendar.event_end_date\')"></datepicker>\n                                <show-error :form-name="eventForm" prop-name="end_date"></show-error>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-6" v-if="!eventForm.no_time">\n                            <div class="form-group">\n                                <label for="">{{trans(\'calendar.event_end_time\')}}</label>\n                                <timepicker :hour.sync="end_time.hour" :minute.sync="end_time.minute" :meridiem.sync="end_time.meridiem"></timepicker>\n                            </div>\n                        </div>\n                    </div>\n                    <div class="row">\n                        <div class="col-12 col-sm-6">\n                            <div class="form-group">\n                                <label for="">{{trans(\'calendar.event_audience\')}}</label>\n                                <select v-model="eventForm.audience" class="custom-select col-12" name="audience" @change="eventForm.errors.clear(\'audience\')">\n                                  <option value=null selected>{{trans(\'general.select_one\')}}</option>\n                                  <option v-for="option in audiences" v-bind:value="option.value">\n                                    {{ option.text }}\n                                  </option>\n                                </select>\n                                <show-error :form-name="eventForm" prop-name="audience"></show-error>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-6" v-if="eventForm.audience == \'selected_course\'">\n                            <div class="form-group">\n                                <label for="">{{trans(\'academic.course\')}}</label>\n                                <v-select label="name" track-by="id" v-model="selected_courses" group-values="courses" group-label="course_group" :group-select="false" name="course_id" id="course_id" :options="courses" :placeholder="trans(\'academic.select_course\')" @select="onCourseSelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onCourseRemove" :selected="selected_courses">\n                                    <div class="multiselect__option" slot="afterList" v-if="!courses.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                                <show-error :form-name="eventForm" prop-name="course_id"></show-error>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-6" v-if="eventForm.audience == \'selected_batch\'">\n                            <div class="form-group">\n                                <label for="">{{trans(\'academic.batch\')}}</label>\n                                <v-select label="name" track-by="id" v-model="selected_batches" group-values="batches" group-label="course_group" :group-select="false" name="batch_id" id="batch_id" :options="batches" :placeholder="trans(\'academic.select_batch\')" @select="onBatchSelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onBatchRemove" :selected="selected_batches">\n                                    <div class="multiselect__option" slot="afterList" v-if="!batches.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                                <show-error :form-name="eventForm" prop-name="batch_id"></show-error>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-6" v-if="eventForm.audience == \'selected_department\'">\n                            <div class="form-group">\n                                <label for="">{{trans(\'employee.department\')}}</label>\n                                <v-select label="name" track-by="id" v-model="selected_departments" name="department_id" id="department_id" :options="departments" :placeholder="trans(\'employee.select_department\')" @select="onDepartmentSelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onDepartmentRemove" :selected="selected_departments">\n                                    <div class="multiselect__option" slot="afterList" v-if="!departments.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                                <show-error :form-name="eventForm" prop-name="department_id"></show-error>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-6" v-if="eventForm.audience == \'selected_employee_category\'">\n                            <div class="form-group">\n                                <label for="">{{trans(\'employee.category\')}}</label>\n                                <v-select label="name" track-by="id" v-model="selected_employee_categories" name="employee_category_id" id="employee_category_id" :options="employee_categories" :placeholder="trans(\'employee.select_category\')" @select="onEmployeeCategorySelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onEmployeeCategoryRemove" :selected="selected_employee_categories">\n                                    <div class="multiselect__option" slot="afterList" v-if="!employee_categories.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                                <show-error :form-name="eventForm" prop-name="employee_category_id"></show-error>\n                            </div>\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <file-upload-input :button-text="trans(\'general.upload_document\')" :token="eventForm.upload_token" module="event" :clear-file="clearAttachment" :module-id="module_id"></file-upload-input>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <html-editor name="description" :model.sync="eventForm.description" height="300" :isUpdate="uuid ? true : false" @clearErrors="eventForm.errors.clear(\'description\')"></html-editor>\n                        <show-error :form-name="eventForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n\n            <div class="card-footer text-right">\n                <router-link to="/calendar/event" class="btn btn-danger waves-effect waves-light " v-show="uuid">{{trans(\'general.cancel\')}}</router-link>\n                <button v-if="!uuid" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="uuid">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n\n        <transition name="modal" v-if="showEventTypeModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'calendar.add_new_event_type\')}}\n                                <span class="float-right pointer" @click="showEventTypeModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <event-type-form @completed="getPreRequisite" @cancel="showEventTypeModal = false"></event-type-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n\n<script>\n    import eventTypeForm from \'../../configuration/calendar/event-type/form\'\n\n    export default {\n        components: {eventTypeForm},\n        data() {\n            return {\n                eventForm: new Form({\n                    event_type_id: \'\',\n                    title: \'\',\n                    no_time: 0,\n                    venue: \'\',\n                    start_date: \'\',\n                    end_date: \'\',\n                    start_time: \'\',\n                    end_time: \'\',\n                    audience: \'everyone\',\n                    course_id: [],\n                    batch_id: [],\n                    department_id: [],\n                    employee_category_id: [],\n                    description: \'\',\n                    upload_token: \'\'\n                }),\n                start_time: {\n                    hour: \'\',\n                    minute: \'\',\n                    meridiem: \'am\'\n                },\n                end_time: {\n                    hour: \'\',\n                    minute: \'\',\n                    meridiem: \'am\'\n                },\n                audiences: [],\n                event_types: [],\n                selected_event_type: null,\n                courses: [],\n                selected_courses: null,\n                batches: [],\n                selected_batches: null,\n                departments: [],\n                selected_departments: null,\n                employee_categories: [],\n                selected_employee_categories: null,\n                module_id: \'\',\n                clearAttachment: true,\n                showEventTypeModal: false\n            };\n        },\n        props: [\'uuid\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-event\') && !helper.hasPermission(\'edit-event\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                this.showEventTypeModal = false;\n                axios.get(\'/api/event/pre-requisite\')\n                    .then(response => {\n                        this.event_types = response.event_types;\n                        this.audiences = response.audiences;\n                        this.courses = response.courses;\n                        this.batches = response.batches;\n                        this.departments = response.departments;\n                        this.employee_categories = response.employee_categories;\n                        \n                        if(this.uuid)\n                            this.get();\n                        else\n                            this.eventForm.upload_token = this.$uuid.v4();\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            proceed(){\n                if(this.uuid)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                this.eventForm.start_time = helper.toTime(this.start_time);\n                this.eventForm.end_time   = helper.toTime(this.end_time);\n                let loader = this.$loading.show();\n                this.eventForm.post(\'/api/event\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.clearAttachment = !this.clearAttachment;\n                        this.eventForm.upload_token = this.$uuid.v4();\n                        this.selected_event_type = null;\n                        this.selected_courses = null;\n                        this.selected_batches = null;\n                        this.selected_departments = null;\n                        this.selected_employee_categories = null;\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/event/\'+this.uuid)\n                    .then(response => {\n                        this.eventForm.title = response.event.title;\n                        this.eventForm.venue = response.event.venue;\n                        this.eventForm.start_date = response.event.start_date;\n                        this.eventForm.end_date = response.event.end_date;\n                        this.eventForm.description = response.event.description;\n                        this.eventForm.event_type_id = response.event.event_type_id;\n                        this.selected_event_type = response.event.event_type_id ? {id: response.event.event_type_id, name: response.event.event_type.name} : null;\n                        this.eventForm.audience = response.event.audience;\n                        this.eventForm.no_time = response.event.start_time ? 0 : 1;\n                        this.selected_courses = response.event.audience == \'selected_course\' ? response.selected_audience : [];\n                        this.eventForm.course_id = response.event.audience == \'selected_course\' ? this.setMultiSelect(response.selected_audience) : [];\n                        this.selected_batches = response.event.audience == \'selected_batch\' ? response.selected_audience : [];\n                        this.eventForm.batch_id = response.event.audience == \'selected_batch\' ? this.setMultiSelect(response.selected_audience) : [];\n                        this.selected_departments = response.event.audience == \'selected_department\' ? response.selected_audience : [];\n                        this.eventForm.department_id = response.event.audience == \'selected_department\' ? this.setMultiSelect(response.selected_audience) : [];\n                        this.selected_employee_categories = response.event.audience == \'selected_employee_category\' ? response.selected_audience : [];\n                        this.eventForm.employee_category_id = response.event.audience == \'selected_employee_category\' ? this.setMultiSelect(response.selected_audience) : [];\n                        this.start_time = response.start_time;\n                        this.end_time = response.end_time;\n                        this.eventForm.upload_token = response.event.upload_token;\n                        this.module_id = response.event.id;\n\n                        if (! response.is_editable) {\n                            toastr.error(i18n.user.permission_denied);\n                            loader.hide();\n                            this.$router.push(\'/calendar/event\');\n                        }\n                        \n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/calendar/event\');\n                    });\n            },\n            update(){\n                this.eventForm.start_time = helper.toTime(this.start_time);\n                this.eventForm.end_time   = helper.toTime(this.end_time);\n                let loader = this.$loading.show();\n                this.eventForm.patch(\'/api/event/\'+this.uuid)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/calendar/event\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            onEventTypeSelect(selectedOption){\n                this.eventForm.event_type_id = selectedOption.id;\n            },\n            onCourseSelect(selectedOption){\n                this.eventForm.errors.clear(\'course_id\');\n                this.eventForm.course_id.push(selectedOption.id);\n            },\n            onCourseRemove(removedOption){\n                this.eventForm.course_id.splice(this.eventForm.course_id.indexOf(removedOption.id), 1);\n            },\n            onBatchSelect(selectedOption){\n                this.eventForm.errors.clear(\'batch_id\');\n                this.eventForm.batch_id.push(selectedOption.id);\n            },\n            onBatchRemove(removedOption){\n                this.eventForm.batch_id.splice(this.eventForm.batch_id.indexOf(removedOption.id), 1);\n            },\n            onDepartmentSelect(selectedOption){\n                this.eventForm.errors.clear(\'department_id\');\n                this.eventForm.department_id.push(selectedOption.id);\n            },\n            onDepartmentRemove(removedOption){\n                this.eventForm.department_id.splice(this.eventForm.department_id.indexOf(removedOption.id), 1);\n            },\n            onEmployeeCategorySelect(selectedOption){\n                this.eventForm.errors.clear(\'employee_category_id\');\n                this.eventForm.employee_category_id.push(selectedOption.id);\n            },\n            onEmployeeCategoryRemove(removedOption){\n                this.eventForm.employee_category_id.splice(this.eventForm.employee_category_id.indexOf(removedOption.id), 1);\n            },\n            setMultiSelect(options) {\n                let data = [];\n                options.forEach(option => {\n                    data.push(option.id);\n                })\n\n                return data;\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const i=a},67064:(e,t,n)=>{"use strict";n.r(t),n.d(t,{default:()=>r});const s={components:{eventForm:n(79989).Z},data:function(){return{uuid:this.$route.params.uuid}},mounted:function(){helper.hasPermission("edit-event")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const r=(0,n(51900).Z)(s,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("div",{staticClass:"page-titles"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("calendar.edit_event")))])]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"action-buttons pull-right"},[n("button",{staticClass:"btn btn-info btn-sm",on:{click:function(t){return e.$router.push("/calendar/event")}}},[n("i",{staticClass:"fas fa-list"}),e._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("calendar.event")))])])])])])]),e._v(" "),n("div",{staticClass:"container-fluid"},[n("div",{staticClass:"card card-form"},[n("div",{staticClass:"card-body"},[n("event-form",{attrs:{uuid:e.uuid}})],1)])])])}),[],!1,null,null,null).exports},79989:(e,t,n)=>{"use strict";n.d(t,{Z:()=>l});const s={components:{eventTypeForm:n(5798).Z},data:function(){return{eventForm:new Form({event_type_id:"",title:"",no_time:0,venue:"",start_date:"",end_date:"",start_time:"",end_time:"",audience:"everyone",course_id:[],batch_id:[],department_id:[],employee_category_id:[],description:"",upload_token:""}),start_time:{hour:"",minute:"",meridiem:"am"},end_time:{hour:"",minute:"",meridiem:"am"},audiences:[],event_types:[],selected_event_type:null,courses:[],selected_courses:null,batches:[],selected_batches:null,departments:[],selected_departments:null,employee_categories:[],selected_employee_categories:null,module_id:"",clearAttachment:!0,showEventTypeModal:!1}},props:["uuid"],mounted:function(){helper.hasPermission("create-event")||helper.hasPermission("edit-event")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},getPreRequisite:function(){var e=this,t=this.$loading.show();this.showEventTypeModal=!1,axios.get("/api/event/pre-requisite").then((function(n){e.event_types=n.event_types,e.audiences=n.audiences,e.courses=n.courses,e.batches=n.batches,e.departments=n.departments,e.employee_categories=n.employee_categories,e.uuid?e.get():e.eventForm.upload_token=e.$uuid.v4(),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},proceed:function(){this.uuid?this.update():this.store()},store:function(){var e=this;this.eventForm.start_time=helper.toTime(this.start_time),this.eventForm.end_time=helper.toTime(this.end_time);var t=this.$loading.show();this.eventForm.post("/api/event").then((function(n){toastr.success(n.message),e.clearAttachment=!e.clearAttachment,e.eventForm.upload_token=e.$uuid.v4(),e.selected_event_type=null,e.selected_courses=null,e.selected_batches=null,e.selected_departments=null,e.selected_employee_categories=null,e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/event/"+this.uuid).then((function(n){e.eventForm.title=n.event.title,e.eventForm.venue=n.event.venue,e.eventForm.start_date=n.event.start_date,e.eventForm.end_date=n.event.end_date,e.eventForm.description=n.event.description,e.eventForm.event_type_id=n.event.event_type_id,e.selected_event_type=n.event.event_type_id?{id:n.event.event_type_id,name:n.event.event_type.name}:null,e.eventForm.audience=n.event.audience,e.eventForm.no_time=n.event.start_time?0:1,e.selected_courses="selected_course"==n.event.audience?n.selected_audience:[],e.eventForm.course_id="selected_course"==n.event.audience?e.setMultiSelect(n.selected_audience):[],e.selected_batches="selected_batch"==n.event.audience?n.selected_audience:[],e.eventForm.batch_id="selected_batch"==n.event.audience?e.setMultiSelect(n.selected_audience):[],e.selected_departments="selected_department"==n.event.audience?n.selected_audience:[],e.eventForm.department_id="selected_department"==n.event.audience?e.setMultiSelect(n.selected_audience):[],e.selected_employee_categories="selected_employee_category"==n.event.audience?n.selected_audience:[],e.eventForm.employee_category_id="selected_employee_category"==n.event.audience?e.setMultiSelect(n.selected_audience):[],e.start_time=n.start_time,e.end_time=n.end_time,e.eventForm.upload_token=n.event.upload_token,e.module_id=n.event.id,n.is_editable||(toastr.error(i18n.user.permission_denied),t.hide(),e.$router.push("/calendar/event")),t.hide()})).catch((function(n){t.hide(),helper.showErrorMsg(n),e.$router.push("/calendar/event")}))},update:function(){var e=this;this.eventForm.start_time=helper.toTime(this.start_time),this.eventForm.end_time=helper.toTime(this.end_time);var t=this.$loading.show();this.eventForm.patch("/api/event/"+this.uuid).then((function(n){toastr.success(n.message),t.hide(),e.$router.push("/calendar/event")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},onEventTypeSelect:function(e){this.eventForm.event_type_id=e.id},onCourseSelect:function(e){this.eventForm.errors.clear("course_id"),this.eventForm.course_id.push(e.id)},onCourseRemove:function(e){this.eventForm.course_id.splice(this.eventForm.course_id.indexOf(e.id),1)},onBatchSelect:function(e){this.eventForm.errors.clear("batch_id"),this.eventForm.batch_id.push(e.id)},onBatchRemove:function(e){this.eventForm.batch_id.splice(this.eventForm.batch_id.indexOf(e.id),1)},onDepartmentSelect:function(e){this.eventForm.errors.clear("department_id"),this.eventForm.department_id.push(e.id)},onDepartmentRemove:function(e){this.eventForm.department_id.splice(this.eventForm.department_id.indexOf(e.id),1)},onEmployeeCategorySelect:function(e){this.eventForm.errors.clear("employee_category_id"),this.eventForm.employee_category_id.push(e.id)},onEmployeeCategoryRemove:function(e){this.eventForm.employee_category_id.splice(this.eventForm.employee_category_id.indexOf(e.id),1)},setMultiSelect:function(e){var t=[];return e.forEach((function(e){t.push(e.id)})),t}}};var r=n(93379),o=n.n(r),a=n(42406),i={insert:"head",singleton:!1};o()(a.Z,i);a.Z.locals;const l=(0,n(51900).Z)(s,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.eventForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_title")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.eventForm.title,expression:"eventForm.title"}],staticClass:"form-control",attrs:{type:"text",name:"title",placeholder:e.trans("calendar.event_title")},domProps:{value:e.eventForm.title},on:{input:function(t){t.target.composing||e.$set(e.eventForm,"title",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"title"}})],1),e._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_type"))+" ")]),e._v(" "),e.hasPermission("access-configuration")?n("button",{staticClass:"btn btn-xs btn-info pull-right",attrs:{type:"button"},on:{click:function(t){e.showEventTypeModal=!0}}},[e._v(e._s(e.trans("general.add_new")))]):e._e(),e._v(" "),n("v-select",{attrs:{label:"name",name:"event_type_id",id:"event_type_id",options:e.event_types,placeholder:e.trans("calendar.select_event_type")},on:{select:e.onEventTypeSelect,close:function(t){return e.eventForm.errors.clear("event_type_id")},remove:function(t){e.eventForm.event_type_id=""}},model:{value:e.selected_event_type,callback:function(t){e.selected_event_type=t},expression:"selected_event_type"}},[e.event_types.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"event_type_id"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_venue")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.eventForm.venue,expression:"eventForm.venue"}],staticClass:"form-control",attrs:{type:"text",name:"venue",placeholder:e.trans("calendar.event_venue")},domProps:{value:e.eventForm.venue},on:{input:function(t){t.target.composing||e.$set(e.eventForm,"venue",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"venue"}})],1)])]),e._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_start_date")))]),e._v(" "),n("label",{staticClass:"custom-control custom-checkbox float-right"},[n("input",{directives:[{name:"model",rawName:"v-model",value:e.eventForm.no_time,expression:"eventForm.no_time"}],staticClass:"custom-control-input",attrs:{type:"checkbox",value:"1"},domProps:{checked:Array.isArray(e.eventForm.no_time)?e._i(e.eventForm.no_time,"1")>-1:e.eventForm.no_time},on:{change:function(t){var n=e.eventForm.no_time,s=t.target,r=!!s.checked;if(Array.isArray(n)){var o=e._i(n,"1");s.checked?o<0&&e.$set(e.eventForm,"no_time",n.concat(["1"])):o>-1&&e.$set(e.eventForm,"no_time",n.slice(0,o).concat(n.slice(o+1)))}else e.$set(e.eventForm,"no_time",r)}}}),e._v(" "),n("span",{staticClass:"custom-control-label"},[e._v(e._s(e.trans("calendar.event_no_time")))])]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("calendar.event_start_date")},on:{selected:function(t){return e.eventForm.errors.clear("start_date")}},model:{value:e.eventForm.start_date,callback:function(t){e.$set(e.eventForm,"start_date",t)},expression:"eventForm.start_date"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"start_date"}})],1)]),e._v(" "),e.eventForm.no_time?e._e():n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_start_time")))]),e._v(" "),n("timepicker",{attrs:{hour:e.start_time.hour,minute:e.start_time.minute,meridiem:e.start_time.meridiem},on:{"update:hour":function(t){return e.$set(e.start_time,"hour",t)},"update:minute":function(t){return e.$set(e.start_time,"minute",t)},"update:meridiem":function(t){return e.$set(e.start_time,"meridiem",t)}}})],1)])]),e._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_end_date")))]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("calendar.event_end_date")},on:{selected:function(t){return e.eventForm.errors.clear("end_date")}},model:{value:e.eventForm.end_date,callback:function(t){e.$set(e.eventForm,"end_date",t)},expression:"eventForm.end_date"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"end_date"}})],1)]),e._v(" "),e.eventForm.no_time?e._e():n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_end_time")))]),e._v(" "),n("timepicker",{attrs:{hour:e.end_time.hour,minute:e.end_time.minute,meridiem:e.end_time.meridiem},on:{"update:hour":function(t){return e.$set(e.end_time,"hour",t)},"update:minute":function(t){return e.$set(e.end_time,"minute",t)},"update:meridiem":function(t){return e.$set(e.end_time,"meridiem",t)}}})],1)])]),e._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_audience")))]),e._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:e.eventForm.audience,expression:"eventForm.audience"}],staticClass:"custom-select col-12",attrs:{name:"audience"},on:{change:[function(t){var n=Array.prototype.filter.call(t.target.options,(function(e){return e.selected})).map((function(e){return"_value"in e?e._value:e.value}));e.$set(e.eventForm,"audience",t.target.multiple?n:n[0])},function(t){return e.eventForm.errors.clear("audience")}]}},[n("option",{attrs:{value:"null",selected:""}},[e._v(e._s(e.trans("general.select_one")))]),e._v(" "),e._l(e.audiences,(function(t){return n("option",{domProps:{value:t.value}},[e._v("\n                                "+e._s(t.text)+"\n                              ")])}))],2),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"audience"}})],1)]),e._v(" "),"selected_course"==e.eventForm.audience?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.course")))]),e._v(" "),n("v-select",{attrs:{label:"name","track-by":"id","group-values":"courses","group-label":"course_group","group-select":!1,name:"course_id",id:"course_id",options:e.courses,placeholder:e.trans("academic.select_course"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_courses},on:{select:e.onCourseSelect,remove:e.onCourseRemove},model:{value:e.selected_courses,callback:function(t){e.selected_courses=t},expression:"selected_courses"}},[e.courses.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"course_id"}})],1)]):e._e(),e._v(" "),"selected_batch"==e.eventForm.audience?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.batch")))]),e._v(" "),n("v-select",{attrs:{label:"name","track-by":"id","group-values":"batches","group-label":"course_group","group-select":!1,name:"batch_id",id:"batch_id",options:e.batches,placeholder:e.trans("academic.select_batch"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_batches},on:{select:e.onBatchSelect,remove:e.onBatchRemove},model:{value:e.selected_batches,callback:function(t){e.selected_batches=t},expression:"selected_batches"}},[e.batches.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"batch_id"}})],1)]):e._e(),e._v(" "),"selected_department"==e.eventForm.audience?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("employee.department")))]),e._v(" "),n("v-select",{attrs:{label:"name","track-by":"id",name:"department_id",id:"department_id",options:e.departments,placeholder:e.trans("employee.select_department"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_departments},on:{select:e.onDepartmentSelect,remove:e.onDepartmentRemove},model:{value:e.selected_departments,callback:function(t){e.selected_departments=t},expression:"selected_departments"}},[e.departments.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"department_id"}})],1)]):e._e(),e._v(" "),"selected_employee_category"==e.eventForm.audience?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("employee.category")))]),e._v(" "),n("v-select",{attrs:{label:"name","track-by":"id",name:"employee_category_id",id:"employee_category_id",options:e.employee_categories,placeholder:e.trans("employee.select_category"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_employee_categories},on:{select:e.onEmployeeCategorySelect,remove:e.onEmployeeCategoryRemove},model:{value:e.selected_employee_categories,callback:function(t){e.selected_employee_categories=t},expression:"selected_employee_categories"}},[e.employee_categories.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"employee_category_id"}})],1)]):e._e()]),e._v(" "),n("div",{staticClass:"form-group"},[n("file-upload-input",{attrs:{"button-text":e.trans("general.upload_document"),token:e.eventForm.upload_token,module:"event","clear-file":e.clearAttachment,"module-id":e.module_id}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("html-editor",{attrs:{name:"description",model:e.eventForm.description,height:"300",isUpdate:!!e.uuid},on:{"update:model":function(t){return e.$set(e.eventForm,"description",t)},clearErrors:function(t){return e.eventForm.errors.clear("description")}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.eventForm,"prop-name":"description"}})],1)])]),e._v(" "),n("div",{staticClass:"card-footer text-right"},[n("router-link",{directives:[{name:"show",rawName:"v-show",value:e.uuid,expression:"uuid"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/calendar/event"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.uuid?e._e():n("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.uuid?n("span",[e._v(e._s(e.trans("general.update")))]):n("span",[e._v(e._s(e.trans("general.save")))])])],1)]),e._v(" "),e.showEventTypeModal?n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                            "+e._s(e.trans("calendar.add_new_event_type"))+"\n                            "),n("span",{staticClass:"float-right pointer",on:{click:function(t){e.showEventTypeModal=!1}}},[e._v("x")])]}))],2),e._v(" "),n("div",{staticClass:"modal-body"},[e._t("body",(function(){return[n("event-type-form",{on:{completed:e.getPreRequisite,cancel:function(t){e.showEventTypeModal=!1}}}),e._v(" "),n("div",{staticClass:"clearfix"})]}))],2)])])])]):e._e()],1)}),[],!1,null,null,null).exports},5798:(e,t,n)=>{"use strict";n.d(t,{Z:()=>r});const s={data:function(){return{eventTypeForm:new Form({name:"",description:""})}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var e=this,t=this.$loading.show();this.eventTypeForm.post("/api/calendar/event/type").then((function(n){toastr.success(n.message),e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/calendar/event/type/"+this.id).then((function(n){e.eventTypeForm.name=n.name,e.eventTypeForm.description=n.description,t.hide()})).catch((function(n){t.hide(),helper.showErrorMsg(n),e.$router.push("/configuration/calendar/event/type")}))},update:function(){var e=this,t=this.$loading.show();this.eventTypeForm.patch("/api/calendar/event/type/"+this.id).then((function(n){toastr.success(n.message),t.hide(),e.$router.push("/configuration/calendar/event/type")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))}}};const r=(0,n(51900).Z)(s,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.eventTypeForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_type_name")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.eventTypeForm.name,expression:"eventTypeForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:e.trans("calendar.event_type_name")},domProps:{value:e.eventTypeForm.name},on:{input:function(t){t.target.composing||e.$set(e.eventTypeForm,"name",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.eventTypeForm,"prop-name":"name"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("calendar.event_type_description")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.eventTypeForm.description,expression:"eventTypeForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:e.trans("calendar.event_type_description")},domProps:{value:e.eventTypeForm.description},on:{input:function(t){t.target.composing||e.$set(e.eventTypeForm,"description",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.eventTypeForm,"prop-name":"description"}})],1)])]),e._v(" "),n("div",{staticClass:"card-footer text-right"},[n("router-link",{directives:[{name:"show",rawName:"v-show",value:e.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/configuration/calendar/event/type"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.id?e._e():n("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.id?n("span",[e._v(e._s(e.trans("general.update")))]):n("span",[e._v(e._s(e.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=7046dfdff09ff97004f8