(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[6140],{89035:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var a=e(94015),o=e.n(a),r=e(23645),s=e.n(r)()(o());s.push([t.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/configuration/finance/transaction/category/form.vue"],names:[],mappings:"AA0HA,8BACA,YACA",sourcesContent:['<template>\n    <form @submit.prevent="proceed" @keydown="transactionCategoryForm.errors.clear($event.target.name)">\n        <div class="row">\n            <div class="col-12 col-sm-4">\n                <div class="form-group">\n                    <label for="">{{trans(\'finance.transaction_category_name\')}}</label>\n                    <input class="form-control" type="text" v-model="transactionCategoryForm.name" name="name" :placeholder="trans(\'finance.transaction_category_name\')">\n                    <show-error :form-name="transactionCategoryForm" prop-name="name"></show-error>\n                </div>\n            </div>\n            <div class="col-12 col-sm-4">\n                <div class="form-group">\n                    <label for="">{{trans(\'finance.transaction_category_type\')}}</label>\n                    <select v-model="transactionCategoryForm.type" class="col-12 custom-select" @change="transactionCategoryForm.errors.clear(\'type\')" name="type">\n                      <option value=null selected>{{trans(\'general.select_one\')}}</option>\n                      <option v-for="type in types" v-bind:value="type.value">\n                        {{ type.text }}\n                      </option>\n                    </select>\n                    <show-error :form-name="transactionCategoryForm" prop-name="type"></show-error>\n                </div>\n            </div>\n            <div class="col-12 col-sm-4">\n                <div class="form-group">\n                    <label for="">{{trans(\'finance.transaction_category_description\')}}</label>\n                    <input class="form-control" type="text" v-model="transactionCategoryForm.description" name="description" :placeholder="trans(\'finance.transaction_category_description\')">\n                    <show-error :form-name="transactionCategoryForm" prop-name="description"></show-error>\n                </div>\n            </div>\n        </div>\n\n        <div class="card-footer text-right">\n            <button v-if="!id" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n            <router-link to="/configuration/finance/transaction/category" class="btn btn-danger waves-effect waves-light " v-show="id">{{trans(\'general.cancel\')}}</router-link>\n            <button type="submit" class="btn btn-info waves-effect waves-light">\n                <span v-if="id">{{trans(\'general.update\')}}</span>\n                <span v-else>{{trans(\'general.save\')}}</span>\n            </button>\n        </div>\n    </form>\n</template>\n\n\n<script>\n    export default {\n        data() {\n            return {\n                transactionCategoryForm: new Form({\n                    name : \'\',\n                    type: \'\',\n                    description : \'\'\n                }),\n                types: [\n                    {\n                        text: i18n.finance.income,\n                        value: \'income\'\n                    },\n                    {\n                        text: i18n.finance.expense,\n                        value: \'expense\'\n                    }\n                ]\n            };\n        },\n        props: [\'id\'],\n        mounted() {\n            if(this.id)\n                this.get();\n        },\n        methods: {\n            proceed(){\n                if(this.id)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.transactionCategoryForm.post(\'/api/finance/transaction/category\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/finance/transaction/category/\'+this.id)\n                    .then(response => {\n                        this.transactionCategoryForm.name = response.name;\n                        this.transactionCategoryForm.type = response.type;\n                        this.transactionCategoryForm.description = response.description;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/configuration/finance/transaction/category\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.transactionCategoryForm.patch(\'/api/finance/transaction/category/\'+this.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/configuration/finance/transaction/category\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>\n'],sourceRoot:""}]);const i=s},14518:(t,n,e)=>{"use strict";e.d(n,{Z:()=>c});const a={data:function(){return{transactionCategoryForm:new Form({name:"",type:"",description:""}),types:[{text:i18n.finance.income,value:"income"},{text:i18n.finance.expense,value:"expense"}]}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var t=this,n=this.$loading.show();this.transactionCategoryForm.post("/api/finance/transaction/category").then((function(e){toastr.success(e.message),t.$emit("completed"),n.hide()})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,n=this.$loading.show();axios.get("/api/finance/transaction/category/"+this.id).then((function(e){t.transactionCategoryForm.name=e.name,t.transactionCategoryForm.type=e.type,t.transactionCategoryForm.description=e.description,n.hide()})).catch((function(e){n.hide(),helper.showErrorMsg(e),t.$router.push("/configuration/finance/transaction/category")}))},update:function(){var t=this,n=this.$loading.show();this.transactionCategoryForm.patch("/api/finance/transaction/category/"+this.id).then((function(e){toastr.success(e.message),n.hide(),t.$router.push("/configuration/finance/transaction/category")})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))}}};var o=e(93379),r=e.n(o),s=e(89035),i={insert:"head",singleton:!1};r()(s.Z,i);s.Z.locals;const c=(0,e(51900).Z)(a,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("form",{on:{submit:function(n){return n.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(n){return t.transactionCategoryForm.errors.clear(n.target.name)}}},[e("div",{staticClass:"row"},[e("div",{staticClass:"col-12 col-sm-4"},[e("div",{staticClass:"form-group"},[e("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.transaction_category_name")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.transactionCategoryForm.name,expression:"transactionCategoryForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("finance.transaction_category_name")},domProps:{value:t.transactionCategoryForm.name},on:{input:function(n){n.target.composing||t.$set(t.transactionCategoryForm,"name",n.target.value)}}}),t._v(" "),e("show-error",{attrs:{"form-name":t.transactionCategoryForm,"prop-name":"name"}})],1)]),t._v(" "),e("div",{staticClass:"col-12 col-sm-4"},[e("div",{staticClass:"form-group"},[e("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.transaction_category_type")))]),t._v(" "),e("select",{directives:[{name:"model",rawName:"v-model",value:t.transactionCategoryForm.type,expression:"transactionCategoryForm.type"}],staticClass:"col-12 custom-select",attrs:{name:"type"},on:{change:[function(n){var e=Array.prototype.filter.call(n.target.options,(function(t){return t.selected})).map((function(t){return"_value"in t?t._value:t.value}));t.$set(t.transactionCategoryForm,"type",n.target.multiple?e:e[0])},function(n){return t.transactionCategoryForm.errors.clear("type")}]}},[e("option",{attrs:{value:"null",selected:""}},[t._v(t._s(t.trans("general.select_one")))]),t._v(" "),t._l(t.types,(function(n){return e("option",{domProps:{value:n.value}},[t._v("\n                    "+t._s(n.text)+"\n                  ")])}))],2),t._v(" "),e("show-error",{attrs:{"form-name":t.transactionCategoryForm,"prop-name":"type"}})],1)]),t._v(" "),e("div",{staticClass:"col-12 col-sm-4"},[e("div",{staticClass:"form-group"},[e("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.transaction_category_description")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.transactionCategoryForm.description,expression:"transactionCategoryForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:t.trans("finance.transaction_category_description")},domProps:{value:t.transactionCategoryForm.description},on:{input:function(n){n.target.composing||t.$set(t.transactionCategoryForm,"description",n.target.value)}}}),t._v(" "),e("show-error",{attrs:{"form-name":t.transactionCategoryForm,"prop-name":"description"}})],1)])]),t._v(" "),e("div",{staticClass:"card-footer text-right"},[t.id?t._e():e("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(n){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),e("router-link",{directives:[{name:"show",rawName:"v-show",value:t.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/configuration/finance/transaction/category"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),e("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.id?e("span",[t._v(t._s(t.trans("general.update")))]):e("span",[t._v(t._s(t.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports},94434:(t,n,e)=>{"use strict";e.r(n),e.d(n,{default:()=>o});const a={components:{transactionCategoryForm:e(14518).Z},data:function(){return{transaction_categories:{total:0,data:[]},filter:{sort_by:"name",order:"desc",page_length:helper.getConfig("page_length")},orderByOptions:[{value:"name",translation:i18n.finance.transaction_category_name},{value:"type",translation:i18n.finance.transaction_category_type}],showCreatePanel:!1,help_topic:""}},mounted:function(){helper.hasPermission("access-configuration")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getTransactionCategories()},methods:{getConfig:function(t){return helper.getConfig(t)},getTransactionCategories:function(t){var n=this,e=this.$loading.show();"number"!=typeof t&&(t=1);var a=helper.getFilterURL(this.filter);axios.get("/api/finance/transaction/category?page="+t+a).then((function(t){n.transaction_categories=t,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},editTransactionCategory:function(t){this.$router.push("/configuration/finance/transaction/category/"+t.id+"/edit")},confirmDelete:function(t){var n=this;return function(e){return n.deleteTransactionCategory(t)}},deleteTransactionCategory:function(t){var n=this,e=this.$loading.show();axios.delete("/api/finance/transaction/category/"+t.id).then((function(t){toastr.success(t.message),n.getTransactionCategories(),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},print:function(){var t=this.$loading.show();axios.post("/api/finance/transaction/category/print",{filter:this.filter}).then((function(n){var e=window.open("/print");t.hide(),e.document.write(n)})).catch((function(n){t.hide(),helper.showErrorMsg(n)}))},pdf:function(){var t=this,n=this.$loading.show();axios.post("/api/finance/transaction/category/pdf",{filter:this.filter}).then((function(e){n.hide(),window.open("/download/report/"+e+"?token="+t.authToken)})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))}},filters:{momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{"filter.sort_by":function(t){this.getTransactionCategories()},"filter.order":function(t){this.getTransactionCategories()},"filter.page_length":function(t){this.getTransactionCategories()}},computed:{authToken:function(){return helper.getAuthToken()}}};const o=(0,e(51900).Z)(a,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",[e("div",{staticClass:"page-titles"},[e("div",{staticClass:"row"},[e("div",{staticClass:"col-12 col-sm-6"},[e("h3",{staticClass:"text-themecolor"},[t._v(t._s(t.trans("finance.transaction_category"))+"\n                    "),t.transaction_categories.total?e("span",{staticClass:"card-subtitle d-none d-sm-inline"},[t._v(t._s(t.trans("general.total_result_found",{count:t.transaction_categories.total,from:t.transaction_categories.from,to:t.transaction_categories.to})))]):e("span",{staticClass:"card-subtitle d-none d-sm-inline"},[t._v(t._s(t.trans("general.no_result_found")))])])]),t._v(" "),e("div",{staticClass:"col-12 col-sm-6"},[e("div",{staticClass:"action-buttons pull-right"},[t.transaction_categories.total&&!t.showCreatePanel?e("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.add_new"),expression:"trans('general.add_new')"}],staticClass:"btn btn-info btn-sm",on:{click:function(n){t.showCreatePanel=!t.showCreatePanel}}},[e("i",{staticClass:"fas fa-plus"}),t._v(" "),e("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("finance.add_new_transaction_category")))])]):t._e(),t._v(" "),e("sort-by",{attrs:{"order-by-options":t.orderByOptions,"sort-by":t.filter.sort_by,order:t.filter.order},on:{updateSortBy:function(n){t.filter.sort_by=n},updateOrder:function(n){t.filter.order=n}}}),t._v(" "),e("div",{staticClass:"btn-group"},[e("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-sm dropdown-toggle no-caret ",attrs:{type:"button",role:"menu",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[e("i",{staticClass:"fas fa-ellipsis-h"}),t._v(" "),e("span",{staticClass:"d-none d-sm-inline"})]),t._v(" "),e("div",{class:["dropdown-menu","ltr"==t.getConfig("direction")?"dropdown-menu-right":""],attrs:{"aria-labelledby":"moreOption"}},[e("button",{staticClass:"dropdown-item custom-dropdown",on:{click:t.print}},[e("i",{staticClass:"fas fa-print"}),t._v(" "+t._s(t.trans("general.print")))]),t._v(" "),e("button",{staticClass:"dropdown-item custom-dropdown",on:{click:t.pdf}},[e("i",{staticClass:"fas fa-file-pdf"}),t._v(" "+t._s(t.trans("general.generate_pdf")))])])]),t._v(" "),e("help-button",{on:{clicked:function(n){t.help_topic="configuration.finance.transaction.category"}}})],1)])])]),t._v(" "),e("div",{staticClass:"container-fluid"},[e("transition",{attrs:{name:"fade"}},[t.showCreatePanel?e("div",{staticClass:"card card-form"},[e("div",{staticClass:"card-body"},[e("h4",{staticClass:"card-title"},[t._v(t._s(t.trans("finance.add_new_transaction_category")))]),t._v(" "),e("transaction-category-form",{on:{completed:t.getTransactionCategories,cancel:function(n){t.showCreatePanel=!t.showCreatePanel}}})],1)]):t._e()]),t._v(" "),e("div",{staticClass:"card"},[e("div",{staticClass:"card-body"},[t.transaction_categories.total?e("div",{staticClass:"table-responsive"},[e("table",{staticClass:"table table-sm"},[e("thead",[e("tr",[e("th",[t._v(t._s(t.trans("finance.transaction_category_name")))]),t._v(" "),e("th",[t._v(t._s(t.trans("finance.transaction_category_type")))]),t._v(" "),e("th",[t._v(t._s(t.trans("finance.transaction_category_description")))]),t._v(" "),e("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),e("tbody",t._l(t.transaction_categories.data,(function(n){return e("tr",[e("td",{domProps:{textContent:t._s(n.name)}}),t._v(" "),e("td",[t._v("\n                                    "+t._s(t.trans("finance."+n.type))+"\n                                ")]),t._v(" "),e("td",{domProps:{textContent:t._s(n.description)}}),t._v(" "),e("td",{staticClass:"table-option"},[e("div",{staticClass:"btn-group"},[e("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("finance.edit_transaction_category"),expression:"trans('finance.edit_transaction_category')"}],staticClass:"btn btn-info btn-sm",on:{click:function(e){return e.preventDefault(),t.editTransactionCategory(n)}}},[e("i",{staticClass:"fas fa-edit"})]),t._v(" "),e("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:t.confirmDelete(n)},expression:"{ok: confirmDelete(transaction_category)}"},{name:"tooltip",rawName:"v-tooltip",value:t.trans("finance.delete_transaction_category"),expression:"trans('finance.delete_transaction_category')"}],key:n.id,staticClass:"btn btn-danger btn-sm"},[e("i",{staticClass:"fas fa-trash"})])])])])})),0)])]):t._e(),t._v(" "),t.transaction_categories.total?t._e():e("module-info",{attrs:{module:"finance",title:"transaction_category_module_title",description:"transaction_category_module_description",icon:"list"}},[e("div",{attrs:{slot:"btn"},slot:"btn"},[t.showCreatePanel?t._e():e("button",{staticClass:"btn btn-info btn-md",on:{click:function(n){t.showCreatePanel=!t.showCreatePanel}}},[e("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("general.add_new")))])])]),t._v(" "),e("pagination-record",{attrs:{"page-length":t.filter.page_length,records:t.transaction_categories},on:{"update:pageLength":function(n){return t.$set(t.filter,"page_length",n)},"update:page-length":function(n){return t.$set(t.filter,"page_length",n)},updateRecords:t.getTransactionCategories},nativeOn:{change:function(n){return t.getTransactionCategories.apply(null,arguments)}}})],1)])],1),t._v(" "),e("right-panel",{attrs:{topic:t.help_topic}})],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=index.js.map?id=51ac9c1958bfcc856e8b