(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[4692],{96495:(e,t,n)=>{"use strict";n.d(t,{Z:()=>l});var s=n(94015),a=n.n(s),i=n(23645),o=n.n(i)()(a());o.push([e.id,".attendance-table tr th.date-cell{max-width:20px;min-width:20px;text-align:center}.attendance-table tr td{vertical-align:middle}.attendance-table tr td span.marking-cell{display:block;height:100%;text-align:center;width:100%}","",{version:3,sources:["webpack://./resources/js/views/employee/attendance/index.vue"],names:[],mappings:"AAiNA,kCAGA,cAAA,CADA,cAAA,CADA,iBAGA,CACA,wBACA,qBACA,CACA,0CACA,aAAA,CAEA,WAAA,CACA,iBAAA,CAFA,UAGA",sourcesContent:['<template>\n    <div>\n        <div class="page-titles">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <h3 class="text-themecolor">{{trans(\'employee.list_attendance\')}}</h3>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="action-buttons pull-right">\n                        <button class="btn btn-info btn-sm" @click="$router.push(\'/employee/attendance/regular\')"><i class="fas fa-check"></i> <span class="d-none d-sm-inline">{{trans(\'employee.mark_attendance\')}}</span></button>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="container-fluid">\n            <div class="card">\n                <div class="card-body p-4">\n                    <div class="row">\n                        <div class="col-12 col-sm-3">\n                            <div class="form-group">\n                                <label for="">{{trans(\'employee.category\')}}</label>\n                                <v-select label="name" track-by="id" v-model="selected_employee_categories" name="employee_category_id" id="employee_category_id" :options="employee_categories" :placeholder="trans(\'employee.select_employee_category\')" @select="onEmployeeCategorySelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onEmployeeCategoryRemove" :selected="selected_employee_categories">\n                                    <div class="multiselect__option" slot="afterList" v-if="!employee_categories.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-3">\n                            <div class="form-group">\n                                <label for="">{{trans(\'employee.designation\')}}</label>\n                                <v-select label="name" track-by="id" v-model="selected_designations" name="designation_id" id="designation_id" :options="designations" :placeholder="trans(\'employee.select_designation\')" @select="onDesignationSelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onDesignationRemove" :selected="selected_designations">\n                                    <div class="multiselect__option" slot="afterList" v-if="!designations.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-3">\n                            <div class="form-group">\n                                <label for="">{{trans(\'employee.department\')}}</label>\n                                <v-select label="name" track-by="id" v-model="selected_departments" name="department_id" id="department_id" :options="departments" :placeholder="trans(\'employee.select_department\')" @select="onDepartmentSelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onDepartmentRemove" :selected="selected_departments">\n                                    <div class="multiselect__option" slot="afterList" v-if="!departments.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-3">\n                            <div class="form-group">\n                                <label for="">{{trans(\'employee.attendance_month\')}}</label>\n                                <vue-monthly-picker v-model="filter.month" name="month" :placeHolder="trans(\'employee.attendance_month\')" dateFormat="YYYY-MM "></vue-monthly-picker>\n                            </div>\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <button type="button" class="btn btn-info pull-right" @click="list">{{trans(\'general.filter\')}}</button>\n                    </div>\n                    <div class="clearfix"></div>\n\n                    <div class="row m-t-20" v-if="employees.length">\n                        <div class="col-12">\n                            <div class="table-responsive font-90pc p-2">\n                                <table class="table table-sm table-bordered attendance-table">\n                                    <thead>\n                                        <tr>\n                                            <th>{{trans(\'employee.employee\')}}</th>\n                                            <th class="date-cell" v-for="index in days">{{index}}</th>\n                                            <th class="text-center font-weight-bold" v-for="attendance in attendance_summary_with_name" v-tooltip="attendance.name">\n                                                {{attendance.symbol}}\n                                            </th>\n                                        </tr>   \n                                    </thead>\n                                    <tbody>\n                                        <tr v-for="employee in employees">\n                                            <td>\n                                                {{getEmployeeNameWithCode(employee)}} <br /> \n                                                <span class="font-90pc">{{getEmployeeDesignationOnDate(employee, date)}}</span>\n                                            </td>\n                                            <td :class="`text-center font-weight-bold text-${attendance.color}`" v-for="attendance in employee.attendances">\n                                                <span class="marking-cell" v-tooltip="attendance.description" v-if="attendance.symbol == \'H\'">\n                                                    <i class="fas fa-hospital-symbol"></i>\n                                                </span>\n                                                <span class="marking-cell" v-tooltip="attendance.description" v-else>\n                                                    {{attendance.symbol}}\n                                                </span>\n                                            </td>\n                                            <td class="text-center font-weight-bold" v-for="attendance in attendance_summary_with_name">\n                                                {{getAttendanceSummary(employee, attendance.symbol)}}\n                                            </td>\n                                        </tr>\n                                    </tbody>\n                                </table>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</template>\n\n<script>\n    export default {\n        components: {},\n        data(){\n            return {\n                filter: {\n                    department_id: [],\n                    designation_id: [],\n                    employee_category_id: [],\n                    month: \'\'\n                },\n                date: \'\',\n                days: 0,\n                employees: [],\n                departments: [],\n                designations: [],\n                employee_categories: [],\n                selected_designations: null,\n                selected_departments: null,\n                selected_employee_categories: null,\n                attendance_summary_with_name: []\n            }\n        },\n        mounted(){\n            this.filter.month = moment().format(\'YYYY-MM\');\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getEmployeeNameWithCode(employee){\n                return helper.getEmployeeNameWithCode(employee);\n            },\n            getEmployeeDesignationOnDate(employee, date){\n                return helper.getEmployeeDesignationOnDate(employee, date);\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/employee/attendance/regular/pre-requisite\')\n                    .then(response => {\n                        this.departments = response.departments;\n                        this.designations = response.designations;\n                        this.employee_categories = response.employee_categories;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            list(){\n                let loader = this.$loading.show();\n                this.filter.month = moment(this.filter.month).format(\'YYYY-MM\');\n                axios.post(\'/api/employee/attendance/regular/list\',{\n                        department_id: this.filter.department_id,\n                        designation_id: this.filter.designation_id,\n                        employee_category_id: this.filter.employee_category_id,\n                        month: this.filter.month,\n                    })\n                    .then(response => {\n                        this.employees = response.employees;\n                        this.attendance_summary_with_name = response.attendance_summary_with_name;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg();\n                    })\n            },\n            onDepartmentSelect(selectedOption){\n                this.filter.department_id.push(selectedOption.id);\n            },\n            onDepartmentRemove(removedOption){\n                this.filter.department_id.splice(this.filter.department_id.indexOf(removedOption.id), 1);\n            },\n            onDesignationSelect(selectedOption){\n                this.filter.designation_id.push(selectedOption.id);\n            },\n            onDesignationRemove(removedOption){\n                this.filter.designation_id.splice(this.filter.designation_id.indexOf(removedOption.id), 1);\n            },\n            onEmployeeCategorySelect(selectedOption){\n                this.filter.employee_category_id.push(selectedOption.id);\n            },\n            onEmployeeCategoryRemove(removedOption){\n                this.filter.employee_category_id.splice(this.filter.employee_category_id.indexOf(removedOption.id), 1);\n            },\n            getAttendanceSummary(employee, symbol){\n                let attendance = employee.summary.find(o => o.symbol == symbol);\n\n                if (typeof attendance == \'undefined\')\n                    return 0;\n\n                return attendance.value;\n            }\n        },\n        watch: {\n            \'filter.month\': function(val){\n                this.date = moment(val, \'YYYY-MM\')+\'-01\';\n                this.days = moment(val,\'YYYY-MM\').daysInMonth();\n            }\n        }\n    }\n<\/script>\n\n<style>\n    .attendance-table tr th.date-cell{\n        text-align: center;\n        min-width: 20px;\n        max-width: 20px;\n    }\n    .attendance-table tr td {\n        vertical-align: middle;\n    }\n    .attendance-table tr td span.marking-cell {\n        display: block;\n        width: 100%;\n        height: 100%;\n        text-align: center;\n    }\n</style>'],sourceRoot:""}]);const l=o},84863:(e,t,n)=>{"use strict";n.r(t),n.d(t,{default:()=>r});const s={components:{},data:function(){return{filter:{department_id:[],designation_id:[],employee_category_id:[],month:""},date:"",days:0,employees:[],departments:[],designations:[],employee_categories:[],selected_designations:null,selected_departments:null,selected_employee_categories:null,attendance_summary_with_name:[]}},mounted:function(){this.filter.month=moment().format("YYYY-MM"),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},getEmployeeNameWithCode:function(e){return helper.getEmployeeNameWithCode(e)},getEmployeeDesignationOnDate:function(e,t){return helper.getEmployeeDesignationOnDate(e,t)},getPreRequisite:function(){var e=this,t=this.$loading.show();axios.get("/api/employee/attendance/regular/pre-requisite").then((function(n){e.departments=n.departments,e.designations=n.designations,e.employee_categories=n.employee_categories,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},list:function(){var e=this,t=this.$loading.show();this.filter.month=moment(this.filter.month).format("YYYY-MM"),axios.post("/api/employee/attendance/regular/list",{department_id:this.filter.department_id,designation_id:this.filter.designation_id,employee_category_id:this.filter.employee_category_id,month:this.filter.month}).then((function(n){e.employees=n.employees,e.attendance_summary_with_name=n.attendance_summary_with_name,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg()}))},onDepartmentSelect:function(e){this.filter.department_id.push(e.id)},onDepartmentRemove:function(e){this.filter.department_id.splice(this.filter.department_id.indexOf(e.id),1)},onDesignationSelect:function(e){this.filter.designation_id.push(e.id)},onDesignationRemove:function(e){this.filter.designation_id.splice(this.filter.designation_id.indexOf(e.id),1)},onEmployeeCategorySelect:function(e){this.filter.employee_category_id.push(e.id)},onEmployeeCategoryRemove:function(e){this.filter.employee_category_id.splice(this.filter.employee_category_id.indexOf(e.id),1)},getAttendanceSummary:function(e,t){var n=e.summary.find((function(e){return e.symbol==t}));return void 0===n?0:n.value}},watch:{"filter.month":function(e){this.date=moment(e,"YYYY-MM")+"-01",this.days=moment(e,"YYYY-MM").daysInMonth()}}};var a=n(93379),i=n.n(a),o=n(96495),l={insert:"head",singleton:!1};i()(o.Z,l);o.Z.locals;const r=(0,n(51900).Z)(s,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("div",{staticClass:"page-titles"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("employee.list_attendance")))])]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"action-buttons pull-right"},[n("button",{staticClass:"btn btn-info btn-sm",on:{click:function(t){return e.$router.push("/employee/attendance/regular")}}},[n("i",{staticClass:"fas fa-check"}),e._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("employee.mark_attendance")))])])])])])]),e._v(" "),n("div",{staticClass:"container-fluid"},[n("div",{staticClass:"card"},[n("div",{staticClass:"card-body p-4"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("employee.category")))]),e._v(" "),n("v-select",{attrs:{label:"name","track-by":"id",name:"employee_category_id",id:"employee_category_id",options:e.employee_categories,placeholder:e.trans("employee.select_employee_category"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_employee_categories},on:{select:e.onEmployeeCategorySelect,remove:e.onEmployeeCategoryRemove},model:{value:e.selected_employee_categories,callback:function(t){e.selected_employee_categories=t},expression:"selected_employee_categories"}},[e.employee_categories.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])])],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("employee.designation")))]),e._v(" "),n("v-select",{attrs:{label:"name","track-by":"id",name:"designation_id",id:"designation_id",options:e.designations,placeholder:e.trans("employee.select_designation"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_designations},on:{select:e.onDesignationSelect,remove:e.onDesignationRemove},model:{value:e.selected_designations,callback:function(t){e.selected_designations=t},expression:"selected_designations"}},[e.designations.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])])],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("employee.department")))]),e._v(" "),n("v-select",{attrs:{label:"name","track-by":"id",name:"department_id",id:"department_id",options:e.departments,placeholder:e.trans("employee.select_department"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_departments},on:{select:e.onDepartmentSelect,remove:e.onDepartmentRemove},model:{value:e.selected_departments,callback:function(t){e.selected_departments=t},expression:"selected_departments"}},[e.departments.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])])],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("employee.attendance_month")))]),e._v(" "),n("vue-monthly-picker",{attrs:{name:"month",placeHolder:e.trans("employee.attendance_month"),dateFormat:"YYYY-MM "},model:{value:e.filter.month,callback:function(t){e.$set(e.filter,"month",t)},expression:"filter.month"}})],1)])]),e._v(" "),n("div",{staticClass:"form-group"},[n("button",{staticClass:"btn btn-info pull-right",attrs:{type:"button"},on:{click:e.list}},[e._v(e._s(e.trans("general.filter")))])]),e._v(" "),n("div",{staticClass:"clearfix"}),e._v(" "),e.employees.length?n("div",{staticClass:"row m-t-20"},[n("div",{staticClass:"col-12"},[n("div",{staticClass:"table-responsive font-90pc p-2"},[n("table",{staticClass:"table table-sm table-bordered attendance-table"},[n("thead",[n("tr",[n("th",[e._v(e._s(e.trans("employee.employee")))]),e._v(" "),e._l(e.days,(function(t){return n("th",{staticClass:"date-cell"},[e._v(e._s(t))])})),e._v(" "),e._l(e.attendance_summary_with_name,(function(t){return n("th",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.name,expression:"attendance.name"}],staticClass:"text-center font-weight-bold"},[e._v("\n                                            "+e._s(t.symbol)+"\n                                        ")])}))],2)]),e._v(" "),n("tbody",e._l(e.employees,(function(t){return n("tr",[n("td",[e._v("\n                                            "+e._s(e.getEmployeeNameWithCode(t))+" "),n("br"),e._v(" "),n("span",{staticClass:"font-90pc"},[e._v(e._s(e.getEmployeeDesignationOnDate(t,e.date)))])]),e._v(" "),e._l(t.attendances,(function(t){return n("td",{class:"text-center font-weight-bold text-"+t.color},["H"==t.symbol?n("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.description,expression:"attendance.description"}],staticClass:"marking-cell"},[n("i",{staticClass:"fas fa-hospital-symbol"})]):n("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.description,expression:"attendance.description"}],staticClass:"marking-cell"},[e._v("\n                                                "+e._s(t.symbol)+"\n                                            ")])])})),e._v(" "),e._l(e.attendance_summary_with_name,(function(s){return n("td",{staticClass:"text-center font-weight-bold"},[e._v("\n                                            "+e._s(e.getAttendanceSummary(t,s.symbol))+"\n                                        ")])}))],2)})),0)])])])]):e._e()])])])])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=index.js.map?id=2d7fd91943b15d4ad0ce