(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[7015],{16768:(e,t,n)=>{"use strict";n.d(t,{Z:()=>l});var a=n(94015),s=n.n(a),o=n(23645),i=n.n(o)()(s());i.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/finance/fee/allocation/show.vue"],names:[],mappings:"AA6ZA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <div class="page-titles">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <h3 class="text-themecolor">{{trans(\'finance.fee_allocation\')}} \n                        <template v-if="fee_allocation.course">{{fee_allocation.course.name}}</template>\n                        <template v-if="!fee_allocation.course && fee_allocation.batch">{{fee_allocation.batch.course.name+\' \'+fee_allocation.batch.name}}</template>\n                        <i class="fas fa-lock fa-lg" v-if="fee_allocation.paid_count"></i>\n                    </h3>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="action-buttons pull-right">\n                        <button class="btn btn-info btn-sm" @click="$router.push(\'/finance/fee/allocation\')"><i class="fas fa-list"></i> <span class="d-none d-sm-inline">{{trans(\'finance.fee_allocation\')}}</span></button>\n                        <div class="btn-group">\n                            <button type="button" class="btn btn-info btn-sm dropdown-toggle no-caret " role="menu" id="moreOption" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-tooltip="trans(\'general.more_option\')">\n                                <i class="fas fa-ellipsis-h"></i> <span class="d-none d-sm-inline"></span>\n                            </button>\n                            <div :class="[\'dropdown-menu\',getConfig(\'direction\') == \'ltr\' ? \'dropdown-menu-right\' : \'\']" aria-labelledby="moreOption">\n                                <button class="dropdown-item custom-dropdown" @click="print"><i class="fas fa-print"></i> {{trans(\'general.print\')}}</button>\n                                <button class="dropdown-item custom-dropdown" @click="pdf"><i class="fas fa-file-pdf"></i> {{trans(\'general.generate_pdf\')}}</button>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="container-fluid">\n            <div class="card p-4">\n                <div class="card-body">\n                    <div class="row">\n                        <div class="col-12 col-sm-4">\n                            <div class="form-group">\n                                <label for="">{{trans(\'transport.circle\')}}</label>\n                                <v-select label="name" v-model="selected_transport_circle" name="transport_circle_id" id="transport_circle_id" :options="transport_circles" :placeholder="trans(\'general.select_one\')" @select="onTransportCircleSelect" @close="" @remove="onTransportCircleRemove">\n                                    <div class="multiselect__option" slot="afterList" v-if="!transport_circles.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                            </div>\n                        </div>\n                        <div class="col-12 col-sm-4">\n                            <div class="form-group">\n                                <label for="">{{trans(\'finance.fee_concession\')}}</label>\n                                <v-select label="name" v-model="selected_fee_concession" name="fee_concession_id" id="fee_concession_id" :options="fee_concessions" :placeholder="trans(\'general.select_one\')" @select="onFeeConcessionSelect" @close="" @remove="onFeeConcessionRemove">\n                                    <div class="multiselect__option" slot="afterList" v-if="!fee_concessions.length">\n                                        {{trans(\'general.no_option_found\')}}\n                                    </div>\n                                </v-select>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <div class="card" v-for="group in fee.groups">\n                <div class="card-body">\n                    <h4 class="card-title px-4">{{group.name}}</h4>\n                    <div class="table-responsive">\n                        <table class="table table-sm">\n                            <thead>\n                                <tr>\n                                    <th v-for="head in group.heads">{{head}}</th>\n                                    <th></th>\n                                </tr>\n                            </thead>\n                            <tbody>\n                                <tr v-for="installment in group.installments">\n                                    <td v-for="detail in installment.data">\n                                        <template v-if="detail.is_concession && detail.text != detail.actual"><span style="text-decoration: line-through;">{{detail.actual}}</span> {{detail.text}}</template>\n                                        <template v-else>{{detail.text}}</template>\n\n                                        <template v-if="detail.is_optional"><small>({{trans(\'finance.optional\')}})</small></template>\n                                    </td>\n                                    <td>\n                                        <button class="btn btn-info btn-sm" v-if="hasPermission(\'edit-fee-allocation\')" v-tooltip="trans(\'finance.edit_fee_installment\')" @click.prevent="showEditAction(installment)"><i class="fas fa-edit"></i></button>\n                                    </td>\n                                </tr>\n                                <tr>\n                                    <td v-for="foot in group.foots">{{foot}}</td>\n                                    <td></td>\n                                </tr>\n                            </tbody>\n                        </table>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <transition name="modal" v-if="showEditModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'finance.edit_fee_installment\')}}\n                                <span class="float-right pointer" @click="showEditModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <fee-installment-form :iuuid="iuuid" @completed="getFeeAllocation" @close="showEditModal = false"></fee-installment-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n<script>\n    import feeInstallmentForm from \'./fee-installment-form\'\n\n    export default {\n        components : { feeInstallmentForm },\n        data() {\n            return {\n                uuid:this.$route.params.uuid,\n                fee_allocation: {\n                \tbatch: {\n\n                \t},\n                \tcourse: {\n\n                \t},\n                \tfee_installments: []\n                },\n                transport_circles: [],\n                transport_fee_details: [],\n                fee_concession_details: [],\n                fee_concessions: [],\n                transport_circle_id: \'\',\n                selected_transport_circle: null,\n                fee_concession_id: \'\',\n                selected_fee_concession: null,\n                fee: {\n                    groups: []\n                },\n                iuuid: \'\',\n                showEditModal: false\n            }\n        },\n        mounted(){\n            if(!helper.hasPermission(\'list-fee-allocation\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getPreRequisite();\n\n            this.getFeeAllocation();\n        },\n        methods: {\n            getConfig(config){\n                return helper.getConfig(config);\n            },\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/fee/allocation/show/pre-requisite\')\n                    .then(response => {\n                        this.transport_circles = response.transport_circles;\n                        this.fee_concessions = response.fee_concessions;\n                        this.transport_fee_details = response.transport_fee_details;\n                        this.fee_concession_details = response.fee_concession_details;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n        \tgetFeeAllocation(){\n                let loader = this.$loading.show();\n        \t\taxios.get(\'/api/fee/allocation/\'+this.uuid)\n        \t\t\t.then(response => {\n        \t\t\t\tthis.fee_allocation = response;\n                        this.calculate();\n                        loader.hide();\n        \t\t\t})\n        \t\t\t.catch(error => {\n                        loader.hide();\n        \t\t\t\thelper.showErrorMsg(error);\n        \t\t\t\tthis.$router.push(\'/finance/fee/allocation\');\n        \t\t\t})\n        \t},\n            showEditAction(installment){\n                this.iuuid = installment.uuid;\n                this.showEditModal = true;\n            },\n            calculate(){\n                this.fee = {\n                    groups: []\n                };\n                this.fee_allocation.fee_allocation_groups.forEach(fee_allocation_group => {\n                    let installments = [];\n                    let heads = [];\n                    let foots = [];\n                    heads.push(i18n.finance.fee_installment_title);\n                    heads.push(i18n.finance.fee_installment_due_date);\n                    heads.push(i18n.finance.late_fee);\n\n                    foots.push(i18n.finance.total);\n                    foots.push(\'\');\n                    foots.push(\'\');\n\n                    fee_allocation_group.fee_group.fee_heads.forEach(fee_head => {\n                        heads.push(fee_head.name);\n                    });\n\n                    let has_transport = (fee_allocation_group.fee_group.options && fee_allocation_group.fee_group.options.has_transport) ? true : false;\n\n                    if (has_transport)\n                        heads.push(i18n.transport.fee);\n\n                    heads.push(i18n.finance.installment_total);\n\n                    fee_allocation_group.fee_installments.forEach(fee_installment => {\n                        let installment_data = [];\n                        installment_data.push({\n                            text: fee_installment.title\n                        });\n                        installment_data.push({\n                            text: this.showDate(fee_installment.due_date)\n                        });\n\n                        let late_fee = (fee_installment.late_fee_applicable) ? (this.formatCurrency(fee_installment.late_fee)+\'/\'+this.getLateFeeFrequencyName(fee_installment.late_fee_frequency)) : \'-\';\n\n                        installment_data.push({\n                            text: late_fee\n                        });\n\n                        fee_allocation_group.fee_group.fee_heads.forEach(fee_head => {\n                            installment_data.push({\n                                text: this.formatCurrency(this.getFee(fee_installment, fee_head.id, 1)),\n                                actual: this.formatCurrency(this.getFee(fee_installment, fee_head.id, 0)),\n                                is_concession: this.fee_concession_id ? true : false,\n                                is_optional: this.isFeeHeadOptional(fee_installment, fee_head.id)\n                            });\n                        });\n\n                        if (has_transport)\n                            installment_data.push({\n                                text: this.getTransportFee(fee_allocation_group,fee_installment.id)\n                            });\n\n                        installment_data.push({\n                            text: this.formatCurrency(this.getInstallmentTotal(fee_allocation_group, fee_installment))\n                        });\n\n                        installments.push({\n                            uuid: fee_installment.uuid,\n                            data: installment_data\n                        });\n                    });\n\n                    fee_allocation_group.fee_group.fee_heads.forEach(fee_head => {\n                        foots.push(this.formatCurrency(this.getTotalFee(fee_allocation_group, fee_head.id)));\n                    });\n                    \n                    if (has_transport)\n                        foots.push(this.getTransportFeeTotal(fee_allocation_group));\n                    \n                    foots.push(this.formatCurrency(this.getInstallmentGrandTotal(fee_allocation_group)));\n\n                    let group = {\n                        name: fee_allocation_group.fee_group.name,\n                        heads: heads,\n                        installments: installments,\n                        foots: foots,\n                    }\n                    this.fee.groups.push(group);\n                });\n            },\n            formatCurrency(amount){\n                return helper.formatCurrency(amount);\n            },\n            getLateFeeFrequencyName(frequency){\n                return helper.getLateFeeFrequencyName(frequency);\n            },\n            onTransportCircleSelect(selectedOption){\n                this.transport_circle_id = selectedOption.id;\n                this.calculate();\n            },\n            onTransportCircleRemove(){\n                this.transport_circle_id = \'\';\n                this.calculate();\n            },\n            onFeeConcessionSelect(selectedOption){\n                this.fee_concession_id = selectedOption.id;\n                this.calculate();\n            },\n            onFeeConcessionRemove(){\n                this.fee_concession_id = \'\';\n                this.calculate();\n            },\n            isFeeHeadOptional(fee_installment, fee_head_id){\n                let installment = fee_installment.fee_installment_details.find(o => o.fee_head_id == fee_head_id);\n                return (installment && installment.is_optional) ? true : false;\n            },\n            getFee(fee_installment, fee_head_id, fee_con){\n                let installment = fee_installment.fee_installment_details.find(o => o.fee_head_id == fee_head_id);\n                let amount = (installment) ? installment.amount : 0;\n                let discount = 0;\n\n                if (this.fee_concession_id && fee_con) {\n                    let concession = this.fee_concession_details.find(o => o.fee_concession_id == this.fee_concession_id && o.fee_head_id == fee_head_id);\n                    discount = (concession) ? (concession.type == \'percent\' ? (amount * (concession.amount/100)) : concession.amount) : 0;\n                }\n\n                amount -= discount;\n\n                if (amount < 0)\n                    amount = 0;\n\n                return amount;\n            },\n            getTotalFee(fee_allocation_group, fee_head_id){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    total += this.getFee(fee_installment, fee_head_id, 1);\n                });\n                return total;\n            },\n            getInstallmentTotal(fee_allocation_group, fee_installment) {\n                let total = 0;\n                fee_allocation_group.fee_group.fee_heads.forEach(fee_head => {\n                    total += this.getFee(fee_installment, fee_head.id, 1);\n                });\n                total += this.getTransportFeeAmount(fee_allocation_group, fee_installment.id);\n                return total;\n            },\n            getInstallmentGrandTotal(fee_allocation_group){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    total += this.getInstallmentTotal(fee_allocation_group, fee_installment);\n                });\n                return total;\n            },\n            getTransportFeeTotal(fee_allocation_group){\n                let total = 0;\n                fee_allocation_group.fee_installments.forEach(fee_installment => {\n                    total += this.getTransportFeeAmount(fee_allocation_group, fee_installment.id);\n                });\n                return total ? this.formatCurrency(total) : \'-\';\n            },\n            getTransportFee(fee_allocation_group,fee_installment_id){\n                let fee = this.getTransportFeeAmount(fee_allocation_group, fee_installment_id);\n                return fee ? this.formatCurrency(fee) : \'-\';\n            },\n            getTransportFeeAmount(fee_allocation_group, fee_installment_id){\n                if (!fee_allocation_group.fee_group.options || (fee_allocation_group.fee_group.options && !fee_allocation_group.fee_group.options.has_transport))\n                    return 0;\n\n                let installment = fee_allocation_group.fee_installments.find(o => o.id == fee_installment_id);\n\n                if (!installment || (installment && !installment.transport_fee_id))\n                    return 0;\n\n                let transport_fee_detail = this.transport_fee_details.find(o => o.transport_fee_id == installment.transport_fee_id && o.transport_circle_id == this.transport_circle_id);\n\n                return (transport_fee_detail) ? transport_fee_detail.amount : 0;\n            },\n            showDate(date){\n                return helper.formatDate(date);\n            },\n            print(){\n                let loader = this.$loading.show();\n                axios.post(\'/api/fee/allocation/\'+this.uuid+\'/print\',{fee: this.fee})\n                    .then(response => {\n                        let print = window.open("/print");\n                        loader.hide();\n                        print.document.write(response);\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            pdf(){\n                let loader = this.$loading.show();\n                axios.post(\'/api/fee/allocation/\'+this.uuid+\'/pdf\',{fee: this.fee})\n                    .then(response => {\n                        loader.hide();\n                        window.open(\'/download/report/\'+response+\'?token=\'+this.authToken);\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            }\n        },\n        filters: {\n          moment(date) {\n            return helper.formatDate(date);\n          },\n          momentDateTime(date) {\n            return helper.formatDateTime(date);\n          }\n        },\n        computed: {\n            authToken(){\n                return helper.getAuthToken();\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const l=i},76925:(e,t,n)=>{"use strict";n.r(t),n.d(t,{default:()=>f});const a={components:{},props:["iuuid"],data:function(){return{feeInstallmentForm:new Form({title:"",due_date:"",late_fee_applicable:"",late_fee_frequency:"",late_fee:"",fee_heads:[],selected_transport_fee:null,transport_fee_id:""}),fee_group:{},paid_installment:0,transport_fees:[],late_fee_frequencies:[]}},mounted:function(){this.getPreRequisite(),this.getInstallment()},methods:{getPreRequisite:function(){var e=this,t=this.$loading.show();axios.get("/api/fee/installment/pre-requisite").then((function(n){e.late_fee_frequencies=n.late_fee_frequencies,e.transport_fees=n.transport_fees,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},getFeeName:function(e,t){return e+"_"+t+"_fee"},getTransportFeeName:function(e){return e+"_transport_fee"},getInstallment:function(){var e=this,t=this.$loading.show();axios.get("/api/fee/installment/"+this.iuuid).then((function(n){e.feeInstallmentForm.fee_heads=[],e.feeInstallmentForm.title=n.title,e.feeInstallmentForm.due_date=n.due_date,e.feeInstallmentForm.late_fee_applicable=n.late_fee_applicable,e.feeInstallmentForm.late_fee_frequency=n.late_fee_frequency,e.feeInstallmentForm.late_fee=n.late_fee,e.feeInstallmentForm.transport_fee_id=n.transport_fee_id,e.feeInstallmentForm.selected_transport_fee=n.transport_fee_id?{id:n.transport_fee_id,name:n.transport_fee.name}:null,e.paid_installment=n.paid_installment,e.fee_group=n.fee_allocation_group.fee_group,n.fee_installment_details.forEach((function(t){e.feeInstallmentForm.fee_heads.push({id:t.fee_head_id,amount:t.amount,is_optional:t.is_optional,name:t.fee_head.name})})),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)})),this.$emit("loaded")},submit:function(){var e=this,t=this.$loading.show();this.feeInstallmentForm.patch("/api/fee/installment/"+this.iuuid).then((function(n){toastr.success(n.message),e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},onTransportFeeSelect:function(e,t){this.feeInstallmentForm.transport_fee_id=e.id}}};var s=n(51900);const o={components:{feeInstallmentForm:(0,s.Z)(a,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("form",{on:{submit:function(t){return t.preventDefault(),e.submit.apply(null,arguments)},keydown:function(t){return e.feeInstallmentForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.fee_installment_title")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.feeInstallmentForm.title,expression:"feeInstallmentForm.title"}],staticClass:"form-control",attrs:{type:"text",name:"title",placeholder:e.trans("finance.fee_installment_title"),disabled:e.paid_installment>0},domProps:{value:e.feeInstallmentForm.title},on:{input:function(t){t.target.composing||e.$set(e.feeInstallmentForm,"title",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feeInstallmentForm,"prop-name":"title"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.fee_installment_due_date")))]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("finance.fee_installment_due_date"),name:"due_date"},on:{selected:function(t){return e.feeInstallmentForm.errors.clear("due_date")}},model:{value:e.feeInstallmentForm.due_date,callback:function(t){e.$set(e.feeInstallmentForm,"due_date",t)},expression:"feeInstallmentForm.due_date"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feeInstallmentForm,"prop-name":"due_date"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.late_fee_applicable")))]),e._v(" "),n("br"),e._v(" "),n("switches",{staticClass:"m-l-20",attrs:{theme:"bootstrap",color:"success"},model:{value:e.feeInstallmentForm.late_fee_applicable,callback:function(t){e.$set(e.feeInstallmentForm,"late_fee_applicable",t)},expression:"feeInstallmentForm.late_fee_applicable"}})],1)]),e._v(" "),e.feeInstallmentForm.late_fee_applicable?n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.late_fee_frequency")))]),e._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:e.feeInstallmentForm.late_fee_frequency,expression:"feeInstallmentForm.late_fee_frequency"}],staticClass:"custom-select col-12",attrs:{name:"late_fee_frequency"},on:{change:function(t){var n=Array.prototype.filter.call(t.target.options,(function(e){return e.selected})).map((function(e){return"_value"in e?e._value:e.value}));e.$set(e.feeInstallmentForm,"late_fee_frequency",t.target.multiple?n:n[0])}}},[n("option",{attrs:{value:"0"}},[e._v(e._s(e.trans("general.select_one")))]),e._v(" "),e._l(e.late_fee_frequencies,(function(t){return n("option",{domProps:{value:t.value}},[e._v("\n                                    "+e._s(t.text)+"\n                                  ")])}))],2),e._v(" "),n("show-error",{attrs:{"form-name":e.feeInstallmentForm,"prop-name":"late_fee_frequency"}})],1)]):e._e(),e._v(" "),e.feeInstallmentForm.late_fee_applicable?n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.late_fee")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.feeInstallmentForm.late_fee,expression:"feeInstallmentForm.late_fee"}],staticClass:"form-control",attrs:{type:"text",name:"late_fee",placeholder:e.trans("finance.late_fee")},domProps:{value:e.feeInstallmentForm.late_fee},on:{input:function(t){t.target.composing||e.$set(e.feeInstallmentForm,"late_fee",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.feeInstallmentForm,"prop-name":"late_fee"}})],1)]):e._e()]),e._v(" "),n("div",{staticClass:"row"},[e._l(e.feeInstallmentForm.fee_heads,(function(t,a){return n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(t.name))]),e._v(" "),n("div",{staticClass:"input-group mb-3"},[n("input",{directives:[{name:"model",rawName:"v-model",value:t.amount,expression:"fee_head.amount"}],staticClass:"form-control",attrs:{type:"text",name:e.getFeeName(a,t.id),placeholder:e.trans("finance.fee_installment_amount"),disabled:e.paid_installment>0},domProps:{value:t.amount},on:{input:function(n){n.target.composing||e.$set(t,"amount",n.target.value)}}}),e._v(" "),n("div",{staticClass:"input-group-append"},[n("div",{staticClass:"input-group-text"},[n("input",{directives:[{name:"model",rawName:"v-model",value:t.is_optional,expression:"fee_head.is_optional"},{name:"tooltip",rawName:"v-tooltip",value:e.trans("finance.fee_is_optional"),expression:"trans('finance.fee_is_optional')"}],attrs:{type:"checkbox",disabled:e.paid_installment>0},domProps:{checked:Array.isArray(t.is_optional)?e._i(t.is_optional,null)>-1:t.is_optional},on:{change:function(n){var a=t.is_optional,s=n.target,o=!!s.checked;if(Array.isArray(a)){var i=e._i(a,null);s.checked?i<0&&e.$set(t,"is_optional",a.concat([null])):i>-1&&e.$set(t,"is_optional",a.slice(0,i).concat(a.slice(i+1)))}else e.$set(t,"is_optional",o)}}})])])]),e._v(" "),n("show-error",{attrs:{"form-name":e.feeInstallmentForm,"prop-name":e.getFeeName(a,t.id)}})],1)])})),e._v(" "),e.fee_group.options&&e.fee_group.options.has_transport?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("transport.transport")))]),e._v(" "),n("v-select",{attrs:{label:"name",name:"transport_fee",id:"transport_fee",options:e.transport_fees,placeholder:e.trans("general.select_one"),disabled:e.paid_installment>0},on:{select:e.onTransportFeeSelect,close:function(e){},remove:function(e){}},model:{value:e.feeInstallmentForm.selected_transport_fee,callback:function(t){e.$set(e.feeInstallmentForm,"selected_transport_fee",t)},expression:"feeInstallmentForm.selected_transport_fee"}},[e.transport_fees.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                        "+e._s(e.trans("general.no_option_found"))+"\n                                    ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.feeInstallmentForm,"prop-name":"transport_fee"}})],1)]):e._e()],2)])]),e._v(" "),n("div",{staticClass:"card-footer text-right"},[n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e._v(e._s(e.trans("general.save")))])])])])}),[],!1,null,null,null).exports},data:function(){return{uuid:this.$route.params.uuid,fee_allocation:{batch:{},course:{},fee_installments:[]},transport_circles:[],transport_fee_details:[],fee_concession_details:[],fee_concessions:[],transport_circle_id:"",selected_transport_circle:null,fee_concession_id:"",selected_fee_concession:null,fee:{groups:[]},iuuid:"",showEditModal:!1}},mounted:function(){helper.hasPermission("list-fee-allocation")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite(),this.getFeeAllocation()},methods:{getConfig:function(e){return helper.getConfig(e)},hasPermission:function(e){return helper.hasPermission(e)},getPreRequisite:function(){var e=this,t=this.$loading.show();axios.get("/api/fee/allocation/show/pre-requisite").then((function(n){e.transport_circles=n.transport_circles,e.fee_concessions=n.fee_concessions,e.transport_fee_details=n.transport_fee_details,e.fee_concession_details=n.fee_concession_details,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},getFeeAllocation:function(){var e=this,t=this.$loading.show();axios.get("/api/fee/allocation/"+this.uuid).then((function(n){e.fee_allocation=n,e.calculate(),t.hide()})).catch((function(n){t.hide(),helper.showErrorMsg(n),e.$router.push("/finance/fee/allocation")}))},showEditAction:function(e){this.iuuid=e.uuid,this.showEditModal=!0},calculate:function(){var e=this;this.fee={groups:[]},this.fee_allocation.fee_allocation_groups.forEach((function(t){var n=[],a=[],s=[];a.push(i18n.finance.fee_installment_title),a.push(i18n.finance.fee_installment_due_date),a.push(i18n.finance.late_fee),s.push(i18n.finance.total),s.push(""),s.push(""),t.fee_group.fee_heads.forEach((function(e){a.push(e.name)}));var o=!(!t.fee_group.options||!t.fee_group.options.has_transport);o&&a.push(i18n.transport.fee),a.push(i18n.finance.installment_total),t.fee_installments.forEach((function(a){var s=[];s.push({text:a.title}),s.push({text:e.showDate(a.due_date)});var i=a.late_fee_applicable?e.formatCurrency(a.late_fee)+"/"+e.getLateFeeFrequencyName(a.late_fee_frequency):"-";s.push({text:i}),t.fee_group.fee_heads.forEach((function(t){s.push({text:e.formatCurrency(e.getFee(a,t.id,1)),actual:e.formatCurrency(e.getFee(a,t.id,0)),is_concession:!!e.fee_concession_id,is_optional:e.isFeeHeadOptional(a,t.id)})})),o&&s.push({text:e.getTransportFee(t,a.id)}),s.push({text:e.formatCurrency(e.getInstallmentTotal(t,a))}),n.push({uuid:a.uuid,data:s})})),t.fee_group.fee_heads.forEach((function(n){s.push(e.formatCurrency(e.getTotalFee(t,n.id)))})),o&&s.push(e.getTransportFeeTotal(t)),s.push(e.formatCurrency(e.getInstallmentGrandTotal(t)));var i={name:t.fee_group.name,heads:a,installments:n,foots:s};e.fee.groups.push(i)}))},formatCurrency:function(e){return helper.formatCurrency(e)},getLateFeeFrequencyName:function(e){return helper.getLateFeeFrequencyName(e)},onTransportCircleSelect:function(e){this.transport_circle_id=e.id,this.calculate()},onTransportCircleRemove:function(){this.transport_circle_id="",this.calculate()},onFeeConcessionSelect:function(e){this.fee_concession_id=e.id,this.calculate()},onFeeConcessionRemove:function(){this.fee_concession_id="",this.calculate()},isFeeHeadOptional:function(e,t){var n=e.fee_installment_details.find((function(e){return e.fee_head_id==t}));return!(!n||!n.is_optional)},getFee:function(e,t,n){var a=this,s=e.fee_installment_details.find((function(e){return e.fee_head_id==t})),o=s?s.amount:0,i=0;if(this.fee_concession_id&&n){var l=this.fee_concession_details.find((function(e){return e.fee_concession_id==a.fee_concession_id&&e.fee_head_id==t}));i=l?"percent"==l.type?o*(l.amount/100):l.amount:0}return(o-=i)<0&&(o=0),o},getTotalFee:function(e,t){var n=this,a=0;return e.fee_installments.forEach((function(e){a+=n.getFee(e,t,1)})),a},getInstallmentTotal:function(e,t){var n=this,a=0;return e.fee_group.fee_heads.forEach((function(e){a+=n.getFee(t,e.id,1)})),a+=this.getTransportFeeAmount(e,t.id)},getInstallmentGrandTotal:function(e){var t=this,n=0;return e.fee_installments.forEach((function(a){n+=t.getInstallmentTotal(e,a)})),n},getTransportFeeTotal:function(e){var t=this,n=0;return e.fee_installments.forEach((function(a){n+=t.getTransportFeeAmount(e,a.id)})),n?this.formatCurrency(n):"-"},getTransportFee:function(e,t){var n=this.getTransportFeeAmount(e,t);return n?this.formatCurrency(n):"-"},getTransportFeeAmount:function(e,t){var n=this;if(!e.fee_group.options||e.fee_group.options&&!e.fee_group.options.has_transport)return 0;var a=e.fee_installments.find((function(e){return e.id==t}));if(!a||a&&!a.transport_fee_id)return 0;var s=this.transport_fee_details.find((function(e){return e.transport_fee_id==a.transport_fee_id&&e.transport_circle_id==n.transport_circle_id}));return s?s.amount:0},showDate:function(e){return helper.formatDate(e)},print:function(){var e=this.$loading.show();axios.post("/api/fee/allocation/"+this.uuid+"/print",{fee:this.fee}).then((function(t){var n=window.open("/print");e.hide(),n.document.write(t)})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},pdf:function(){var e=this,t=this.$loading.show();axios.post("/api/fee/allocation/"+this.uuid+"/pdf",{fee:this.fee}).then((function(n){t.hide(),window.open("/download/report/"+n+"?token="+e.authToken)})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))}},filters:{moment:function(e){return helper.formatDate(e)},momentDateTime:function(e){return helper.formatDateTime(e)}},computed:{authToken:function(){return helper.getAuthToken()}}};var i=n(93379),l=n.n(i),r=n(16768),c={insert:"head",singleton:!1};l()(r.Z,c);r.Z.locals;const f=(0,s.Z)(o,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("div",{staticClass:"page-titles"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("finance.fee_allocation"))+" \n                    "),e.fee_allocation.course?[e._v(e._s(e.fee_allocation.course.name))]:e._e(),e._v(" "),!e.fee_allocation.course&&e.fee_allocation.batch?[e._v(e._s(e.fee_allocation.batch.course.name+" "+e.fee_allocation.batch.name))]:e._e(),e._v(" "),e.fee_allocation.paid_count?n("i",{staticClass:"fas fa-lock fa-lg"}):e._e()],2)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"action-buttons pull-right"},[n("button",{staticClass:"btn btn-info btn-sm",on:{click:function(t){return e.$router.push("/finance/fee/allocation")}}},[n("i",{staticClass:"fas fa-list"}),e._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("finance.fee_allocation")))])]),e._v(" "),n("div",{staticClass:"btn-group"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-sm dropdown-toggle no-caret ",attrs:{type:"button",role:"menu",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[n("i",{staticClass:"fas fa-ellipsis-h"}),e._v(" "),n("span",{staticClass:"d-none d-sm-inline"})]),e._v(" "),n("div",{class:["dropdown-menu","ltr"==e.getConfig("direction")?"dropdown-menu-right":""],attrs:{"aria-labelledby":"moreOption"}},[n("button",{staticClass:"dropdown-item custom-dropdown",on:{click:e.print}},[n("i",{staticClass:"fas fa-print"}),e._v(" "+e._s(e.trans("general.print")))]),e._v(" "),n("button",{staticClass:"dropdown-item custom-dropdown",on:{click:e.pdf}},[n("i",{staticClass:"fas fa-file-pdf"}),e._v(" "+e._s(e.trans("general.generate_pdf")))])])])])])])]),e._v(" "),n("div",{staticClass:"container-fluid"},[n("div",{staticClass:"card p-4"},[n("div",{staticClass:"card-body"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("transport.circle")))]),e._v(" "),n("v-select",{attrs:{label:"name",name:"transport_circle_id",id:"transport_circle_id",options:e.transport_circles,placeholder:e.trans("general.select_one")},on:{select:e.onTransportCircleSelect,close:function(e){},remove:e.onTransportCircleRemove},model:{value:e.selected_transport_circle,callback:function(t){e.selected_transport_circle=t},expression:"selected_transport_circle"}},[e.transport_circles.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])])],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.fee_concession")))]),e._v(" "),n("v-select",{attrs:{label:"name",name:"fee_concession_id",id:"fee_concession_id",options:e.fee_concessions,placeholder:e.trans("general.select_one")},on:{select:e.onFeeConcessionSelect,close:function(e){},remove:e.onFeeConcessionRemove},model:{value:e.selected_fee_concession,callback:function(t){e.selected_fee_concession=t},expression:"selected_fee_concession"}},[e.fee_concessions.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                    "+e._s(e.trans("general.no_option_found"))+"\n                                ")])])],1)])])])]),e._v(" "),e._l(e.fee.groups,(function(t){return n("div",{staticClass:"card"},[n("div",{staticClass:"card-body"},[n("h4",{staticClass:"card-title px-4"},[e._v(e._s(t.name))]),e._v(" "),n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm"},[n("thead",[n("tr",[e._l(t.heads,(function(t){return n("th",[e._v(e._s(t))])})),e._v(" "),n("th")],2)]),e._v(" "),n("tbody",[e._l(t.installments,(function(t){return n("tr",[e._l(t.data,(function(t){return n("td",[t.is_concession&&t.text!=t.actual?[n("span",{staticStyle:{"text-decoration":"line-through"}},[e._v(e._s(t.actual))]),e._v(" "+e._s(t.text))]:[e._v(e._s(t.text))],e._v(" "),t.is_optional?[n("small",[e._v("("+e._s(e.trans("finance.optional"))+")")])]:e._e()],2)})),e._v(" "),n("td",[e.hasPermission("edit-fee-allocation")?n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("finance.edit_fee_installment"),expression:"trans('finance.edit_fee_installment')"}],staticClass:"btn btn-info btn-sm",on:{click:function(n){return n.preventDefault(),e.showEditAction(t)}}},[n("i",{staticClass:"fas fa-edit"})]):e._e()])],2)})),e._v(" "),n("tr",[e._l(t.foots,(function(t){return n("td",[e._v(e._s(t))])})),e._v(" "),n("td")],2)],2)])])])])}))],2),e._v(" "),e.showEditModal?n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                            "+e._s(e.trans("finance.edit_fee_installment"))+"\n                            "),n("span",{staticClass:"float-right pointer",on:{click:function(t){e.showEditModal=!1}}},[e._v("x")])]}))],2),e._v(" "),n("div",{staticClass:"modal-body"},[e._t("body",(function(){return[n("fee-installment-form",{attrs:{iuuid:e.iuuid},on:{completed:e.getFeeAllocation,close:function(t){e.showEditModal=!1}}}),e._v(" "),n("div",{staticClass:"clearfix"})]}))],2)])])])]):e._e()],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=show.js.map?id=dc197a6a6e5c496faa36