(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[5541],{89035:(e,t,n)=>{"use strict";n.d(t,{Z:()=>i});var a=n(94015),s=n.n(a),r=n(23645),o=n.n(r)()(s());o.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/configuration/finance/transaction/category/form.vue"],names:[],mappings:"AA0HA,8BACA,YACA",sourcesContent:['<template>\n    <form @submit.prevent="proceed" @keydown="transactionCategoryForm.errors.clear($event.target.name)">\n        <div class="row">\n            <div class="col-12 col-sm-4">\n                <div class="form-group">\n                    <label for="">{{trans(\'finance.transaction_category_name\')}}</label>\n                    <input class="form-control" type="text" v-model="transactionCategoryForm.name" name="name" :placeholder="trans(\'finance.transaction_category_name\')">\n                    <show-error :form-name="transactionCategoryForm" prop-name="name"></show-error>\n                </div>\n            </div>\n            <div class="col-12 col-sm-4">\n                <div class="form-group">\n                    <label for="">{{trans(\'finance.transaction_category_type\')}}</label>\n                    <select v-model="transactionCategoryForm.type" class="col-12 custom-select" @change="transactionCategoryForm.errors.clear(\'type\')" name="type">\n                      <option value=null selected>{{trans(\'general.select_one\')}}</option>\n                      <option v-for="type in types" v-bind:value="type.value">\n                        {{ type.text }}\n                      </option>\n                    </select>\n                    <show-error :form-name="transactionCategoryForm" prop-name="type"></show-error>\n                </div>\n            </div>\n            <div class="col-12 col-sm-4">\n                <div class="form-group">\n                    <label for="">{{trans(\'finance.transaction_category_description\')}}</label>\n                    <input class="form-control" type="text" v-model="transactionCategoryForm.description" name="description" :placeholder="trans(\'finance.transaction_category_description\')">\n                    <show-error :form-name="transactionCategoryForm" prop-name="description"></show-error>\n                </div>\n            </div>\n        </div>\n\n        <div class="card-footer text-right">\n            <button v-if="!id" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n            <router-link to="/configuration/finance/transaction/category" class="btn btn-danger waves-effect waves-light " v-show="id">{{trans(\'general.cancel\')}}</router-link>\n            <button type="submit" class="btn btn-info waves-effect waves-light">\n                <span v-if="id">{{trans(\'general.update\')}}</span>\n                <span v-else>{{trans(\'general.save\')}}</span>\n            </button>\n        </div>\n    </form>\n</template>\n\n\n<script>\n    export default {\n        data() {\n            return {\n                transactionCategoryForm: new Form({\n                    name : \'\',\n                    type: \'\',\n                    description : \'\'\n                }),\n                types: [\n                    {\n                        text: i18n.finance.income,\n                        value: \'income\'\n                    },\n                    {\n                        text: i18n.finance.expense,\n                        value: \'expense\'\n                    }\n                ]\n            };\n        },\n        props: [\'id\'],\n        mounted() {\n            if(this.id)\n                this.get();\n        },\n        methods: {\n            proceed(){\n                if(this.id)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.transactionCategoryForm.post(\'/api/finance/transaction/category\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/finance/transaction/category/\'+this.id)\n                    .then(response => {\n                        this.transactionCategoryForm.name = response.name;\n                        this.transactionCategoryForm.type = response.type;\n                        this.transactionCategoryForm.description = response.description;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/configuration/finance/transaction/category\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.transactionCategoryForm.patch(\'/api/finance/transaction/category/\'+this.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/configuration/finance/transaction/category\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>\n'],sourceRoot:""}]);const i=o},14518:(e,t,n)=>{"use strict";n.d(t,{Z:()=>c});const a={data:function(){return{transactionCategoryForm:new Form({name:"",type:"",description:""}),types:[{text:i18n.finance.income,value:"income"},{text:i18n.finance.expense,value:"expense"}]}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var e=this,t=this.$loading.show();this.transactionCategoryForm.post("/api/finance/transaction/category").then((function(n){toastr.success(n.message),e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/finance/transaction/category/"+this.id).then((function(n){e.transactionCategoryForm.name=n.name,e.transactionCategoryForm.type=n.type,e.transactionCategoryForm.description=n.description,t.hide()})).catch((function(n){t.hide(),helper.showErrorMsg(n),e.$router.push("/configuration/finance/transaction/category")}))},update:function(){var e=this,t=this.$loading.show();this.transactionCategoryForm.patch("/api/finance/transaction/category/"+this.id).then((function(n){toastr.success(n.message),t.hide(),e.$router.push("/configuration/finance/transaction/category")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))}}};var s=n(93379),r=n.n(s),o=n(89035),i={insert:"head",singleton:!1};r()(o.Z,i);o.Z.locals;const c=(0,n(51900).Z)(a,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.transactionCategoryForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.transaction_category_name")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.transactionCategoryForm.name,expression:"transactionCategoryForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:e.trans("finance.transaction_category_name")},domProps:{value:e.transactionCategoryForm.name},on:{input:function(t){t.target.composing||e.$set(e.transactionCategoryForm,"name",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.transactionCategoryForm,"prop-name":"name"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.transaction_category_type")))]),e._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:e.transactionCategoryForm.type,expression:"transactionCategoryForm.type"}],staticClass:"col-12 custom-select",attrs:{name:"type"},on:{change:[function(t){var n=Array.prototype.filter.call(t.target.options,(function(e){return e.selected})).map((function(e){return"_value"in e?e._value:e.value}));e.$set(e.transactionCategoryForm,"type",t.target.multiple?n:n[0])},function(t){return e.transactionCategoryForm.errors.clear("type")}]}},[n("option",{attrs:{value:"null",selected:""}},[e._v(e._s(e.trans("general.select_one")))]),e._v(" "),e._l(e.types,(function(t){return n("option",{domProps:{value:t.value}},[e._v("\n                    "+e._s(t.text)+"\n                  ")])}))],2),e._v(" "),n("show-error",{attrs:{"form-name":e.transactionCategoryForm,"prop-name":"type"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-4"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.transaction_category_description")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.transactionCategoryForm.description,expression:"transactionCategoryForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:e.trans("finance.transaction_category_description")},domProps:{value:e.transactionCategoryForm.description},on:{input:function(t){t.target.composing||e.$set(e.transactionCategoryForm,"description",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.transactionCategoryForm,"prop-name":"description"}})],1)])]),e._v(" "),n("div",{staticClass:"card-footer text-right"},[e.id?e._e():n("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),n("router-link",{directives:[{name:"show",rawName:"v-show",value:e.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/configuration/finance/transaction/category"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.id?n("span",[e._v(e._s(e.trans("general.update")))]):n("span",[e._v(e._s(e.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports},38646:(e,t,n)=>{"use strict";n.r(t),n.d(t,{default:()=>s});const a={components:{expenseForm:n(12327).Z},data:function(){return{uuid:this.$route.params.uuid}},mounted:function(){helper.hasPermission("edit-expense")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const s=(0,n(51900).Z)(a,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("div",{staticClass:"page-titles"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("finance.edit_expense")))])]),e._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"action-buttons pull-right"},[n("button",{staticClass:"btn btn-info btn-sm",on:{click:function(t){return e.$router.push("/finance/transaction/expense")}}},[n("i",{staticClass:"fas fa-list"}),e._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("finance.expense")))])])])])])]),e._v(" "),n("div",{staticClass:"container-fluid"},[n("div",{staticClass:"card card-form"},[n("div",{staticClass:"card-body p-t-20"},[n("expense-form",{attrs:{uuid:e.uuid}})],1)])])])}),[],!1,null,null,null).exports},12327:(e,t,n)=>{"use strict";n.d(t,{Z:()=>s});const a={components:{transactionCategoryForm:n(14518).Z},data:function(){return{expenseForm:new Form({transaction_category_id:"",account_id:"",payment_method_id:"",instrument_number:"",instrument_date:"",instrument_clearing_date:"",instrument_bank_detail:"",reference_number:"",amount:"",date_of_expense:"",description:"",upload_token:""}),transaction_categories:[],selected_transaction_category:null,accounts:[],selected_account:null,payment_methods:[],selected_payment_method:null,payment_method_details:[],payment_method_detail:{},module_id:"",clearAttachment:!0,showTransactionCategoryModal:!1,default_currency:helper.getConfig("default_currency")}},props:["uuid"],mounted:function(){helper.hasPermission("create-expense")||helper.hasPermission("edit-expense")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.uuid?this.get():this.expenseForm.upload_token=this.$uuid.v4(),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},getPreRequisite:function(){var e=this,t=this.$loading.show();this.showTransactionCategoryModal=!1,axios.get("/api/expense/pre-requisite").then((function(n){e.transaction_categories=n.transaction_categories,e.accounts=n.accounts,e.payment_methods=n.payment_methods,e.payment_method_details=n.payment_method_details,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},proceed:function(){this.uuid?this.update():this.store()},store:function(){var e=this,t=this.$loading.show();this.expenseForm.post("/api/expense").then((function(n){toastr.success(n.message),e.clearAttachment=!e.clearAttachment,e.expenseForm.upload_token=e.$uuid.v4(),e.selected_transaction_category=null,e.selected_account=null,e.selected_payment_method=null,e.payment_method_detail=null,e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/expense/"+this.uuid).then((function(n){e.expenseForm.amount=e.formatNumber(n.expense.amount),e.expenseForm.date_of_expense=n.expense.date_of_expense,e.expenseForm.description=n.expense.description,e.expenseForm.transaction_category_id=n.expense.transaction_category_id,e.selected_transaction_category=n.expense.transaction_category_id?{id:n.expense.transaction_category_id,name:n.expense.transaction_category.name}:null,e.expenseForm.account_id=n.expense.transaction.account_id,e.selected_account=n.expense.transaction.account_id?{id:n.expense.transaction.account_id,name:n.expense.transaction.account.name}:null,e.expenseForm.payment_method_id=n.expense.transaction.payment_method_id,e.selected_payment_method=n.expense.transaction.payment_method_id?{id:n.expense.transaction.payment_method_id,name:n.expense.transaction.payment_method.name}:null,e.expenseForm.instrument_number=n.expense.transaction.instrument_number,e.expenseForm.instrument_date=n.expense.transaction.instrument_date,e.expenseForm.instrument_clearing_date=n.expense.transaction.instrument_clearing_date,e.expenseForm.instrument_bank_detail=n.expense.transaction.instrument_bank_detail,e.expenseForm.reference_number=n.expense.transaction.reference_number,e.expenseForm.upload_token=n.expense.upload_token,e.module_id=n.expense.id,t.hide()})).catch((function(n){t.hide(),helper.showErrorMsg(n),e.$router.push("/finance/transaction/expense")}))},update:function(){var e=this,t=this.$loading.show();this.expenseForm.patch("/api/expense/"+this.uuid).then((function(n){toastr.success(n.message),t.hide(),e.$router.push("/finance/transaction/expense")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},onTransactionCategorySelect:function(e){this.expenseForm.transaction_category_id=e.id},onAccountSelect:function(e){this.expenseForm.account_id=e.id},onPaymentMethodSelect:function(e){this.expenseForm.payment_method_id=e.id,this.payment_method_detail=this.payment_method_details.find((function(t){return t.id==e.id}))},formatCurrency:function(e){return helper.formatCurrency(e)},formatNumber:function(e){return helper.formatNumber(e,this.default_currency.decimal_place)},getPaymentMethodDetail:function(e){return helper.getPaymentMethodDetail(this.payment_method_detail,e)}}};const s=(0,n(51900).Z)(a,(function(){var e=this,t=e.$createElement,n=e._self._c||t;return n("div",[n("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.expenseForm.errors.clear(t.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.transaction_category"))+" ")]),e._v(" "),e.hasPermission("access-configuration")?n("button",{staticClass:"btn btn-xs btn-info pull-right",attrs:{type:"button"},on:{click:function(t){e.showTransactionCategoryModal=!0}}},[e._v(e._s(e.trans("general.add_new")))]):e._e(),e._v(" "),n("v-select",{attrs:{label:"name",name:"transaction_category_id",id:"transaction_category_id",options:e.transaction_categories,placeholder:e.trans("finance.select_transaction_category")},on:{select:e.onTransactionCategorySelect,close:function(t){return e.expenseForm.errors.clear("transaction_category_id")},remove:function(t){e.expenseForm.transaction_category_id=""}},model:{value:e.selected_transaction_category,callback:function(t){e.selected_transaction_category=t},expression:"selected_transaction_category"}},[e.transaction_categories.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                "+e._s(e.trans("general.no_option_found"))+"\n                            ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"transaction_category_id"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.account"))+" ")]),e._v(" "),n("v-select",{attrs:{label:"name",name:"account_id",id:"account_id",options:e.accounts,placeholder:e.trans("finance.select_account"),disabled:!!e.uuid},on:{select:e.onAccountSelect,close:function(t){return e.expenseForm.errors.clear("account_id")},remove:function(t){e.expenseForm.account_id=""}},model:{value:e.selected_account,callback:function(t){e.selected_account=t},expression:"selected_account"}},[e.accounts.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                "+e._s(e.trans("general.no_option_found"))+"\n                            ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"account_id"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.amount")))]),e._v(" "),n("currency-input",{attrs:{position:e.default_currency.position,symbol:e.default_currency.symbol,name:"amount",placeholder:e.trans("finance.amount")},nativeOn:{input:function(t){return e.expenseForm.errors.clear("amount")}},model:{value:e.expenseForm.amount,callback:function(t){e.$set(e.expenseForm,"amount",t)},expression:"expenseForm.amount"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"amount"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.date_of_expense")))]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("finance.date_of_expense")},on:{selected:function(t){return e.expenseForm.errors.clear("date_of_expense")}},model:{value:e.expenseForm.date_of_expense,callback:function(t){e.$set(e.expenseForm,"date_of_expense",t)},expression:"expenseForm.date_of_expense"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"date_of_expense"}})],1)]),e._v(" "),n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.payment_method"))+" ")]),e._v(" "),n("v-select",{attrs:{label:"name",name:"payment_method_id",id:"payment_method_id",options:e.payment_methods,placeholder:e.trans("finance.select_payment_method")},on:{select:e.onPaymentMethodSelect,close:function(t){return e.expenseForm.errors.clear("payment_method_id")},remove:function(t){e.expenseForm.payment_method_id=""}},model:{value:e.selected_payment_method,callback:function(t){e.selected_payment_method=t},expression:"selected_payment_method"}},[e.payment_methods.length?e._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                "+e._s(e.trans("general.no_option_found"))+"\n                            ")])]),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"payment_method_id"}})],1)]),e._v(" "),e.getPaymentMethodDetail("instrument_number")?n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_number")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.expenseForm.instrument_number,expression:"expenseForm.instrument_number"}],staticClass:"form-control",attrs:{type:"text",name:"instrument_number",placeholder:e.trans("finance.instrument_number")},domProps:{value:e.expenseForm.instrument_number},on:{input:function(t){t.target.composing||e.$set(e.expenseForm,"instrument_number",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"instrument_number"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("instrument_date")?n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_date")))]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("finance.instrument_date")},on:{selected:function(t){return e.expenseForm.errors.clear("instrument_date")}},model:{value:e.expenseForm.instrument_date,callback:function(t){e.$set(e.expenseForm,"instrument_date",t)},expression:"expenseForm.instrument_date"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"instrument_date"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("instrument_bank_detail")?n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_bank_detail")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.expenseForm.instrument_bank_detail,expression:"expenseForm.instrument_bank_detail"}],staticClass:"form-control",attrs:{type:"text",name:"instrument_bank_detail",placeholder:e.trans("finance.instrument_bank_detail")},domProps:{value:e.expenseForm.instrument_bank_detail},on:{input:function(t){t.target.composing||e.$set(e.expenseForm,"instrument_bank_detail",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"instrument_bank_detail"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("instrument_clearing_date")?n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.instrument_clearing_date")))]),e._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("finance.instrument_clearing_date")},on:{selected:function(t){return e.expenseForm.errors.clear("instrument_clearing_date")}},model:{value:e.expenseForm.instrument_clearing_date,callback:function(t){e.$set(e.expenseForm,"instrument_clearing_date",t)},expression:"expenseForm.instrument_clearing_date"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"instrument_clearing_date"}})],1)]):e._e(),e._v(" "),e.getPaymentMethodDetail("reference_number")?n("div",{staticClass:"col-12 col-sm-3"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.reference_number")))]),e._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:e.expenseForm.reference_number,expression:"expenseForm.reference_number"}],staticClass:"form-control",attrs:{type:"text",name:"reference_number",placeholder:e.trans("finance.reference_number")},domProps:{value:e.expenseForm.reference_number},on:{input:function(t){t.target.composing||e.$set(e.expenseForm,"reference_number",t.target.value)}}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"reference_number"}})],1)]):e._e(),e._v(" "),n("div",{staticClass:"col-12 col-sm-9"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[e._v(e._s(e.trans("finance.expense_description")))]),e._v(" "),n("autosize-textarea",{attrs:{rows:"1",name:"description",placeholder:e.trans("finance.expense_description")},model:{value:e.expenseForm.description,callback:function(t){e.$set(e.expenseForm,"description",t)},expression:"expenseForm.description"}}),e._v(" "),n("show-error",{attrs:{"form-name":e.expenseForm,"prop-name":"description"}})],1)]),e._v(" "),n("div",{staticClass:"col-12"},[n("div",{staticClass:"form-group"},[n("file-upload-input",{attrs:{"button-text":e.trans("general.upload_document"),token:e.expenseForm.upload_token,module:"expense","clear-file":e.clearAttachment,"module-id":e.module_id}})],1)])]),e._v(" "),n("div",{staticClass:"card-footer text-right"},[n("router-link",{directives:[{name:"show",rawName:"v-show",value:e.uuid,expression:"uuid"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/finance/transaction/expense"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.uuid?e._e():n("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.uuid?n("span",[e._v(e._s(e.trans("general.update")))]):n("span",[e._v(e._s(e.trans("general.save")))])])],1)]),e._v(" "),e.showTransactionCategoryModal?n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                                "+e._s(e.trans("finance.add_new_transaction_category"))+"\n                                "),n("span",{staticClass:"float-right pointer",on:{click:function(t){e.showTransactionCategoryModal=!1}}},[e._v("x")])]}))],2),e._v(" "),n("div",{staticClass:"modal-body"},[e._t("body",(function(){return[n("transaction-category-form",{on:{completed:e.getPreRequisite,cancel:function(t){e.showTransactionCategoryModal=!1}}}),e._v(" "),n("div",{staticClass:"clearfix"})]}))],2)])])])]):e._e()],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=59c622a568d61bc3cc24