(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[5437],{59414:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});var i=r(94015),s=r.n(i),a=r(23645),o=r.n(a)()(s());o.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/post/article/form.vue"],names:[],mappings:"AAsMA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="articleForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <label for="">{{trans(\'post.article_type\')}} </label> <button type="button" class="btn btn-xs btn-info pull-right" v-if="hasPermission(\'access-configuration\')" @click="showArticleTypeModal = true">{{trans(\'general.add_new\')}}</button>\n                        <v-select label="name" v-model="selected_article_type" name="article_type_id" id="article_type_id" :options="article_types" :placeholder="trans(\'post.select_article_type\')" @select="onArticleTypeSelect" @close="articleForm.errors.clear(\'article_type_id\')" @remove="articleForm.article_type_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!article_types.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="articleForm" prop-name="article_type_id"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label for="">{{trans(\'post.article_title\')}}</label>\n                        <input class="form-control" type="text" v-model="articleForm.title" name="title" :placeholder="trans(\'post.article_title\')">\n                        <show-error :form-name="articleForm" prop-name="title"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label for="">{{trans(\'post.date_of_article\')}}</label>\n                        <datepicker v-model="articleForm.date_of_article" :bootstrapStyling="true" @selected="articleForm.errors.clear(\'date_of_article\')" :placeholder="trans(\'post.date_of_article\')"></datepicker>\n                        <show-error :form-name="articleForm" prop-name="date_of_article"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label class="custom-control custom-checkbox">\n                            <input type="checkbox" class="custom-control-input" v-model="articleForm.is_public" value="1">\n                            <span class="custom-control-label">{{trans(\'post.article_is_public\')}}</span>\n                        </label>\n                    </div>\n                    <div class="form-group">\n                        <file-upload-input :button-text="trans(\'general.upload_document\')" :token="articleForm.upload_token" module="article" :clear-file="clearAttachment" :module-id="module_id"></file-upload-input>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <html-editor name="description" :model.sync="articleForm.description" height="300" :isUpdate="uuid ? true : false" @clearErrors="articleForm.errors.clear(\'description\')"></html-editor>\n                        <show-error :form-name="articleForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer text-right">\n                <router-link to="/post/article" class="btn btn-danger waves-effect waves-light " v-show="uuid">{{trans(\'general.cancel\')}}</router-link>\n                <button v-if="!uuid" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="uuid">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n\n        <transition name="modal" v-if="showArticleTypeModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'post.add_new_article_type\')}}\n                                <span class="float-right pointer" @click="showArticleTypeModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <article-type-form @completed="getPreRequisite" @cancel="showArticleTypeModal = false"></article-type-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n\n<script>\n    import articleTypeForm from \'../../configuration/post/article-type/form\'\n\n    export default {\n        components: {articleTypeForm},\n        data() {\n            return {\n                articleForm: new Form({\n                    article_type_id: \'\',\n                    title: \'\',\n                    is_public: 0,\n                    date_of_article: \'\',\n                    description: \'\',\n                    upload_token: \'\'\n                }),\n                article_types: [],\n                selected_article_type: null,\n                module_id: \'\',\n                clearAttachment: true,\n                showArticleTypeModal: false\n            };\n        },\n        props: [\'uuid\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-article\') && !helper.hasPermission(\'edit-article\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            if(this.uuid)\n                this.get();\n            else\n                this.articleForm.upload_token = this.$uuid.v4();\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                this.showArticleTypeModal = false;\n                axios.get(\'/api/article/pre-requisite\')\n                    .then(response => {\n                        this.article_types = response.article_types;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            proceed(){\n                if(this.uuid)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.articleForm.post(\'/api/article\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.clearAttachment = !this.clearAttachment;\n                        this.articleForm.upload_token = this.$uuid.v4();\n                        this.selected_article_type = null;\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/article/\'+this.uuid)\n                    .then(response => {\n                        this.articleForm.title = response.article.title;\n                        this.articleForm.date_of_article = response.article.date_of_article;\n                        this.articleForm.description = response.article.description;\n                        this.articleForm.article_type_id = response.article.article_type_id;\n                        this.selected_article_type = response.article.article_type_id ? {id: response.article.article_type_id, name: response.article.article_type.name} : null;\n                        this.articleForm.is_public = response.article.is_public;\n                        this.articleForm.upload_token = response.article.upload_token;\n                        this.module_id = response.article.id;\n\n                        if (! response.is_editable) {\n                            toastr.error(i18n.user.permission_denied);\n                            loader.hide();\n                            this.$router.push(\'/post/article\');\n                        }\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/post/article\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.articleForm.patch(\'/api/article/\'+this.uuid)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/post/article\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            onArticleTypeSelect(selectedOption){\n                this.articleForm.article_type_id = selectedOption.id;\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const n=o},19976:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});const i={data:function(){return{articleTypeForm:new Form({name:"",description:""})}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var e=this,t=this.$loading.show();this.articleTypeForm.post("/api/post/article/type").then((function(r){toastr.success(r.message),e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/post/article/type/"+this.id).then((function(r){e.articleTypeForm.name=r.name,e.articleTypeForm.description=r.description,t.hide()})).catch((function(r){t.hide(),helper.showErrorMsg(r),e.$router.push("/configuration/post/article/type")}))},update:function(){var e=this,t=this.$loading.show();this.articleTypeForm.patch("/api/post/article/type/"+this.id).then((function(r){toastr.success(r.message),t.hide(),e.$router.push("/configuration/post/article/type")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))}}};const s=(0,r(51900).Z)(i,(function(){var e=this,t=e.$createElement,r=e._self._c||t;return r("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.articleTypeForm.errors.clear(t.target.name)}}},[r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[e._v(e._s(e.trans("post.article_type_name")))]),e._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:e.articleTypeForm.name,expression:"articleTypeForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:e.trans("post.article_type_name")},domProps:{value:e.articleTypeForm.name},on:{input:function(t){t.target.composing||e.$set(e.articleTypeForm,"name",t.target.value)}}}),e._v(" "),r("show-error",{attrs:{"form-name":e.articleTypeForm,"prop-name":"name"}})],1)]),e._v(" "),r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[e._v(e._s(e.trans("post.article_type_description")))]),e._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:e.articleTypeForm.description,expression:"articleTypeForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:e.trans("post.article_type_description")},domProps:{value:e.articleTypeForm.description},on:{input:function(t){t.target.composing||e.$set(e.articleTypeForm,"description",t.target.value)}}}),e._v(" "),r("show-error",{attrs:{"form-name":e.articleTypeForm,"prop-name":"description"}})],1)])]),e._v(" "),r("div",{staticClass:"card-footer text-right"},[r("router-link",{directives:[{name:"show",rawName:"v-show",value:e.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/configuration/post/article/type"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.id?e._e():r("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),r("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.id?r("span",[e._v(e._s(e.trans("general.update")))]):r("span",[e._v(e._s(e.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports},48551:(e,t,r)=>{"use strict";r.r(t),r.d(t,{default:()=>s});const i={components:{articleForm:r(601).Z},data:function(){return{uuid:this.$route.params.uuid}},mounted:function(){helper.hasPermission("edit-article")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const s=(0,r(51900).Z)(i,(function(){var e=this,t=e.$createElement,r=e._self._c||t;return r("div",[r("div",{staticClass:"page-titles"},[r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-6"},[r("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("post.edit_article")))])]),e._v(" "),r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"action-buttons pull-right"},[r("button",{staticClass:"btn btn-info btn-sm",on:{click:function(t){return e.$router.push("/post/article")}}},[r("i",{staticClass:"fas fa-list"}),e._v(" "),r("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("post.article")))])])])])])]),e._v(" "),r("div",{staticClass:"container-fluid"},[r("div",{staticClass:"card card-form"},[r("div",{staticClass:"card-body p-t-20"},[r("article-form",{attrs:{uuid:e.uuid}})],1)])])])}),[],!1,null,null,null).exports},601:(e,t,r)=>{"use strict";r.d(t,{Z:()=>l});const i={components:{articleTypeForm:r(19976).Z},data:function(){return{articleForm:new Form({article_type_id:"",title:"",is_public:0,date_of_article:"",description:"",upload_token:""}),article_types:[],selected_article_type:null,module_id:"",clearAttachment:!0,showArticleTypeModal:!1}},props:["uuid"],mounted:function(){helper.hasPermission("create-article")||helper.hasPermission("edit-article")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.uuid?this.get():this.articleForm.upload_token=this.$uuid.v4(),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},getPreRequisite:function(){var e=this,t=this.$loading.show();this.showArticleTypeModal=!1,axios.get("/api/article/pre-requisite").then((function(r){e.article_types=r.article_types,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},proceed:function(){this.uuid?this.update():this.store()},store:function(){var e=this,t=this.$loading.show();this.articleForm.post("/api/article").then((function(r){toastr.success(r.message),e.clearAttachment=!e.clearAttachment,e.articleForm.upload_token=e.$uuid.v4(),e.selected_article_type=null,e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/article/"+this.uuid).then((function(r){e.articleForm.title=r.article.title,e.articleForm.date_of_article=r.article.date_of_article,e.articleForm.description=r.article.description,e.articleForm.article_type_id=r.article.article_type_id,e.selected_article_type=r.article.article_type_id?{id:r.article.article_type_id,name:r.article.article_type.name}:null,e.articleForm.is_public=r.article.is_public,e.articleForm.upload_token=r.article.upload_token,e.module_id=r.article.id,r.is_editable||(toastr.error(i18n.user.permission_denied),t.hide(),e.$router.push("/post/article")),t.hide()})).catch((function(r){t.hide(),helper.showErrorMsg(r),e.$router.push("/post/article")}))},update:function(){var e=this,t=this.$loading.show();this.articleForm.patch("/api/article/"+this.uuid).then((function(r){toastr.success(r.message),t.hide(),e.$router.push("/post/article")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},onArticleTypeSelect:function(e){this.articleForm.article_type_id=e.id}}};var s=r(93379),a=r.n(s),o=r(59414),n={insert:"head",singleton:!1};a()(o.Z,n);o.Z.locals;const l=(0,r(51900).Z)(i,(function(){var e=this,t=e.$createElement,r=e._self._c||t;return r("div",[r("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.articleForm.errors.clear(t.target.name)}}},[r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[e._v(e._s(e.trans("post.article_type"))+" ")]),e._v(" "),e.hasPermission("access-configuration")?r("button",{staticClass:"btn btn-xs btn-info pull-right",attrs:{type:"button"},on:{click:function(t){e.showArticleTypeModal=!0}}},[e._v(e._s(e.trans("general.add_new")))]):e._e(),e._v(" "),r("v-select",{attrs:{label:"name",name:"article_type_id",id:"article_type_id",options:e.article_types,placeholder:e.trans("post.select_article_type")},on:{select:e.onArticleTypeSelect,close:function(t){return e.articleForm.errors.clear("article_type_id")},remove:function(t){e.articleForm.article_type_id=""}},model:{value:e.selected_article_type,callback:function(t){e.selected_article_type=t},expression:"selected_article_type"}},[e.article_types.length?e._e():r("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),r("show-error",{attrs:{"form-name":e.articleForm,"prop-name":"article_type_id"}})],1),e._v(" "),r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[e._v(e._s(e.trans("post.article_title")))]),e._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:e.articleForm.title,expression:"articleForm.title"}],staticClass:"form-control",attrs:{type:"text",name:"title",placeholder:e.trans("post.article_title")},domProps:{value:e.articleForm.title},on:{input:function(t){t.target.composing||e.$set(e.articleForm,"title",t.target.value)}}}),e._v(" "),r("show-error",{attrs:{"form-name":e.articleForm,"prop-name":"title"}})],1),e._v(" "),r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[e._v(e._s(e.trans("post.date_of_article")))]),e._v(" "),r("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("post.date_of_article")},on:{selected:function(t){return e.articleForm.errors.clear("date_of_article")}},model:{value:e.articleForm.date_of_article,callback:function(t){e.$set(e.articleForm,"date_of_article",t)},expression:"articleForm.date_of_article"}}),e._v(" "),r("show-error",{attrs:{"form-name":e.articleForm,"prop-name":"date_of_article"}})],1),e._v(" "),r("div",{staticClass:"form-group"},[r("label",{staticClass:"custom-control custom-checkbox"},[r("input",{directives:[{name:"model",rawName:"v-model",value:e.articleForm.is_public,expression:"articleForm.is_public"}],staticClass:"custom-control-input",attrs:{type:"checkbox",value:"1"},domProps:{checked:Array.isArray(e.articleForm.is_public)?e._i(e.articleForm.is_public,"1")>-1:e.articleForm.is_public},on:{change:function(t){var r=e.articleForm.is_public,i=t.target,s=!!i.checked;if(Array.isArray(r)){var a=e._i(r,"1");i.checked?a<0&&e.$set(e.articleForm,"is_public",r.concat(["1"])):a>-1&&e.$set(e.articleForm,"is_public",r.slice(0,a).concat(r.slice(a+1)))}else e.$set(e.articleForm,"is_public",s)}}}),e._v(" "),r("span",{staticClass:"custom-control-label"},[e._v(e._s(e.trans("post.article_is_public")))])])]),e._v(" "),r("div",{staticClass:"form-group"},[r("file-upload-input",{attrs:{"button-text":e.trans("general.upload_document"),token:e.articleForm.upload_token,module:"article","clear-file":e.clearAttachment,"module-id":e.module_id}})],1)]),e._v(" "),r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"form-group"},[r("html-editor",{attrs:{name:"description",model:e.articleForm.description,height:"300",isUpdate:!!e.uuid},on:{"update:model":function(t){return e.$set(e.articleForm,"description",t)},clearErrors:function(t){return e.articleForm.errors.clear("description")}}}),e._v(" "),r("show-error",{attrs:{"form-name":e.articleForm,"prop-name":"description"}})],1)])]),e._v(" "),r("div",{staticClass:"card-footer text-right"},[r("router-link",{directives:[{name:"show",rawName:"v-show",value:e.uuid,expression:"uuid"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/post/article"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.uuid?e._e():r("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),r("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.uuid?r("span",[e._v(e._s(e.trans("general.update")))]):r("span",[e._v(e._s(e.trans("general.save")))])])],1)]),e._v(" "),e.showArticleTypeModal?r("transition",{attrs:{name:"modal"}},[r("div",{staticClass:"modal-mask"},[r("div",{staticClass:"modal-wrapper"},[r("div",{staticClass:"modal-container modal-lg"},[r("div",{staticClass:"modal-header"},[e._t("header",(function(){return[e._v("\n                            "+e._s(e.trans("post.add_new_article_type"))+"\n                            "),r("span",{staticClass:"float-right pointer",on:{click:function(t){e.showArticleTypeModal=!1}}},[e._v("x")])]}))],2),e._v(" "),r("div",{staticClass:"modal-body"},[e._t("body",(function(){return[r("article-type-form",{on:{completed:e.getPreRequisite,cancel:function(t){e.showArticleTypeModal=!1}}}),e._v(" "),r("div",{staticClass:"clearfix"})]}))],2)])])])]):e._e()],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=df4aa75d3788914a6866