(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[7466],{24128:(e,s,t)=>{"use strict";t.d(s,{Z:()=>r});var n=t(94015),o=t.n(n),l=t(23645),a=t.n(l)()(o());a.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/resource/lesson-plan/form.vue"],names:[],mappings:"AAyQA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="lessonPlanForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'academic.batch\')}} </label>\n                        <v-select label="name" v-model="selected_batch" group-values="batches" group-label="course_group" :group-select="false" name="batch_id" id="batch_id" :options="batches" :placeholder="trans(\'academic.select_batch\')" @select="onBatchSelect" @close="lessonPlanForm.errors.clear(\'batch_id\')" @remove="lessonPlanForm.batch_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!batches.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="lessonPlanForm" prop-name="batch_id"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group" v-if="lessonPlanForm.batch_id">\n                        <label for="">{{trans(\'academic.subject\')}} </label>\n                        <v-select label="name" v-model="selected_subject" name="subject_id" id="subject_id" :options="subjects" :placeholder="trans(\'resource.select_subject\')" @select="onSubjectSelect" @close="lessonPlanForm.errors.clear(\'subject_id\')" @remove="lessonPlanForm.subject_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!subjects.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="lessonPlanForm" prop-name="subject_id"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'resource.lesson_plan_start_date\')}}</label>\n                        <datepicker v-model="lessonPlanForm.start_date" :bootstrapStyling="true" @selected="lessonPlanForm.errors.clear(\'start_date\')" :placeholder="trans(\'resource.lesson_plan_start_date\')"></datepicker>\n                        <show-error :form-name="lessonPlanForm" prop-name="start_date"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'resource.lesson_plan_end_date\')}}</label>\n                        <datepicker v-model="lessonPlanForm.end_date" :bootstrapStyling="true" @selected="lessonPlanForm.errors.clear(\'end_date\')" :placeholder="trans(\'resource.lesson_plan_end_date\')"></datepicker>\n                        <show-error :form-name="lessonPlanForm" prop-name="end_date"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="row">\n                <div class="col-12">\n                    <div class="form-group">\n                        <label for="">{{trans(\'resource.lesson_plan_topic\')}}</label>\n                        <input class="form-control" type="text" v-model="lessonPlanForm.topic" name="topic" :placeholder="trans(\'resource.lesson_plan_topic\')">\n                        <show-error :form-name="lessonPlanForm" prop-name="topic"></show-error>\n                    </div>\n                    <template v-for="(detail,index) in lessonPlanForm.details">\n                        <div class="row">\n                            <div class="col-12 col-sm-6">\n                                <div class="form-group">\n                                    <label for="">{{trans(\'resource.lesson_plan_detail_title\')}} \n                                    <button type="button" class="btn btn-xs btn-danger m-l-20" :key="`${index}_delete_detail`" v-confirm="{ok: confirmDeleteDetail(index)}" v-tooltip="trans(\'general.delete\')"><i class="fas fa-times"></i></button></label>\n                                    <input class="form-control" type="text" v-model="detail.title" :name="getDetailTitleName(index)" :placeholder="trans(\'resource.lesson_plan_detail_title\')">\n                                    <show-error :form-name="lessonPlanForm" :prop-name="getDetailTitleName(index)"></show-error>\n                                </div>\n                            </div>\n                            <div class="col-12 col-sm-6">\n                                <div class="form-group">\n                                    <label for="">{{trans(\'resource.lesson_plan_detail_description\')}}</label>\n                                    <autosize-textarea v-model="detail.description" rows="2" :name="getDetailDescriptionName(index)" :placeholder="trans(\'resource.lesson_plan_detail_description\')"></autosize-textarea>\n                                    <show-error :form-name="lessonPlanForm" :prop-name="getDetailDescriptionName(index)"></show-error>\n                                </div>\n                            </div>\n                        </div>\n                    </template>\n                    <div class="form-group">\n                        <button type="button" @click="addRow" class="btn btn-info btn-sm waves-effect waves-light">{{trans(\'resource.lesson_plan_add_new_detail\')}}</button>\n                    </div>\n                    <div class="form-group">\n                        <file-upload-input :button-text="trans(\'general.upload_document\')" :token="lessonPlanForm.upload_token" module="lesson_plan" :clear-file="clearAttachment" :module-id="module_id"></file-upload-input>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer text-right">\n                <router-link to="/resource/lesson/plan" class="btn btn-danger waves-effect waves-light ">{{trans(\'general.cancel\')}}</router-link>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="uuid">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n    </div>\n</template>\n\n\n<script>\n\n    export default {\n        components: {},\n        data() {\n            return {\n                lessonPlanForm: new Form({\n                    batch_id: \'\',\n                    subject_id: \'\',\n                    topic: \'\',\n                    start_date: \'\',\n                    end_date: \'\',\n                    details: [],\n                    upload_token: \'\'\n                }),\n                batches: [],\n                selected_batch: null,\n                subjects: [],\n                selected_subject: null,\n                subject_detail: [],\n                module_id: \'\',\n                clearAttachment: true\n            };\n        },\n        props: [\'uuid\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-lesson-plan\') && !helper.hasPermission(\'edit-lesson-plan\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            if(this.uuid)\n                this.get();\n            else {\n                this.addRow();\n                this.lessonPlanForm.upload_token = this.$uuid.v4();\n            }\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            addRow(){\n                let new_index = this.lessonPlanForm.details.push({\n                    title: \'\',\n                    description: \'\'\n                })\n            },\n            confirmDeleteDetail(index){\n                return dialog => this.deleteDetail(index);\n            },\n            deleteDetail(index){\n                this.lessonPlanForm.details.splice(index, 1);\n            },\n            getDetailTitleName(index){\n                return index+\'_detail_title\';\n            },\n            getDetailDescriptionName(index){\n                return index+\'_detail_description\';\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/lesson/plan/pre-requisite\')\n                    .then(response => {\n                        this.batches = response.batches;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            getSubjects(){\n                if (!this.uuid) {\n                    this.lessonPlanForm.subject_id = \'\';\n                    this.selected_subject = null;\n                }\n                let loader = this.$loading.show();\n                axios.post(\'/api/batch/\'+this.lessonPlanForm.batch_id+\'/subjects\')\n                    .then(response => {\n                        this.subjects = response.subjects;\n                        this.subject_details = response.subject_details;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            proceed(){\n                if(this.uuid)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.lessonPlanForm.post(\'/api/lesson/plan\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.clearAttachment = !this.clearAttachment;\n                        this.lessonPlanForm.upload_token = this.$uuid.v4();\n                        this.selected_batch = null;\n                        this.selected_subject = null;\n                        this.lessonPlanForm.details = [];\n                        this.addRow();\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/lesson/plan/\'+this.uuid)\n                    .then(response => {\n                        let lesson_plan = response.lesson_plan;\n                        this.lessonPlanForm.title = lesson_plan.title;\n                        this.lessonPlanForm.topic = lesson_plan.topic;\n                        this.lessonPlanForm.start_date = lesson_plan.start_date;\n                        this.lessonPlanForm.end_date = lesson_plan.end_date;\n                        this.lessonPlanForm.batch_id = lesson_plan.subject.batch_id;\n                        this.lessonPlanForm.subject_id = lesson_plan.subject_id;\n                        this.selected_batch = this.lessonPlanForm.batch_id ? {id: lesson_plan.subject.batch_id, name: lesson_plan.subject.batch.course.name+\' \'+lesson_plan.subject.batch.name} : null;\n                        this.selected_subject = lesson_plan.subject_id ? {id: lesson_plan.subject_id, name: lesson_plan.subject.name+\' (\'+lesson_plan.subject.code+\')\'} : null;\n                        this.lessonPlanForm.upload_token = lesson_plan.upload_token;\n\n                        lesson_plan.lesson_plan_details.forEach(lesson_plan_detail => {\n                            this.lessonPlanForm.details.push({\n                                title: lesson_plan_detail.title,\n                                description: lesson_plan_detail.description\n                            });\n                        });\n                        \n                        this.module_id = lesson_plan.id;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/resource/lesson/plan\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.lessonPlanForm.patch(\'/api/lesson/plan/\'+this.uuid)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/resource/lesson/plan\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            onBatchSelect(selectedOption){\n                this.lessonPlanForm.batch_id = selectedOption.id;\n            },\n            onSubjectSelect(selectedOption){\n                this.lessonPlanForm.subject_id = selectedOption.id;\n            }\n        },\n        watch: {\n            \'lessonPlanForm.batch_id\': function(val) {\n                if (val) {\n                    this.getSubjects();\n                }\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const r=a},72464:(e,s,t)=>{"use strict";t.r(s),t.d(s,{default:()=>o});const n={components:{lessonPlanForm:t(92167).Z},data:function(){return{uuid:this.$route.params.uuid}},mounted:function(){helper.hasPermission("edit-lesson-plan")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const o=(0,t(51900).Z)(n,(function(){var e=this,s=e.$createElement,t=e._self._c||s;return t("div",[t("div",{staticClass:"page-titles"},[t("div",{staticClass:"row"},[t("div",{staticClass:"col-12 col-sm-6"},[t("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("resource.edit_lesson_plan")))])]),e._v(" "),t("div",{staticClass:"col-12 col-sm-6"},[t("div",{staticClass:"action-buttons pull-right"},[t("button",{staticClass:"btn btn-info btn-sm",on:{click:function(s){return e.$router.push("/resource/lesson/plan")}}},[t("i",{staticClass:"fas fa-list"}),e._v(" "),t("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("resource.lesson_plan")))])])])])])]),e._v(" "),t("div",{staticClass:"container-fluid"},[t("div",{staticClass:"card card-form"},[t("div",{staticClass:"card-body p-t-20"},[t("lesson-plan-form",{attrs:{uuid:e.uuid}})],1)])])])}),[],!1,null,null,null).exports},92167:(e,s,t)=>{"use strict";t.d(s,{Z:()=>i});const n={components:{},data:function(){return{lessonPlanForm:new Form({batch_id:"",subject_id:"",topic:"",start_date:"",end_date:"",details:[],upload_token:""}),batches:[],selected_batch:null,subjects:[],selected_subject:null,subject_detail:[],module_id:"",clearAttachment:!0}},props:["uuid"],mounted:function(){helper.hasPermission("create-lesson-plan")||helper.hasPermission("edit-lesson-plan")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.uuid?this.get():(this.addRow(),this.lessonPlanForm.upload_token=this.$uuid.v4()),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},addRow:function(){this.lessonPlanForm.details.push({title:"",description:""})},confirmDeleteDetail:function(e){var s=this;return function(t){return s.deleteDetail(e)}},deleteDetail:function(e){this.lessonPlanForm.details.splice(e,1)},getDetailTitleName:function(e){return e+"_detail_title"},getDetailDescriptionName:function(e){return e+"_detail_description"},getPreRequisite:function(){var e=this,s=this.$loading.show();axios.get("/api/lesson/plan/pre-requisite").then((function(t){e.batches=t.batches,s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},getSubjects:function(){var e=this;this.uuid||(this.lessonPlanForm.subject_id="",this.selected_subject=null);var s=this.$loading.show();axios.post("/api/batch/"+this.lessonPlanForm.batch_id+"/subjects").then((function(t){e.subjects=t.subjects,e.subject_details=t.subject_details,s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},proceed:function(){this.uuid?this.update():this.store()},store:function(){var e=this,s=this.$loading.show();this.lessonPlanForm.post("/api/lesson/plan").then((function(t){toastr.success(t.message),e.clearAttachment=!e.clearAttachment,e.lessonPlanForm.upload_token=e.$uuid.v4(),e.selected_batch=null,e.selected_subject=null,e.lessonPlanForm.details=[],e.addRow(),e.$emit("completed"),s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,s=this.$loading.show();axios.get("/api/lesson/plan/"+this.uuid).then((function(t){var n=t.lesson_plan;e.lessonPlanForm.title=n.title,e.lessonPlanForm.topic=n.topic,e.lessonPlanForm.start_date=n.start_date,e.lessonPlanForm.end_date=n.end_date,e.lessonPlanForm.batch_id=n.subject.batch_id,e.lessonPlanForm.subject_id=n.subject_id,e.selected_batch=e.lessonPlanForm.batch_id?{id:n.subject.batch_id,name:n.subject.batch.course.name+" "+n.subject.batch.name}:null,e.selected_subject=n.subject_id?{id:n.subject_id,name:n.subject.name+" ("+n.subject.code+")"}:null,e.lessonPlanForm.upload_token=n.upload_token,n.lesson_plan_details.forEach((function(s){e.lessonPlanForm.details.push({title:s.title,description:s.description})})),e.module_id=n.id,s.hide()})).catch((function(t){s.hide(),helper.showErrorMsg(t),e.$router.push("/resource/lesson/plan")}))},update:function(){var e=this,s=this.$loading.show();this.lessonPlanForm.patch("/api/lesson/plan/"+this.uuid).then((function(t){toastr.success(t.message),s.hide(),e.$router.push("/resource/lesson/plan")})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},onBatchSelect:function(e){this.lessonPlanForm.batch_id=e.id},onSubjectSelect:function(e){this.lessonPlanForm.subject_id=e.id}},watch:{"lessonPlanForm.batch_id":function(e){e&&this.getSubjects()}}};var o=t(93379),l=t.n(o),a=t(24128),r={insert:"head",singleton:!1};l()(a.Z,r);a.Z.locals;const i=(0,t(51900).Z)(n,(function(){var e=this,s=e.$createElement,t=e._self._c||s;return t("div",[t("form",{on:{submit:function(s){return s.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(s){return e.lessonPlanForm.errors.clear(s.target.name)}}},[t("div",{staticClass:"row"},[t("div",{staticClass:"col-12 col-sm-3"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.batch"))+" ")]),e._v(" "),t("v-select",{attrs:{label:"name","group-values":"batches","group-label":"course_group","group-select":!1,name:"batch_id",id:"batch_id",options:e.batches,placeholder:e.trans("academic.select_batch")},on:{select:e.onBatchSelect,close:function(s){return e.lessonPlanForm.errors.clear("batch_id")},remove:function(s){e.lessonPlanForm.batch_id=""}},model:{value:e.selected_batch,callback:function(s){e.selected_batch=s},expression:"selected_batch"}},[e.batches.length?e._e():t("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),t("show-error",{attrs:{"form-name":e.lessonPlanForm,"prop-name":"batch_id"}})],1)]),e._v(" "),t("div",{staticClass:"col-12 col-sm-3"},[e.lessonPlanForm.batch_id?t("div",{staticClass:"form-group"},[t("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.subject"))+" ")]),e._v(" "),t("v-select",{attrs:{label:"name",name:"subject_id",id:"subject_id",options:e.subjects,placeholder:e.trans("resource.select_subject")},on:{select:e.onSubjectSelect,close:function(s){return e.lessonPlanForm.errors.clear("subject_id")},remove:function(s){e.lessonPlanForm.subject_id=""}},model:{value:e.selected_subject,callback:function(s){e.selected_subject=s},expression:"selected_subject"}},[e.subjects.length?e._e():t("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),t("show-error",{attrs:{"form-name":e.lessonPlanForm,"prop-name":"subject_id"}})],1):e._e()]),e._v(" "),t("div",{staticClass:"col-12 col-sm-3"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.lesson_plan_start_date")))]),e._v(" "),t("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("resource.lesson_plan_start_date")},on:{selected:function(s){return e.lessonPlanForm.errors.clear("start_date")}},model:{value:e.lessonPlanForm.start_date,callback:function(s){e.$set(e.lessonPlanForm,"start_date",s)},expression:"lessonPlanForm.start_date"}}),e._v(" "),t("show-error",{attrs:{"form-name":e.lessonPlanForm,"prop-name":"start_date"}})],1)]),e._v(" "),t("div",{staticClass:"col-12 col-sm-3"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.lesson_plan_end_date")))]),e._v(" "),t("datepicker",{attrs:{bootstrapStyling:!0,placeholder:e.trans("resource.lesson_plan_end_date")},on:{selected:function(s){return e.lessonPlanForm.errors.clear("end_date")}},model:{value:e.lessonPlanForm.end_date,callback:function(s){e.$set(e.lessonPlanForm,"end_date",s)},expression:"lessonPlanForm.end_date"}}),e._v(" "),t("show-error",{attrs:{"form-name":e.lessonPlanForm,"prop-name":"end_date"}})],1)])]),e._v(" "),t("div",{staticClass:"row"},[t("div",{staticClass:"col-12"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.lesson_plan_topic")))]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model",value:e.lessonPlanForm.topic,expression:"lessonPlanForm.topic"}],staticClass:"form-control",attrs:{type:"text",name:"topic",placeholder:e.trans("resource.lesson_plan_topic")},domProps:{value:e.lessonPlanForm.topic},on:{input:function(s){s.target.composing||e.$set(e.lessonPlanForm,"topic",s.target.value)}}}),e._v(" "),t("show-error",{attrs:{"form-name":e.lessonPlanForm,"prop-name":"topic"}})],1),e._v(" "),e._l(e.lessonPlanForm.details,(function(s,n){return[t("div",{staticClass:"row"},[t("div",{staticClass:"col-12 col-sm-6"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.lesson_plan_detail_title"))+" \n                                "),t("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:e.confirmDeleteDetail(n)},expression:"{ok: confirmDeleteDetail(index)}"},{name:"tooltip",rawName:"v-tooltip",value:e.trans("general.delete"),expression:"trans('general.delete')"}],key:n+"_delete_detail",staticClass:"btn btn-xs btn-danger m-l-20",attrs:{type:"button"}},[t("i",{staticClass:"fas fa-times"})])]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model",value:s.title,expression:"detail.title"}],staticClass:"form-control",attrs:{type:"text",name:e.getDetailTitleName(n),placeholder:e.trans("resource.lesson_plan_detail_title")},domProps:{value:s.title},on:{input:function(t){t.target.composing||e.$set(s,"title",t.target.value)}}}),e._v(" "),t("show-error",{attrs:{"form-name":e.lessonPlanForm,"prop-name":e.getDetailTitleName(n)}})],1)]),e._v(" "),t("div",{staticClass:"col-12 col-sm-6"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.lesson_plan_detail_description")))]),e._v(" "),t("autosize-textarea",{attrs:{rows:"2",name:e.getDetailDescriptionName(n),placeholder:e.trans("resource.lesson_plan_detail_description")},model:{value:s.description,callback:function(t){e.$set(s,"description",t)},expression:"detail.description"}}),e._v(" "),t("show-error",{attrs:{"form-name":e.lessonPlanForm,"prop-name":e.getDetailDescriptionName(n)}})],1)])])]})),e._v(" "),t("div",{staticClass:"form-group"},[t("button",{staticClass:"btn btn-info btn-sm waves-effect waves-light",attrs:{type:"button"},on:{click:e.addRow}},[e._v(e._s(e.trans("resource.lesson_plan_add_new_detail")))])]),e._v(" "),t("div",{staticClass:"form-group"},[t("file-upload-input",{attrs:{"button-text":e.trans("general.upload_document"),token:e.lessonPlanForm.upload_token,module:"lesson_plan","clear-file":e.clearAttachment,"module-id":e.module_id}})],1)],2)]),e._v(" "),t("div",{staticClass:"card-footer text-right"},[t("router-link",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/resource/lesson/plan"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),t("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.uuid?t("span",[e._v(e._s(e.trans("general.update")))]):t("span",[e._v(e._s(e.trans("general.save")))])])],1)])])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=780abc0bfaca24e4782d