(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[8080,5549],{32829:(e,t,s)=>{"use strict";s.d(t,{Z:()=>r});var n=s(94015),o=s.n(n),a=s(23645),i=s.n(a)()(o());i.push([e.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/resource/notes/form.vue"],names:[],mappings:"AAoMA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="notesForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <label for="">{{trans(\'academic.batch\')}} </label>\n                        <v-select label="name" v-model="selected_batch" group-values="batches" group-label="course_group" :group-select="false" name="batch_id" id="batch_id" :options="batches" :placeholder="trans(\'academic.select_batch\')" @select="onBatchSelect" @close="notesForm.errors.clear(\'batch_id\')" @remove="notesForm.batch_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!batches.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="notesForm" prop-name="batch_id"></show-error>\n                    </div>\n                    <div class="form-group" v-if="notesForm.batch_id">\n                        <label for="">{{trans(\'academic.subject\')}} </label>\n                        <v-select label="name" v-model="selected_subject" name="subject_id" id="subject_id" :options="subjects" :placeholder="trans(\'resource.select_subject\')" @select="onSubjectSelect" @close="notesForm.errors.clear(\'subject_id\')" @remove="notesForm.subject_id = \'\'">\n                            <div class="multiselect__option" slot="afterList" v-if="!subjects.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="notesForm" prop-name="subject_id"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <label for="">{{trans(\'resource.notes_title\')}}</label>\n                        <input class="form-control" type="text" v-model="notesForm.title" name="title" :placeholder="trans(\'resource.notes_title\')">\n                        <show-error :form-name="notesForm" prop-name="title"></show-error>\n                    </div>\n                    <div class="form-group">\n                        <file-upload-input :button-text="trans(\'general.upload_document\')" :token="notesForm.upload_token" module="notes" :clear-file="clearAttachment" :module-id="module_id"></file-upload-input>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="form-group">\n                        <html-editor name="description" :model.sync="notesForm.description" height="300" :isUpdate="uuid ? true : false" @clearErrors="notesForm.errors.clear(\'description\')"></html-editor>\n                        <show-error :form-name="notesForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer text-right">\n                <router-link to="/resource/notes" class="btn btn-danger waves-effect waves-light " v-show="uuid">{{trans(\'general.cancel\')}}</router-link>\n                <button v-if="!uuid" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                <button type="submit" class="btn btn-info waves-effect waves-light">\n                    <span v-if="uuid">{{trans(\'general.update\')}}</span>\n                    <span v-else>{{trans(\'general.save\')}}</span>\n                </button>\n            </div>\n        </form>\n    </div>\n</template>\n\n\n<script>\n\n    export default {\n        components: {},\n        data() {\n            return {\n                notesForm: new Form({\n                    batch_id: \'\',\n                    subject_id: \'\',\n                    title: \'\',\n                    description: \'\',\n                    upload_token: \'\'\n                }),\n                batches: [],\n                selected_batch: null,\n                subjects: [],\n                selected_subject: null,\n                subject_detail: [],\n                module_id: \'\',\n                clearAttachment: true\n            };\n        },\n        props: [\'uuid\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-notes\') && !helper.hasPermission(\'edit-notes\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            if(this.uuid)\n                this.get();\n            else\n                this.notesForm.upload_token = this.$uuid.v4();\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/notes/pre-requisite\')\n                    .then(response => {\n                        this.batches = response.batches;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            getSubjects(){\n                if (!this.uuid) {\n                    this.notesForm.subject_id = \'\';\n                    this.selected_subject = null;\n                }\n                let loader = this.$loading.show();\n                axios.post(\'/api/batch/\'+this.notesForm.batch_id+\'/subjects\')\n                    .then(response => {\n                        this.subjects = response.subjects;\n                        this.subject_details = response.subject_details;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            proceed(){\n                if(this.uuid)\n                    this.update();\n                else\n                    this.store();\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.notesForm.post(\'/api/notes\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.clearAttachment = !this.clearAttachment;\n                        this.notesForm.upload_token = this.$uuid.v4();\n                        this.selected_batch = null;\n                        this.selected_subject = null;\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/notes/\'+this.uuid)\n                    .then(response => {\n                        let notes = response.notes;\n                        this.notesForm.title = notes.title;\n                        this.notesForm.description = notes.description;\n                        this.notesForm.batch_id = notes.subject.batch_id;\n                        this.notesForm.subject_id = notes.subject_id;\n                        this.selected_batch = this.notesForm.batch_id ? {id: notes.subject.batch_id, name: notes.subject.batch.course.name+\' \'+notes.subject.batch.name} : null;\n                        this.selected_subject = notes.subject_id ? {id: notes.subject_id, name: notes.subject.name+\' (\'+notes.subject.code+\')\'} : null;\n                        this.notesForm.upload_token = notes.upload_token;\n                        this.module_id = notes.id;\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/resource/notes\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.notesForm.patch(\'/api/notes/\'+this.uuid)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/resource/notes\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            onBatchSelect(selectedOption){\n                this.notesForm.batch_id = selectedOption.id;\n            },\n            onSubjectSelect(selectedOption){\n                this.notesForm.subject_id = selectedOption.id;\n            }\n        },\n        watch: {\n            \'notesForm.batch_id\': function(val) {\n                if (val) {\n                    this.getSubjects();\n                }\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const r=i},61093:(e,t,s)=>{"use strict";s.d(t,{Z:()=>l});const n={components:{},data:function(){return{notesForm:new Form({batch_id:"",subject_id:"",title:"",description:"",upload_token:""}),batches:[],selected_batch:null,subjects:[],selected_subject:null,subject_detail:[],module_id:"",clearAttachment:!0}},props:["uuid"],mounted:function(){helper.hasPermission("create-notes")||helper.hasPermission("edit-notes")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.uuid?this.get():this.notesForm.upload_token=this.$uuid.v4(),this.getPreRequisite()},methods:{hasPermission:function(e){return helper.hasPermission(e)},getPreRequisite:function(){var e=this,t=this.$loading.show();axios.get("/api/notes/pre-requisite").then((function(s){e.batches=s.batches,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},getSubjects:function(){var e=this;this.uuid||(this.notesForm.subject_id="",this.selected_subject=null);var t=this.$loading.show();axios.post("/api/batch/"+this.notesForm.batch_id+"/subjects").then((function(s){e.subjects=s.subjects,e.subject_details=s.subject_details,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},proceed:function(){this.uuid?this.update():this.store()},store:function(){var e=this,t=this.$loading.show();this.notesForm.post("/api/notes").then((function(s){toastr.success(s.message),e.clearAttachment=!e.clearAttachment,e.notesForm.upload_token=e.$uuid.v4(),e.selected_batch=null,e.selected_subject=null,e.$emit("completed"),t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},get:function(){var e=this,t=this.$loading.show();axios.get("/api/notes/"+this.uuid).then((function(s){var n=s.notes;e.notesForm.title=n.title,e.notesForm.description=n.description,e.notesForm.batch_id=n.subject.batch_id,e.notesForm.subject_id=n.subject_id,e.selected_batch=e.notesForm.batch_id?{id:n.subject.batch_id,name:n.subject.batch.course.name+" "+n.subject.batch.name}:null,e.selected_subject=n.subject_id?{id:n.subject_id,name:n.subject.name+" ("+n.subject.code+")"}:null,e.notesForm.upload_token=n.upload_token,e.module_id=n.id,t.hide()})).catch((function(s){t.hide(),helper.showErrorMsg(s),e.$router.push("/resource/notes")}))},update:function(){var e=this,t=this.$loading.show();this.notesForm.patch("/api/notes/"+this.uuid).then((function(s){toastr.success(s.message),t.hide(),e.$router.push("/resource/notes")})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},onBatchSelect:function(e){this.notesForm.batch_id=e.id},onSubjectSelect:function(e){this.notesForm.subject_id=e.id}},watch:{"notesForm.batch_id":function(e){e&&this.getSubjects()}}};var o=s(93379),a=s.n(o),i=s(32829),r={insert:"head",singleton:!1};a()(i.Z,r);i.Z.locals;const l=(0,s(51900).Z)(n,(function(){var e=this,t=e.$createElement,s=e._self._c||t;return s("div",[s("form",{on:{submit:function(t){return t.preventDefault(),e.proceed.apply(null,arguments)},keydown:function(t){return e.notesForm.errors.clear(t.target.name)}}},[s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-6"},[s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.batch"))+" ")]),e._v(" "),s("v-select",{attrs:{label:"name","group-values":"batches","group-label":"course_group","group-select":!1,name:"batch_id",id:"batch_id",options:e.batches,placeholder:e.trans("academic.select_batch")},on:{select:e.onBatchSelect,close:function(t){return e.notesForm.errors.clear("batch_id")},remove:function(t){e.notesForm.batch_id=""}},model:{value:e.selected_batch,callback:function(t){e.selected_batch=t},expression:"selected_batch"}},[e.batches.length?e._e():s("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"batch_id"}})],1),e._v(" "),e.notesForm.batch_id?s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.subject"))+" ")]),e._v(" "),s("v-select",{attrs:{label:"name",name:"subject_id",id:"subject_id",options:e.subjects,placeholder:e.trans("resource.select_subject")},on:{select:e.onSubjectSelect,close:function(t){return e.notesForm.errors.clear("subject_id")},remove:function(t){e.notesForm.subject_id=""}},model:{value:e.selected_subject,callback:function(t){e.selected_subject=t},expression:"selected_subject"}},[e.subjects.length?e._e():s("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                            "+e._s(e.trans("general.no_option_found"))+"\n                        ")])]),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"subject_id"}})],1):e._e(),e._v(" "),s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.notes_title")))]),e._v(" "),s("input",{directives:[{name:"model",rawName:"v-model",value:e.notesForm.title,expression:"notesForm.title"}],staticClass:"form-control",attrs:{type:"text",name:"title",placeholder:e.trans("resource.notes_title")},domProps:{value:e.notesForm.title},on:{input:function(t){t.target.composing||e.$set(e.notesForm,"title",t.target.value)}}}),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"title"}})],1),e._v(" "),s("div",{staticClass:"form-group"},[s("file-upload-input",{attrs:{"button-text":e.trans("general.upload_document"),token:e.notesForm.upload_token,module:"notes","clear-file":e.clearAttachment,"module-id":e.module_id}})],1)]),e._v(" "),s("div",{staticClass:"col-12 col-sm-6"},[s("div",{staticClass:"form-group"},[s("html-editor",{attrs:{name:"description",model:e.notesForm.description,height:"300",isUpdate:!!e.uuid},on:{"update:model":function(t){return e.$set(e.notesForm,"description",t)},clearErrors:function(t){return e.notesForm.errors.clear("description")}}}),e._v(" "),s("show-error",{attrs:{"form-name":e.notesForm,"prop-name":"description"}})],1)])]),e._v(" "),s("div",{staticClass:"card-footer text-right"},[s("router-link",{directives:[{name:"show",rawName:"v-show",value:e.uuid,expression:"uuid"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/resource/notes"}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),e.uuid?e._e():s("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(t){return e.$emit("cancel")}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),s("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[e.uuid?s("span",[e._v(e._s(e.trans("general.update")))]):s("span",[e._v(e._s(e.trans("general.save")))])])],1)])])}),[],!1,null,null,null).exports},73983:(e,t,s)=>{"use strict";s.r(t),s.d(t,{default:()=>i});var n=s(61093),o=s(62375);const a={components:{notesForm:n.Z,notesDetail:o.default},data:function(){return{notes:{total:0,data:[]},filter:{sort_by:"created_at",order:"desc",title:"",batch_id:[],page_length:helper.getConfig("page_length")},orderByOptions:[{value:"created_at",translation:i18n.general.created_at},{value:"title",translation:i18n.resource.notes_title}],batches:[],selected_batches:null,showFilterPanel:!1,showCreatePanel:!1,help_topic:"",showUuid:"",showModal:!1}},mounted:function(){helper.hasPermission("list-notes")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getNotes(),helper.showDemoNotification(["resource"])},methods:{hasPermission:function(e){return helper.hasPermission(e)},showAction:function(e){this.showUuid=e.uuid,this.showModal=!0},getEmployeeName:function(e){return helper.getEmployeeName(e)},getEmployeeDesignationOnDate:function(e,t){return helper.getEmployeeDesignationOnDate(e,t)},getNotes:function(e){var t=this,s=this.$loading.show();"number"!=typeof e&&(e=1);var n=helper.getFilterURL(this.filter);axios.get("/api/notes?page="+e+n).then((function(e){t.notes=e.notes,t.batches=e.filters.batches,s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},editNotes:function(e){this.$router.push("/resource/notes/"+e.uuid+"/edit")},confirmDelete:function(e){var t=this;return function(s){return t.deleteNotes(e)}},deleteNotes:function(e){var t=this,s=this.$loading.show();axios.delete("/api/notes/"+e.uuid).then((function(e){toastr.success(e.message),t.getNotes(),s.hide()})).catch((function(e){s.hide(),helper.showErrorMsg(e)}))},getConfig:function(e){return helper.getConfig(e)},print:function(){var e=this.$loading.show();axios.post("/api/notes/print",{filter:this.filter}).then((function(t){var s=window.open("/print");e.hide(),s.document.write(t)})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},pdf:function(){var e=this,t=this.$loading.show();axios.post("/api/notes/pdf",{filter:this.filter}).then((function(s){t.hide(),window.open("/download/report/"+s+"?token="+e.authToken)})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},onBatchSelect:function(e){this.filter.batch_id.push(e.id)},onBatchRemove:function(e){this.filter.batch_id.splice(this.filter.batch_id.indexOf(e.id),1)}},filters:{moment:function(e){return helper.formatDate(e)},momentDateTime:function(e){return helper.formatDateTime(e)}},watch:{"filter.sort_by":function(e){this.getNotes()},"filter.order":function(e){this.getNotes()},"filter.page_length":function(e){this.getNotes()}},computed:{authToken:function(){return helper.getAuthToken()}}};const i=(0,s(51900).Z)(a,(function(){var e=this,t=e.$createElement,s=e._self._c||t;return s("div",[s("div",{staticClass:"page-titles"},[s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-6"},[s("h3",{staticClass:"text-themecolor"},[e._v(e._s(e.trans("resource.notes"))+" \n                    "),e.notes.total?s("span",{staticClass:"card-subtitle d-none d-sm-inline"},[e._v(e._s(e.trans("general.total_result_found",{count:e.notes.total,from:e.notes.from,to:e.notes.to})))]):s("span",{staticClass:"card-subtitle d-none d-sm-inline"},[e._v(e._s(e.trans("general.no_result_found")))])])]),e._v(" "),s("div",{staticClass:"col-12 col-sm-6"},[s("div",{staticClass:"action-buttons pull-right"},[e.notes.total&&!e.showCreatePanel&&e.hasPermission("create-notes")?s("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("general.add_new"),expression:"trans('general.add_new')"}],staticClass:"btn btn-info btn-sm",on:{click:function(t){e.showCreatePanel=!e.showCreatePanel}}},[s("i",{staticClass:"fas fa-plus"}),e._v(" "),s("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("resource.add_new_notes")))])]):e._e(),e._v(" "),e.showFilterPanel?e._e():s("button",{staticClass:"btn btn-info btn-sm",on:{click:function(t){e.showFilterPanel=!e.showFilterPanel}}},[s("i",{staticClass:"fas fa-filter"}),e._v(" "),s("span",{staticClass:"d-none d-sm-inline"},[e._v(e._s(e.trans("general.filter")))])]),e._v(" "),s("sort-by",{attrs:{"order-by-options":e.orderByOptions,"sort-by":e.filter.sort_by,order:e.filter.order},on:{updateSortBy:function(t){e.filter.sort_by=t},updateOrder:function(t){e.filter.order=t}}}),e._v(" "),s("div",{staticClass:"btn-group"},[s("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-sm dropdown-toggle no-caret ",attrs:{type:"button",role:"menu",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[s("i",{staticClass:"fas fa-ellipsis-h"}),e._v(" "),s("span",{staticClass:"d-none d-sm-inline"})]),e._v(" "),s("div",{class:["dropdown-menu","ltr"==e.getConfig("direction")?"dropdown-menu-right":""],attrs:{"aria-labelledby":"moreOption"}},[s("button",{staticClass:"dropdown-item custom-dropdown",on:{click:e.print}},[s("i",{staticClass:"fas fa-print"}),e._v(" "+e._s(e.trans("general.print")))]),e._v(" "),s("button",{staticClass:"dropdown-item custom-dropdown",on:{click:e.pdf}},[s("i",{staticClass:"fas fa-file-pdf"}),e._v(" "+e._s(e.trans("general.generate_pdf")))])])]),e._v(" "),s("help-button",{on:{clicked:function(t){e.help_topic="resource.notes"}}})],1)])])]),e._v(" "),s("div",{staticClass:"container-fluid"},[s("transition",{attrs:{name:"fade"}},[e.showFilterPanel?s("div",{staticClass:"card card-form"},[s("div",{staticClass:"card-body"},[s("h4",{staticClass:"card-title"},[e._v(e._s(e.trans("general.filter")))]),e._v(" "),s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-3"},[s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("academic.batch")))]),e._v(" "),s("v-select",{attrs:{label:"name","track-by":"id","group-values":"batches","group-label":"course_group","group-select":!1,name:"batch_id",id:"batch_id",options:e.batches,placeholder:e.trans("academic.select_batch"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:e.selected_batches},on:{select:e.onBatchSelect,remove:e.onBatchRemove},model:{value:e.selected_batches,callback:function(t){e.selected_batches=t},expression:"selected_batches"}},[e.batches.length?e._e():s("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[e._v("\n                                        "+e._s(e.trans("general.no_option_found"))+"\n                                    ")])])],1)]),e._v(" "),s("div",{staticClass:"col-12 col-sm-3"},[s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[e._v(e._s(e.trans("resource.notes_title")))]),e._v(" "),s("input",{directives:[{name:"model",rawName:"v-model",value:e.filter.title,expression:"filter.title"}],staticClass:"form-control",attrs:{name:"title"},domProps:{value:e.filter.title},on:{input:function(t){t.target.composing||e.$set(e.filter,"title",t.target.value)}}})])])]),e._v(" "),s("div",{staticClass:"card-footer text-right"},[s("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(t){e.showFilterPanel=!1}}},[e._v(e._s(e.trans("general.cancel")))]),e._v(" "),s("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"button"},on:{click:e.getNotes}},[e._v(e._s(e.trans("general.filter")))])])])]):e._e()]),e._v(" "),e.hasPermission("create-notes")?s("transition",{attrs:{name:"fade"}},[e.showCreatePanel?s("div",{staticClass:"card card-form"},[s("div",{staticClass:"card-body"},[s("h4",{staticClass:"card-title"},[e._v(e._s(e.trans("resource.add_new_notes")))]),e._v(" "),s("notes-form",{on:{completed:e.getNotes,cancel:function(t){e.showCreatePanel=!e.showCreatePanel}}})],1)]):e._e()]):e._e(),e._v(" "),s("div",{staticClass:"card"},[s("div",{staticClass:"card-body"},[e.notes.total?s("div",{staticClass:"table-responsive"},[s("table",{staticClass:"table table-sm"},[s("thead",[s("tr",[s("th",[e._v(e._s(e.trans("academic.subject")))]),e._v(" "),s("th",[e._v(e._s(e.trans("academic.batch")))]),e._v(" "),s("th",[e._v(e._s(e.trans("resource.notes_title")))]),e._v(" "),s("th",[e._v(e._s(e.trans("resource.notes_posted_by")))]),e._v(" "),s("th",[e._v(e._s(e.trans("general.created_at")))]),e._v(" "),s("th",{staticClass:"table-option"},[e._v(e._s(e.trans("general.action")))])])]),e._v(" "),s("tbody",e._l(e.notes.data,(function(t){return s("tr",[s("td",{domProps:{textContent:e._s(t.subject.name+" ("+t.subject.code+")")}}),e._v(" "),s("td",{domProps:{textContent:e._s(t.subject.batch.course.name+" "+t.subject.batch.name)}}),e._v(" "),s("td",{domProps:{textContent:e._s(t.title)}}),e._v(" "),s("td",[e._v(e._s(e.getEmployeeName(t.employee))+" "),s("br"),e._v(" "+e._s(e.getEmployeeDesignationOnDate(t.employee,t.created_at)))]),e._v(" "),s("td",[e._v(e._s(e._f("momentDateTime")(t.created_at)))]),e._v(" "),s("td",{staticClass:"table-option"},[s("div",{staticClass:"btn-group"},[s("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("resource.view_notes"),expression:"trans('resource.view_notes')"}],staticClass:"btn btn-success btn-sm",on:{click:function(s){return s.preventDefault(),e.showAction(t)}}},[s("i",{staticClass:"fas fa-arrow-circle-right"})]),e._v(" "),e.hasPermission("edit-notes")?s("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:e.trans("resource.edit_notes"),expression:"trans('resource.edit_notes')"}],staticClass:"btn btn-info btn-sm",on:{click:function(s){return s.preventDefault(),e.editNotes(t)}}},[s("i",{staticClass:"fas fa-edit"})]):e._e(),e._v(" "),e.hasPermission("delete-notes")?s("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:e.confirmDelete(t)},expression:"{ok: confirmDelete(list)}"},{name:"tooltip",rawName:"v-tooltip",value:e.trans("resource.delete_notes"),expression:"trans('resource.delete_notes')"}],key:t.id,staticClass:"btn btn-danger btn-sm"},[s("i",{staticClass:"fas fa-trash"})]):e._e()])])])})),0)])]):e._e(),e._v(" "),e.notes.total?e._e():s("module-info",{attrs:{module:"resource",title:"notes_module_title",description:"notes_module_description",icon:"list"}},[s("div",{attrs:{slot:"btn"},slot:"btn"},[!e.showCreatePanel&&e.hasPermission("create-notes")?s("button",{staticClass:"btn btn-info btn-md",on:{click:function(t){e.showCreatePanel=!e.showCreatePanel}}},[s("i",{staticClass:"fas fa-plus"}),e._v(" "+e._s(e.trans("general.add_new")))]):e._e()])]),e._v(" "),s("pagination-record",{attrs:{"page-length":e.filter.page_length,records:e.notes},on:{"update:pageLength":function(t){return e.$set(e.filter,"page_length",t)},"update:page-length":function(t){return e.$set(e.filter,"page_length",t)},updateRecords:e.getNotes}})],1)])],1),e._v(" "),e.showModal?s("notes-detail",{attrs:{uuid:e.showUuid},on:{close:function(t){e.showModal=!1}}}):e._e(),e._v(" "),s("right-panel",{attrs:{topic:e.help_topic}})],1)}),[],!1,null,null,null).exports},62375:(e,t,s)=>{"use strict";s.r(t),s.d(t,{default:()=>o});const n={components:{},props:["uuid","url"],mounted:function(){this.uuid&&this.get()},data:function(){return{notes:[],attachments:[]}},methods:{get:function(){var e=this,t=this.$loading.show();axios.get("/api/notes/"+this.uuid).then((function(s){e.notes=s.notes,e.attachments=s.attachments,t.hide()})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))},getEmployeeName:function(e){return helper.getEmployeeName(e)},getEmployeeDesignation:function(e,t){return helper.getEmployeeDesignation(e,t)}},computed:{authToken:function(){return helper.getAuthToken()}},filters:{momentDateTime:function(e){return helper.formatDateTime(e)},moment:function(e){return helper.formatDate(e)}}};const o=(0,s(51900).Z)(n,(function(){var e=this,t=e.$createElement,s=e._self._c||t;return s("transition",{attrs:{name:"modal"}},[s("div",{staticClass:"modal-mask"},[s("div",{staticClass:"modal-wrapper"},[s("div",{staticClass:"modal-container modal-lg"},[e.notes.id?s("div",{staticClass:"modal-header"},[e._t("header",(function(){return[s("span",[e._v(e._s(e.notes.title))]),e._v(" "),s("span",{staticClass:"float-right pointer",on:{click:function(t){return e.$emit("close")}}},[e._v("x")])]}))],2):e._e(),e._v(" "),e.notes.id?s("div",{staticClass:"modal-body"},[e._t("body",(function(){return[s("h6",{staticClass:"card-title"},[s("strong",[e._v(e._s(e.trans("academic.subject"))+":")]),e._v(" "+e._s(e.notes.subject.name+" ("+e.notes.subject.code+")")+" \n                            "),s("br"),e._v(" "),s("strong",[e._v(e._s(e.trans("academic.batch"))+":")]),e._v(" "+e._s(e.notes.subject.batch.course.name+" "+e.notes.subject.batch.name)+" \n                            "),e.notes.employee?s("p",{staticClass:"pull-right"},[s("strong",[e._v(e._s(e.trans("resource.notes_posted_by"))+":")]),e._v(" "+e._s(e.getEmployeeName(e.notes.employee))+" "+e._s(e.getEmployeeDesignation(e.notes.employee,e.notes.date_of_notes))+"\n                            ")]):e._e()]),e._v(" "),s("div",{staticClass:"m-t-20 html-view",domProps:{innerHTML:e._s(e.notes.description)}}),e._v(" "),e.attachments.length?s("div",[s("ul",{staticClass:"m-t-10 upload-file-list"},e._l(e.attachments,(function(t){return s("li",{staticClass:"upload-file-list-item"},[s("a",{staticClass:"no-link-color",attrs:{href:"/resource/notes/"+e.notes.uuid+"/attachment/"+t.uuid+"/download?token="+e.authToken}},[s("i",{class:["file-icon","fas","fa-lg",t.file_info.icon]}),e._v(" "),s("span",{staticClass:"upload-file-list-item-size"},[e._v(e._s(t.file_info.size))]),e._v(" "+e._s(t.user_filename))])])})),0)]):e._e(),e._v(" "),s("hr"),e._v(" "),s("p",[s("i",{staticClass:"far fa-clock"}),e._v(" "),s("small",[e._v(e._s(e.trans("general.created_at"))+" "+e._s(e._f("momentDateTime")(e.notes.created_at)))]),e._v(" "),s("span",{staticClass:"pull-right"},[s("i",{staticClass:"far fa-clock"}),e._v(" "),s("small",[e._v(e._s(e.trans("general.updated_at"))+" "+e._s(e._f("momentDateTime")(e.notes.updated_at)))])])])]}))],2):e._e()])])])])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=index.js.map?id=0b8a599d87a2276c0e52