(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[4935],{24056:(t,e,n)=>{"use strict";n.d(e,{Z:()=>o});var s=n(94015),r=n.n(s),a=n(23645),i=n.n(a)()(r());i.push([t.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/student/registration/show.vue"],names:[],mappings:"AA6XA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <div class="page-titles">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                    <h3 class="text-themecolor">{{trans(\'student.registration\')}}\n                        <span class="card-subtitle d-none d-sm-inline" v-if="registration.student">({{getStudentName(registration.student)+\' - \'+trans(\'student.registration_no\')+\': \'+registration.id}}) </span>\n                    </h3>\n                </div>\n                <div class="col-12 col-sm-6">\n                    <div class="action-buttons pull-right">\n                        <router-link to="/student/registration/card-view" class="btn btn-info btn-sm"><i class="fas fa-list"></i> <span class="d-none d-sm-inline">{{trans(\'student.registration\')}}</span></router-link>\n                        <router-link :to="`/student/${registration.student.uuid}`" class="btn btn-info btn-sm"><i class="fas fa-user"></i> <span class="d-none d-sm-inline">{{trans(\'student.student_detail\')}}</span></router-link>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="container-fluid">\n            <div class="row">\n                <div class="col-12 col-sm-6">\n                \t<div class="card border-right">\n                \t\t<div class="card-body">\n                \t\t\t<h4 class="card-title m-3"><span class="d-none d-sm-inline">{{trans(\'student.registration_detail\')}}</span>\n                                <div class="dropdown pull-right" v-if="registration.registration_fee && registration.registration_fee_status == \'paid\' && registration.transactions.length">\n                                    <button type="button" class="btn btn-info btn-xs" href="#" role="button" id="moreOption" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-tooltip="trans(\'general.more_option\')">\n                                        <i class="fas fa-ellipsis-h"></i> <span class="d-none d-sm-inline">{{trans(\'finance.receipt\')}}</span>\n                                    </button>\n                                    <div class="dropdown-menu">\n                                        <button class="dropdown-item custom-dropdown-menu" @click="showReceiptModal = true"><i class="fas fa-arrow-circle-right"></i> {{trans(\'finance.receipt_detail\')}}</button>\n                                        <button class="dropdown-item custom-dropdown-menu" @click="printReceipt"><i class="fas fa-print"></i> {{trans(\'finance.print_receipt\')}}</button>\n                                    </div>\n                                </div>\n                                <button type="button" class="btn btn-info btn-xs pull-right " v-if="registration.status == \'pending\'" @click="editModal = true"><i class="fas fa-edit"></i> <span class="d-none d-sm-inline">{{trans(\'general.edit\')}}</span></button>\n                                <button type="button" class="btn btn-danger btn-xs pull-right " v-if="registration.status == \'pending\' && hasPermission(\'delete-registration\')" :key="registration.id" v-confirm="{ok: confirmDelete(registration)}" v-tooltip="trans(\'student.delete_registartion\')"><i class="fas fa-trash"></i> <span class="d-none d-sm-inline">{{trans(\'general.delete\')}}</span></button>\n                \t\t\t</h4>\n                            <div class="table-responsive">\n                                <table class="table table-sm custom-show-table">\n                                    <tbody>\n                                        <tr>\n                                        \t<td>{{trans(\'student.name\')}}</td>\n                                        \t<td>\n                                                {{getStudentName(registration.student)}}\n                                                <span v-if="registration.is_online">\n                                                    <span class="label label-info">{{trans(\'student.online_registration\')}}</span>\n                                                </span>\n                                            </td>\n                                        </tr>\n                                        <tr>\n                                            <td>{{trans(\'student.registration_status\')}}</td>\n                                            <td>\n                                                <span v-for="status in getRegistrationStatus(registration)" :class="[\'label\',\'label-\'+status.color,\'m-r-5\']">{{status.label}}</span>\n                                            </td>\n                                        </tr>\n                                        <tr v-if="registration.rejection_remarks && registration.status == \'rejected\'">\n                                            <td>{{trans(\'student.rejection_remarks\')}}</td>\n                                            <td class="text-danger">{{registration.rejection_remarks}}</td>\n                                        </tr>\n                                        <tr @mouseover="show_edit = true" @mouseout="show_edit = false">\n                                        \t<td>{{trans(\'academic.course\')}}</td>\n                                        \t<td>\n                                                {{registration.course.name+\' \'+getSession}}\n                                            </td>\n                                        </tr>\n                                        <tr v-if="registration.status == \'allotted\'">\n                                            <td>{{trans(\'academic.batch\')}}</td>\n                                            <td>{{registration.admission.batch.name}}\n                                            </td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'student.father_name\')}}</td>\n                                        \t<td>{{registration.student.parent ? registration.student.parent.father_name : \'\'}}</td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'student.mother_name\')}}</td>\n                                        \t<td>{{registration.student.parent ? registration.student.parent.mother_name : \'\'}}</td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'student.contact_number\')}}</td>\n                                        \t<td>{{registration.student.contact_number}}</td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'student.gender\')}}</td>\n                                        \t<td>{{trans(\'list.\'+registration.student.gender)}}</td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'student.date_of_birth\')}}</td>\n                                        \t<td>{{registration.student.date_of_birth | moment}}</td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'student.date_of_registration\')}}</td>\n                                        \t<td>{{registration.date_of_registration | moment}}</td>\n                                        </tr>\n                                        <tr v-if="registration.previous_institute_id">\n                                            <td>{{trans(\'student.previous_institute\')}}</td>\n                                            <td>{{registration.previous_institute.name}}</td>\n                                        </tr>\n                                        <tr @mouseover="show_edit = true" @mouseout="show_edit = false">\n                                        \t<td>{{trans(\'student.registration_fee\')}}</td>\n                                        \t<td>\n                                                <span v-if="registration.registration_fee">\n                                                    {{formatCurrency(registration.registration_fee)}}\n                                                    <span v-if="registration.registration_fee_status == \'paid\'">\n                                                        <span class="label label-success">{{trans(\'student.registration_fee_status_paid\')}}\n                                                            {{trans(\'general.on\')}}\n                                                            <span v-if="registration.transactions.length">\n                                                                {{transaction.date | moment}}\n                                                            </span>\n                                                        </span>\n                                                    </span>\n                                                    <span v-else class="label label-danger">{{trans(\'student.registration_fee_status_unpaid\')}}</span>\n                                                </span>\n                                                <span v-else>-</span>\n                                        \t</td>\n                                        </tr>\n                                        <tr v-if="registration.registration_remarks">\n                                        \t<td>{{trans(\'student.registration_remarks\')}}</td>\n                                        \t<td>{{registration.registration_remarks}}</td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'general.created_at\')}}</td>\n                                        \t<td>{{registration.student.created_at | momentDateTime}}</td>\n                                        </tr>\n                                        <tr>\n                                        \t<td>{{trans(\'general.updated_at\')}}</td>\n                                        \t<td>{{registration.student.updated_at | momentDateTime}}</td>\n                                        </tr>\n                                        <tr v-if="registration.is_online" v-for="custom_field in online_registration_custom_fields">\n                                            <td>{{custom_field.name}}</td>\n                                            <td>{{getCustomFieldValue(custom_field)}}</td>\n                                        </tr>\n                                        <tr v-for="custom_field in registration_custom_fields">\n                                            <td>{{custom_field.name}}</td>\n                                            <td>{{getCustomFieldValue(custom_field)}}</td>\n                                        </tr>\n                                   \t</tbody>\n                                </table>\n                            </div>\n                \t\t</div>\n                \t</div>\n                </div>\n                <div class="col-12 col-sm-6 p-0">\n                    <template v-if="registration.registration_fee">\n                        <fee-form v-if="registration.registration_fee_status == \'unpaid\' && hasPermission(\'make-registration-fee-payment\')" :registration="registration" @completed="getRegistration"></fee-form>\n                    </template>\n                    <template v-if="(!registration.registration_fee || (registration.registration_fee && registration.registration_fee_status == \'paid\')) && registration.status != \'allotted\' && hasPermission(\'change-registration-status\')">\n                        <action-form :registration="registration" @completed="getRegistration"></action-form>\n                    </template>\n                </div>\n            </div>\n        </div>\n\n        <transition name="modal" v-if="editModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'student.edit_registration\')}}\n                                <span class="float-right pointer" @click="editModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <edit-registration-form :registration="registration" @completed="getRegistration" @close="editModal = false"></edit-registration-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n\n        <transition name="modal" v-if="showReceiptModal && registration.registration_fee && registration.registration_fee_status == \'paid\' && registration.transactions.length">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'finance.receipt_detail\')}}\n                                <span class="float-right pointer" @click="showReceiptModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <div class="table-responsive">\n                                    <table class="table table-bordered">\n                                        <tbody>\n                                            <tr>\n                                                <td>{{trans(\'finance.receipt_no\')}}</td>\n                                                <td>#{{transaction.prefix+transaction.number}}</td>\n                                                <td>{{trans(\'finance.account\')}}</td>\n                                                <td>{{transaction.account.name}}</td>\n                                            </tr>\n                                            <tr>\n                                                <td>{{trans(\'finance.amount\')}}</td>\n                                                <td>{{formatCurrency(transaction.amount)}}</td>\n                                                <td>{{trans(\'finance.date\')}}</td>\n                                                <td>{{transaction.date | moment}}</td>\n                                            </tr>\n                                            <tr>\n                                                <td>{{trans(\'finance.payment_method\')}}</td>\n                                                <td>\n                                                    {{transaction.payment_method.name}}\n                                                    <span v-if="transaction.instrument_number"><br />{{trans(\'finance.instrument_number\')}}: {{transaction.instrument_number}}</span>\n                                                    <span v-if="transaction.instrument_date"><br />{{trans(\'finance.instrument_date\')}}: <span>{{transaction.instrument_date | moment}}</span></span>\n                                                    <span v-if="transaction.instrument_clearing_date"><br />{{trans(\'finance.instrument_clearing_date\')}}: <span>{{transaction.instrument_clearing_date | moment}}</span></span>\n                                                    <span v-if="transaction.instrument_bank_detail"><br />{{trans(\'finance.instrument_bank_detail\')}}: {{transaction.instrument_bank_detail}}</span>\n                                                    <span v-if="transaction.reference_number"><br />{{trans(\'finance.reference_number\')}}: {{transaction.reference_number}}</span>\n                                                </td>\n                                                <td>{{trans(\'finance.remarks\')}}</td>\n                                                <td>{{transaction.remarks}}</td>\n                                            </tr>\n                                            <tr>\n                                                <td>{{trans(\'finance.date_of_entry\')}}</td>\n                                                <td>{{transaction.created_at | momentDateTime}}</td>\n                                                <td>{{trans(\'finance.entry_by\')}}</td>\n                                                <td>{{getEmployeeName(transaction.user.employee)}}</td>\n                                            </tr>\n                                        </tbody>\n                                    </table>\n                                </div>\n                                <button type="button" class="btn btn-block btn-danger" v-if="registration.status == \'pending\'" @click="cancel_fee_payment = true">{{trans(\'student.cancel_fee_payment\')}}</button>\n                                <template v-if="cancel_fee_payment">\n                                    <form @submit.prevent="cancelPayment" class="m-t-20" @keydown="cancelPaymentForm.errors.clear($event.target.name)" v-if="registration.status == \'pending\'">\n                                        <div class="row">\n                                            <div class="col-12">\n                                                <div class="form-group">\n                                                    <autosize-textarea v-model="cancelPaymentForm.cancellation_remarks" rows="2" name="cancellation_remarks" :placeholder="trans(\'student.cancellation_remarks\')"></autosize-textarea>\n                                                    <show-error :form-name="cancelPaymentForm" prop-name="cancellation_remarks"></show-error>\n                                                </div>\n                                                <button type="submit" class="btn btn-info waves-effect waves-light">{{trans(\'general.save\')}}</button>\n                                            </div>\n                                        </div>\n                                    </form>\n                                </template>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n<script>\n    import editRegistrationForm from \'./edit\'\n    import feeForm from \'./fee-form\'\n    import actionForm from \'./action-form\'\n\n\texport default {\n        components : { feeForm,actionForm,editRegistrationForm },\n        data() {\n            return {\n                id:this.$route.params.id,\n                registration: {\n                \tstudent: {\n\n                \t},\n                \tcourse: {\n\n                \t},\n                    transaction: null\n                },\n                transaction: {},\n                show_edit: false,\n                cancel_fee_payment: false,\n                cancelPaymentForm: new Form({\n                    cancellation_remarks: \'\'\n                }),\n                registration_custom_fields: [],\n                online_registration_custom_fields: [],\n                editModal: false,\n                showReceiptModal: false\n            }\n        },\n        mounted(){\n            if(!helper.hasPermission(\'list-registration\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getRegistration();\n        },\n        methods: {\n        \tgetRegistration(){\n                let loader = this.$loading.show();\n        \t\taxios.get(\'/api/registration/\'+this.id)\n        \t\t\t.then(response => {\n        \t\t\t\tthis.registration_custom_fields = response.registration_custom_fields;\n                        this.online_registration_custom_fields = response.online_registration_custom_fields;\n                        this.registration = response.registration;\n                        this.transaction = (response.registration.transactions.length) ? response.registration.transactions[0] : null;\n                        loader.hide();\n        \t\t\t})\n        \t\t\t.catch(error => {\n                        loader.hide();\n        \t\t\t\thelper.showErrorMsg(error);\n        \t\t\t\tthis.$router.push(\'/dashboard\');\n        \t\t\t})\n        \t},\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getStudentName(student){\n                return helper.getStudentName(student);\n            },\n            formatCurrency(amount){\n            \treturn helper.formatCurrency(amount);\n            },\n            getRegistrationStatus(registration){\n            \treturn helper.getRegistrationStatus(registration);\n            },\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            getEmployeeName(employee){\n                return helper.getEmployeeName(employee);\n            },\n            getCustomFieldValue(custom_field) {\n                return helper.getCustomFieldValue(this.registration.options.custom_values, custom_field.id);\n            },\n            cancelPayment(){\n                let loader = this.$loading.show();\n                this.cancelPaymentForm.post(\'/api/registration/\'+this.id+\'/transaction/\'+this.transaction.id+\'/cancel\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.getRegistration();\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    })\n            },\n            confirmDelete(registration){\n                return dialog => this.deleteRegistration(registration);\n            },\n            deleteRegistration(registration){\n                let loader = this.$loading.show();\n                axios.delete(\'/api/registration/\'+registration.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/student/registration\');\n                    }).catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            printReceipt(){\n                let loader = this.$loading.show();\n                axios.post(\'/api/registration/\'+this.id+\'/fee/\'+this.transaction.id+\'/print\')\n                    .then(response => {\n                        let print = window.open("/print");\n                        loader.hide();\n                        print.document.write(response);\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            }\n        },\n        computed:{\n        \tgetSession(){\n        \t\treturn helper.getDefaultAcademicSession().name;\n        \t}\n        },\n        filters: {\n          moment(date) {\n            return helper.formatDate(date);\n          },\n          momentDateTime(date) {\n            return helper.formatDateTime(date);\n          }\n        }\n\t}\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>'],sourceRoot:""}]);const o=i},47817:(t,e,n)=>{"use strict";n.r(e),n.d(e,{default:()=>p});const s={props:["registration"],components:{},data:function(){return{registrationForm:new Form({course_id:"",date_of_registration:"",registration_remarks:"",previous_institute_id:"",registration_fee:0,custom_values:[]}),courses:[],course_details:[],previous_institutes:[],selected_course:null,selected_previous_institute:null,default_currency:helper.getConfig("default_currency"),registration_fee:0,enable_registration_fee:0,custom_fields:[],custom_values:[],clearCustomField:!1,customFieldFormErrors:{}}},mounted:function(){this.getPreRequisite(),this.registrationForm.course_id=this.registration.course_id,this.registrationForm.previous_institute_id=this.registration.previous_institute_id,this.selected_course={id:this.registration.course_id,name:this.registration.course.name},this.selected_previous_institute=this.registration.previous_institute_id?{id:this.registration.previous_institute_id,name:this.registration.previous_institute.name}:null,this.registrationForm.date_of_registration=this.registration.date_of_registration,this.registrationForm.registration_remarks=this.registration.registration_remarks,this.registrationForm.registration_fee=this.registration.registration_fee,this.custom_values=this.registration.options&&this.registration.options.hasOwnProperty("custom_values")?this.registration.options.custom_values:[]},methods:{getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/registration/pre-requisite").then((function(n){t.courses=n.courses,t.course_details=n.course_details,t.previous_institutes=n.previous_institutes,t.custom_fields=n.custom_fields,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},updateCustomValues:function(t){this.registrationForm.custom_values=t},submit:function(){var t=this,e=this.$loading.show();this.registrationForm.patch("/api/registration/"+this.registration.id).then((function(n){toastr.success(n.message),t.$emit("completed"),t.$emit("close"),e.hide()})).catch((function(n){e.hide(),t.customFieldFormErrors=n,helper.showErrorMsg(n)}))},onCourseSelect:function(t){this.registrationForm.course_id=t.id,this.setRegistration(t.id),this.registrationForm.registration_fee=this.registration_fee},onPreviousInstituteSelect:function(t){this.registrationForm.previous_institute_id=t.id},setRegistration:function(t){var e=this.course_details.find((function(e){return e.course_id==t}));this.enable_registration_fee="undefined"!=e?e.enable_registration_fee:0,this.registration_fee=this.enable_registration_fee?e.registration_fee:0},formatCurrency:function(t){return helper.formatCurrency(t)}}};var r=n(51900);const a=(0,r.Z)(s,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("form",{on:{submit:function(e){return e.preventDefault(),t.submit.apply(null,arguments)},keydown:function(e){return t.registrationForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("academic.course")))]),t._v(" "),n("v-select",{attrs:{label:"name","group-values":"courses","group-label":"course_group","group-select":!1,name:"course_id",id:"course_id",options:t.courses,placeholder:t.trans("academic.select_course")},on:{select:t.onCourseSelect,close:function(e){return t.registrationForm.errors.clear("course_id")},remove:function(e){t.registrationForm.course_id=""}},model:{value:t.selected_course,callback:function(e){t.selected_course=e},expression:"selected_course"}},[t.courses.length?t._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                        "+t._s(t.trans("general.no_option_found"))+"\n                    ")])]),t._v(" "),t.enable_registration_fee&&t.registration_fee>=0?n("span",{staticClass:"help-block"},[t._v(t._s(t.trans("student.registration_fee"))+" "+t._s(t.formatCurrency(t.registration_fee)))]):t._e(),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationForm,"prop-name":"course_id"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.date_of_registration")))]),t._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("student.date_of_registration")},on:{selected:function(e){return t.registrationForm.errors.clear("date_of_registration")}},model:{value:t.registrationForm.date_of_registration,callback:function(e){t.$set(t.registrationForm,"date_of_registration",e)},expression:"registrationForm.date_of_registration"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationForm,"prop-name":"date_of_registration"}})],1)]),t._v(" "),"unpaid"==t.registration.registration_fee_status||null==t.registration.registration_fee_status?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.registration_fee")))]),t._v(" "),n("currency-input",{attrs:{position:t.default_currency.position,symbol:t.default_currency.symbol,name:"registration_fee",placeholder:t.trans("stduent.registration_fee")},nativeOn:{input:function(e){return t.registrationForm.errors.clear("registration_fee")}},model:{value:t.registrationForm.registration_fee,callback:function(e){t.$set(t.registrationForm,"registration_fee",e)},expression:"registrationForm.registration_fee"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationForm,"prop-name":"registration_fee"}})],1)]):t._e(),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.previous_institute")))]),t._v(" "),n("v-select",{attrs:{label:"name",name:"previous_institute_id",id:"previous_institute_id",options:t.previous_institutes,placeholder:t.trans("academic.select_institute")},on:{select:t.onPreviousInstituteSelect,close:function(e){return t.registrationForm.errors.clear("previous_institute_id")},remove:function(e){t.registrationForm.previous_institute_id=""}},model:{value:t.selected_previous_institute,callback:function(e){t.selected_previous_institute=e},expression:"selected_previous_institute"}},[t.previous_institutes.length?t._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                        "+t._s(t.trans("general.no_option_found"))+"\n                    ")])]),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationForm,"prop-name":"previous_institute_id"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-12"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.registration_remarks")))]),t._v(" "),n("autosize-textarea",{attrs:{rows:"2",name:"registration_remarks",placeholder:t.trans("student.registration_remarks")},model:{value:t.registrationForm.registration_remarks,callback:function(e){t.$set(t.registrationForm,"registration_remarks",e)},expression:"registrationForm.registration_remarks"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationForm,"prop-name":"registration_remarks"}})],1)])]),t._v(" "),n("custom-field",{attrs:{fields:t.custom_fields,customValues:t.custom_values,clear:t.clearCustomField,formErrors:t.customFieldFormErrors},on:{updateCustomValues:t.updateCustomValues}}),t._v(" "),n("div",{staticClass:"card-footer text-right"},[n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t._v(t._s(t.trans("general.save")))])])],1)}),[],!1,null,null,null).exports;const i={components:{},props:["registration"],data:function(){return{registrationFeeForm:new Form({account_id:"",payment_method_id:"",date:"",instrument_date:"",instrument_number:"",instrument_clearing_date:"",instrument_bank_detail:"",reference_number:"",remarks:""}),selected_account:null,accounts:[],payment_methods:[],selected_payment_method:null,payment_method_details:[],payment_method_detail:{}}},mounted:function(){this.getPreRequisite()},methods:{getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/registration/fee/pre-requisite").then((function(n){t.accounts=n.accounts,t.payment_methods=n.payment_methods,t.payment_method_details=n.payment_method_details,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getPaymentMethodDetail:function(t){return helper.getPaymentMethodDetail(this.payment_method_detail,t)},onAccountSelect:function(t){this.registrationFeeForm.account_id=t.id},onPaymentMethodSelect:function(t){this.registrationFeeForm.payment_method_id=t.id,this.payment_method_detail=this.payment_method_details.find((function(e){return e.id==t.id}))},onPaymentMethodRemove:function(t){this.registrationFeeForm.payment_method_id="",this.payment_method_detail=null},formatCurrency:function(t){return helper.formatCurrency(t)},submit:function(){var t=this,e=this.$loading.show();this.registrationFeeForm.post("/api/registration/"+this.registration.id+"/fee/payment").then((function(n){toastr.success(n.message),t.selected_account=null,t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}}};const o={components:{},props:["registration"],data:function(){return{actionForm:new Form({status:"",batch_id:null,admission_number_prefix:"",admission_number:"",date_of_admission:"",rejection_remarks:"",admission_remarks:"",transport_circle_id:null,fee_concession_id:null}),admission_numbers:[],batch_current_strength:0,options:[{value:"pending",text:i18n.student.registration_status_pending},{value:"rejected",text:i18n.student.registration_status_rejected},{value:"allotted",text:i18n.student.registration_status_allotted}],transport_circles:[],fee_concessions:[],batches:[]}},mounted:function(){this.actionForm.status=this.registration.status,this.actionForm.date_of_admission=moment().format(),this.getPreRequisite()},methods:{getPreRequisite:function(){var t=this,e=this.$loading.show();axios.get("/api/registration/status/pre-requisite").then((function(n){t.transport_circles=n.transport_circles,t.fee_concessions=n.fee_concessions,t.admission_numbers=n.admission_numbers,t.actionForm.admission_number_prefix=helper.getConfig("admission_number_prefix"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},submit:function(){var t=this,e=this.$loading.show();this.actionForm.post("/api/registration/"+this.registration.id+"/update/status").then((function(n){toastr.success(n.message),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},fetchStrength:function(){var t=this,e=this.$loading.show();if(!this.actionForm.batch_id)return this.batch_current_strength=0,void e.hide();this.actionForm.errors.clear("batch_id"),axios.post("/api/batch/"+this.actionForm.batch_id+"/strength").then((function(n){t.batch_current_strength=n,e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}},watch:{registration:function(t){this.actionForm.status=t.status},"actionForm.admission_number_prefix":function(t){var e=this.admission_numbers.find((function(e){return e.prefix==t}));this.actionForm.admission_number=void 0===e?helper.formatWithPadding(1,helper.getConfig("admission_number_digit")):helper.formatWithPadding(e.number+1,helper.getConfig("admission_number_digit"))}}};var c;function l(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}const d={components:{feeForm:(0,r.Z)(i,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",{staticClass:"card card-form"},[n("div",{staticClass:"card-body"},[n("h4",{staticClass:"card-title"},[t._v(t._s(t.trans("student.pay_registration_fee"))+" "+t._s(t.formatCurrency(t.registration.registration_fee)))]),t._v(" "),n("form",{on:{submit:function(e){return e.preventDefault(),t.submit.apply(null,arguments)},keydown:function(e){return t.registrationFeeForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.account")))]),t._v(" "),n("v-select",{attrs:{label:"name",name:"account_id",id:"account_id",options:t.accounts,placeholder:t.trans("account.select_account")},on:{select:t.onAccountSelect,close:function(e){return t.registrationFeeForm.errors.clear("account_id")},remove:function(e){t.registrationFeeForm.account_id=""}},model:{value:t.selected_account,callback:function(e){t.selected_account=e},expression:"selected_account"}},[t.accounts.length?t._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                                    "+t._s(t.trans("general.no_option_found"))+"\n                                ")])]),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"account_id"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.date_of_payment")))]),t._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("student.date_of_payment")},on:{selected:function(e){return t.registrationFeeForm.errors.clear("date")}},model:{value:t.registrationFeeForm.date,callback:function(e){t.$set(t.registrationFeeForm,"date",e)},expression:"registrationFeeForm.date"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"date"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.payment_method")))]),t._v(" "),n("v-select",{attrs:{label:"name",name:"payment_method_id",id:"payment_method_id",options:t.payment_methods,placeholder:t.trans("payment_method.select_payment_method")},on:{select:t.onPaymentMethodSelect,close:function(e){return t.registrationFeeForm.errors.clear("payment_method_id")},remove:t.onPaymentMethodRemove},model:{value:t.selected_payment_method,callback:function(e){t.selected_payment_method=e},expression:"selected_payment_method"}},[t.payment_methods.length?t._e():n("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                                    "+t._s(t.trans("general.no_option_found"))+"\n                                ")])]),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"payment_method_id"}})],1)]),t._v(" "),t.getPaymentMethodDetail("instrument_number")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.instrument_number")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.registrationFeeForm.instrument_number,expression:"registrationFeeForm.instrument_number"}],staticClass:"form-control",attrs:{type:"text",name:"instrument_number",placeholder:t.trans("finance.instrument_number")},domProps:{value:t.registrationFeeForm.instrument_number},on:{input:function(e){e.target.composing||t.$set(t.registrationFeeForm,"instrument_number",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"instrument_number"}})],1)]):t._e(),t._v(" "),t.getPaymentMethodDetail("instrument_date")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.instrument_date")))]),t._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("finance.instrument_date")},on:{selected:function(e){return t.registrationFeeForm.errors.clear("instrument_date")}},model:{value:t.registrationFeeForm.instrument_date,callback:function(e){t.$set(t.registrationFeeForm,"instrument_date",e)},expression:"registrationFeeForm.instrument_date"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"instrument_date"}})],1)]):t._e(),t._v(" "),t.getPaymentMethodDetail("instrument_bank_detail")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.instrument_bank_detail")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.registrationFeeForm.instrument_bank_detail,expression:"registrationFeeForm.instrument_bank_detail"}],staticClass:"form-control",attrs:{type:"text",name:"instrument_bank_detail",placeholder:t.trans("finance.instrument_bank_detail")},domProps:{value:t.registrationFeeForm.instrument_bank_detail},on:{input:function(e){e.target.composing||t.$set(t.registrationFeeForm,"instrument_bank_detail",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"instrument_bank_detail"}})],1)]):t._e(),t._v(" "),t.getPaymentMethodDetail("instrument_clearing_date")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.instrument_clearing_date")))]),t._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("finance.instrument_clearing_date")},on:{selected:function(e){return t.registrationFeeForm.errors.clear("instrument_clearing_date")}},model:{value:t.registrationFeeForm.instrument_clearing_date,callback:function(e){t.$set(t.registrationFeeForm,"instrument_clearing_date",e)},expression:"registrationFeeForm.instrument_clearing_date"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"instrument_clearing_date"}})],1)]):t._e(),t._v(" "),t.getPaymentMethodDetail("reference_number")?n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.reference_number")))]),t._v(" "),n("input",{directives:[{name:"model",rawName:"v-model",value:t.registrationFeeForm.reference_number,expression:"registrationFeeForm.reference_number"}],staticClass:"form-control",attrs:{type:"text",name:"reference_number",placeholder:t.trans("finance.reference_number")},domProps:{value:t.registrationFeeForm.reference_number},on:{input:function(e){e.target.composing||t.$set(t.registrationFeeForm,"reference_number",e.target.value)}}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"reference_number"}})],1)]):t._e(),t._v(" "),n("div",{staticClass:"col-12 col-sm-12"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.registration_fee_remarks")))]),t._v(" "),n("autosize-textarea",{attrs:{rows:"2",name:"remarks",placeholder:t.trans("student.registration_fee_remarks")},model:{value:t.registrationFeeForm.remarks,callback:function(e){t.$set(t.registrationFeeForm,"remarks",e)},expression:"registrationFeeForm.remarks"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.registrationFeeForm,"prop-name":"remarks"}})],1)])]),t._v(" "),n("div",{staticClass:"card-footer text-right"},[n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t._v(t._s(t.trans("general.save")))])])])])])}),[],!1,null,null,null).exports,actionForm:(0,r.Z)(o,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",{staticClass:"card card-form"},[n("div",{staticClass:"card-body"},[n("h4",{staticClass:"card-title"},[t._v(t._s(t.trans("student.registration_action")))]),t._v(" "),n("form",{on:{submit:function(e){return e.preventDefault(),t.submit.apply(null,arguments)},keydown:function(e){return t.actionForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.registration_status")))]),t._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:t.actionForm.status,expression:"actionForm.status"}],staticClass:"custom-select col-12",attrs:{placeholder:"Select Mari",name:"status"},on:{change:[function(e){var n=Array.prototype.filter.call(e.target.options,(function(t){return t.selected})).map((function(t){return"_value"in t?t._value:t.value}));t.$set(t.actionForm,"status",e.target.multiple?n:n[0])},function(e){return t.actionForm.errors.clear("status")}]}},t._l(t.options,(function(e){return n("option",{domProps:{value:e.value}},[t._v("\n                                "+t._s(e.text)+"\n                              ")])})),0),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"status"}})],1)])]),t._v(" "),"rejected"==t.actionForm.status?[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-12"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.rejection_remarks")))]),t._v(" "),n("autosize-textarea",{attrs:{rows:"2",name:"rejection_remarks",placeholder:t.trans("student.rejection_remarks")},model:{value:t.actionForm.rejection_remarks,callback:function(e){t.$set(t.actionForm,"rejection_remarks",e)},expression:"actionForm.rejection_remarks"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"rejection_remarks"}})],1)])]),t._v(" "),n("div",{staticClass:"card-footer text-right"},[n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t._v(t._s(t.trans("general.save")))])])]:t._e(),t._v(" "),"allotted"==t.actionForm.status?[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.admission_number")))]),t._v(" "),n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-4"},[n("input",{directives:[{name:"model",rawName:"v-model",value:t.actionForm.admission_number_prefix,expression:"actionForm.admission_number_prefix"}],staticClass:"form-control",attrs:{type:"text",name:"admission_number_prefix",placeholder:t.trans("student.admission_number_prefix")},domProps:{value:t.actionForm.admission_number_prefix},on:{input:function(e){e.target.composing||t.$set(t.actionForm,"admission_number_prefix",e.target.value)}}})]),t._v(" "),n("div",{staticClass:"col-12 col-sm-8"},[n("input",{directives:[{name:"model",rawName:"v-model",value:t.actionForm.admission_number,expression:"actionForm.admission_number"}],staticClass:"form-control",attrs:{type:"text",name:"admission_number",placeholder:t.trans("student.admission_number")},domProps:{value:t.actionForm.admission_number},on:{input:function(e){e.target.composing||t.$set(t.actionForm,"admission_number",e.target.value)}}})])]),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"admission_number"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:t.actionForm.batch_id,expression:"actionForm.batch_id"}],staticClass:"custom-select col-12",on:{change:[function(e){var n=Array.prototype.filter.call(e.target.options,(function(t){return t.selected})).map((function(t){return"_value"in t?t._value:t.value}));t.$set(t.actionForm,"batch_id",e.target.multiple?n:n[0])},t.fetchStrength]}},[n("option",{attrs:{value:"null",selected:""}},[t._v(t._s(t.trans("academic.select_batch")))]),t._v(" "),t._l(t.registration.course.batches,(function(e){return n("option",{domProps:{value:e.id}},[t._v("\n\t\t\t\t\t\t\t\t\t\t"+t._s(t.registration.course.name+" "+e.name)+"\n\t\t\t\t\t\t\t\t\t")])}))],2),t._v(" "),t.actionForm.batch_id&&t.batch_current_strength>=0?n("div",{staticClass:"help-block"},[t._v(t._s(t.trans("academic.current_strength")+": "+t.batch_current_strength))]):t._e(),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"batch_id"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.circle")))]),t._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:t.actionForm.transport_circle_id,expression:"actionForm.transport_circle_id"}],staticClass:"custom-select col-12",attrs:{name:"transport_circle_id"},on:{change:[function(e){var n=Array.prototype.filter.call(e.target.options,(function(t){return t.selected})).map((function(t){return"_value"in t?t._value:t.value}));t.$set(t.actionForm,"transport_circle_id",e.target.multiple?n:n[0])},function(e){return t.actionForm.errors.clear("transport_circle_id")}]}},[n("option",{attrs:{value:"null",selected:""}},[t._v(t._s(t.trans("transport.no_transport_circle")))]),t._v(" "),t._l(t.transport_circles,(function(e){return n("option",{domProps:{value:e.id}},[t._v("\n\t\t\t\t\t\t\t\t\t\t"+t._s(e.name)+"\n\t\t\t\t\t\t\t\t\t")])}))],2),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"transport_circle_id"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("finance.fee_concession")))]),t._v(" "),n("select",{directives:[{name:"model",rawName:"v-model",value:t.actionForm.fee_concession_id,expression:"actionForm.fee_concession_id"}],staticClass:"custom-select col-12",attrs:{name:"fee_concession_id"},on:{change:[function(e){var n=Array.prototype.filter.call(e.target.options,(function(t){return t.selected})).map((function(t){return"_value"in t?t._value:t.value}));t.$set(t.actionForm,"fee_concession_id",e.target.multiple?n:n[0])},function(e){return t.actionForm.errors.clear("fee_concession_id")}]}},[n("option",{attrs:{value:"null",selected:""}},[t._v(t._s(t.trans("finance.no_fee_concession")))]),t._v(" "),t._l(t.fee_concessions,(function(e){return n("option",{domProps:{value:e.id}},[t._v("\n\t\t\t\t\t\t\t\t\t\t"+t._s(e.name)+"\n\t\t\t\t\t\t\t\t\t")])}))],2),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"fee_concession_id"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.date_of_admission")))]),t._v(" "),n("datepicker",{attrs:{bootstrapStyling:!0,placeholder:t.trans("student.date_of_admission")},on:{selected:function(e){return t.actionForm.errors.clear("date_of_admission")}},model:{value:t.actionForm.date_of_admission,callback:function(e){t.$set(t.actionForm,"date_of_admission",e)},expression:"actionForm.date_of_admission"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"date_of_admission"}})],1)]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"form-group"},[n("label",{attrs:{for:""}},[t._v(t._s(t.trans("student.admission_remarks")))]),t._v(" "),n("autosize-textarea",{attrs:{rows:"1",name:"admission_remarks",placeholder:t.trans("student.admission_remarks")},model:{value:t.actionForm.admission_remarks,callback:function(e){t.$set(t.actionForm,"admission_remarks",e)},expression:"actionForm.admission_remarks"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.actionForm,"prop-name":"admission_remarks"}})],1)])]),t._v(" "),n("div",{staticClass:"card-footer text-right"},[n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t._v(t._s(t.trans("general.save")))])])]:t._e()],2)])])}),[],!1,null,null,null).exports,editRegistrationForm:a},data:function(){return{id:this.$route.params.id,registration:{student:{},course:{},transaction:null},transaction:{},show_edit:!1,cancel_fee_payment:!1,cancelPaymentForm:new Form({cancellation_remarks:""}),registration_custom_fields:[],online_registration_custom_fields:[],editModal:!1,showReceiptModal:!1}},mounted:function(){helper.hasPermission("list-registration")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getRegistration()},methods:(c={getRegistration:function(){var t=this,e=this.$loading.show();axios.get("/api/registration/"+this.id).then((function(n){t.registration_custom_fields=n.registration_custom_fields,t.online_registration_custom_fields=n.online_registration_custom_fields,t.registration=n.registration,t.transaction=n.registration.transactions.length?n.registration.transactions[0]:null,e.hide()})).catch((function(n){e.hide(),helper.showErrorMsg(n),t.$router.push("/dashboard")}))},hasPermission:function(t){return helper.hasPermission(t)},getStudentName:function(t){return helper.getStudentName(t)},formatCurrency:function(t){return helper.formatCurrency(t)},getRegistrationStatus:function(t){return helper.getRegistrationStatus(t)}},l(c,"hasPermission",(function(t){return helper.hasPermission(t)})),l(c,"getEmployeeName",(function(t){return helper.getEmployeeName(t)})),l(c,"getCustomFieldValue",(function(t){return helper.getCustomFieldValue(this.registration.options.custom_values,t.id)})),l(c,"cancelPayment",(function(){var t=this,e=this.$loading.show();this.cancelPaymentForm.post("/api/registration/"+this.id+"/transaction/"+this.transaction.id+"/cancel").then((function(n){toastr.success(n.message),t.getRegistration(),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))})),l(c,"confirmDelete",(function(t){var e=this;return function(n){return e.deleteRegistration(t)}})),l(c,"deleteRegistration",(function(t){var e=this,n=this.$loading.show();axios.delete("/api/registration/"+t.id).then((function(t){toastr.success(t.message),n.hide(),e.$router.push("/student/registration")})).catch((function(t){n.hide(),helper.showErrorMsg(t)}))})),l(c,"printReceipt",(function(){var t=this.$loading.show();axios.post("/api/registration/"+this.id+"/fee/"+this.transaction.id+"/print").then((function(e){var n=window.open("/print");t.hide(),n.document.write(e)})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))})),c),computed:{getSession:function(){return helper.getDefaultAcademicSession().name}},filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}}};var m=n(93379),_=n.n(m),u=n(24056),g={insert:"head",singleton:!1};_()(u.Z,g);u.Z.locals;const p=(0,r.Z)(d,(function(){var t=this,e=t.$createElement,n=t._self._c||e;return n("div",[n("div",{staticClass:"page-titles"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("h3",{staticClass:"text-themecolor"},[t._v(t._s(t.trans("student.registration"))+"\n                    "),t.registration.student?n("span",{staticClass:"card-subtitle d-none d-sm-inline"},[t._v("("+t._s(t.getStudentName(t.registration.student)+" - "+t.trans("student.registration_no")+": "+t.registration.id)+") ")]):t._e()])]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"action-buttons pull-right"},[n("router-link",{staticClass:"btn btn-info btn-sm",attrs:{to:"/student/registration/card-view"}},[n("i",{staticClass:"fas fa-list"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("student.registration")))])]),t._v(" "),n("router-link",{staticClass:"btn btn-info btn-sm",attrs:{to:"/student/"+t.registration.student.uuid}},[n("i",{staticClass:"fas fa-user"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("student.student_detail")))])])],1)])])]),t._v(" "),n("div",{staticClass:"container-fluid"},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12 col-sm-6"},[n("div",{staticClass:"card border-right"},[n("div",{staticClass:"card-body"},[n("h4",{staticClass:"card-title m-3"},[n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("student.registration_detail")))]),t._v(" "),t.registration.registration_fee&&"paid"==t.registration.registration_fee_status&&t.registration.transactions.length?n("div",{staticClass:"dropdown pull-right"},[n("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-xs",attrs:{type:"button",href:"#",role:"button",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[n("i",{staticClass:"fas fa-ellipsis-h"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("finance.receipt")))])]),t._v(" "),n("div",{staticClass:"dropdown-menu"},[n("button",{staticClass:"dropdown-item custom-dropdown-menu",on:{click:function(e){t.showReceiptModal=!0}}},[n("i",{staticClass:"fas fa-arrow-circle-right"}),t._v(" "+t._s(t.trans("finance.receipt_detail")))]),t._v(" "),n("button",{staticClass:"dropdown-item custom-dropdown-menu",on:{click:t.printReceipt}},[n("i",{staticClass:"fas fa-print"}),t._v(" "+t._s(t.trans("finance.print_receipt")))])])]):t._e(),t._v(" "),"pending"==t.registration.status?n("button",{staticClass:"btn btn-info btn-xs pull-right ",attrs:{type:"button"},on:{click:function(e){t.editModal=!0}}},[n("i",{staticClass:"fas fa-edit"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("general.edit")))])]):t._e(),t._v(" "),"pending"==t.registration.status&&t.hasPermission("delete-registration")?n("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:t.confirmDelete(t.registration)},expression:"{ok: confirmDelete(registration)}"},{name:"tooltip",rawName:"v-tooltip",value:t.trans("student.delete_registartion"),expression:"trans('student.delete_registartion')"}],key:t.registration.id,staticClass:"btn btn-danger btn-xs pull-right ",attrs:{type:"button"}},[n("i",{staticClass:"fas fa-trash"}),t._v(" "),n("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("general.delete")))])]):t._e()]),t._v(" "),n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-sm custom-show-table"},[n("tbody",[n("tr",[n("td",[t._v(t._s(t.trans("student.name")))]),t._v(" "),n("td",[t._v("\n                                            "+t._s(t.getStudentName(t.registration.student))+"\n                                            "),t.registration.is_online?n("span",[n("span",{staticClass:"label label-info"},[t._v(t._s(t.trans("student.online_registration")))])]):t._e()])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.registration_status")))]),t._v(" "),n("td",t._l(t.getRegistrationStatus(t.registration),(function(e){return n("span",{class:["label","label-"+e.color,"m-r-5"]},[t._v(t._s(e.label))])})),0)]),t._v(" "),t.registration.rejection_remarks&&"rejected"==t.registration.status?n("tr",[n("td",[t._v(t._s(t.trans("student.rejection_remarks")))]),t._v(" "),n("td",{staticClass:"text-danger"},[t._v(t._s(t.registration.rejection_remarks))])]):t._e(),t._v(" "),n("tr",{on:{mouseover:function(e){t.show_edit=!0},mouseout:function(e){t.show_edit=!1}}},[n("td",[t._v(t._s(t.trans("academic.course")))]),t._v(" "),n("td",[t._v("\n                                            "+t._s(t.registration.course.name+" "+t.getSession)+"\n                                        ")])]),t._v(" "),"allotted"==t.registration.status?n("tr",[n("td",[t._v(t._s(t.trans("academic.batch")))]),t._v(" "),n("td",[t._v(t._s(t.registration.admission.batch.name)+"\n                                        ")])]):t._e(),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.father_name")))]),t._v(" "),n("td",[t._v(t._s(t.registration.student.parent?t.registration.student.parent.father_name:""))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.mother_name")))]),t._v(" "),n("td",[t._v(t._s(t.registration.student.parent?t.registration.student.parent.mother_name:""))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.contact_number")))]),t._v(" "),n("td",[t._v(t._s(t.registration.student.contact_number))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.gender")))]),t._v(" "),n("td",[t._v(t._s(t.trans("list."+t.registration.student.gender)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.date_of_birth")))]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(t.registration.student.date_of_birth)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("student.date_of_registration")))]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(t.registration.date_of_registration)))])]),t._v(" "),t.registration.previous_institute_id?n("tr",[n("td",[t._v(t._s(t.trans("student.previous_institute")))]),t._v(" "),n("td",[t._v(t._s(t.registration.previous_institute.name))])]):t._e(),t._v(" "),n("tr",{on:{mouseover:function(e){t.show_edit=!0},mouseout:function(e){t.show_edit=!1}}},[n("td",[t._v(t._s(t.trans("student.registration_fee")))]),t._v(" "),n("td",[t.registration.registration_fee?n("span",[t._v("\n                                                "+t._s(t.formatCurrency(t.registration.registration_fee))+"\n                                                "),"paid"==t.registration.registration_fee_status?n("span",[n("span",{staticClass:"label label-success"},[t._v(t._s(t.trans("student.registration_fee_status_paid"))+"\n                                                        "+t._s(t.trans("general.on"))+"\n                                                        "),t.registration.transactions.length?n("span",[t._v("\n                                                            "+t._s(t._f("moment")(t.transaction.date))+"\n                                                        ")]):t._e()])]):n("span",{staticClass:"label label-danger"},[t._v(t._s(t.trans("student.registration_fee_status_unpaid")))])]):n("span",[t._v("-")])])]),t._v(" "),t.registration.registration_remarks?n("tr",[n("td",[t._v(t._s(t.trans("student.registration_remarks")))]),t._v(" "),n("td",[t._v(t._s(t.registration.registration_remarks))])]):t._e(),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("general.created_at")))]),t._v(" "),n("td",[t._v(t._s(t._f("momentDateTime")(t.registration.student.created_at)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("general.updated_at")))]),t._v(" "),n("td",[t._v(t._s(t._f("momentDateTime")(t.registration.student.updated_at)))])]),t._v(" "),t._l(t.online_registration_custom_fields,(function(e){return t.registration.is_online?n("tr",[n("td",[t._v(t._s(e.name))]),t._v(" "),n("td",[t._v(t._s(t.getCustomFieldValue(e)))])]):t._e()})),t._v(" "),t._l(t.registration_custom_fields,(function(e){return n("tr",[n("td",[t._v(t._s(e.name))]),t._v(" "),n("td",[t._v(t._s(t.getCustomFieldValue(e)))])])}))],2)])])])])]),t._v(" "),n("div",{staticClass:"col-12 col-sm-6 p-0"},[t.registration.registration_fee?["unpaid"==t.registration.registration_fee_status&&t.hasPermission("make-registration-fee-payment")?n("fee-form",{attrs:{registration:t.registration},on:{completed:t.getRegistration}}):t._e()]:t._e(),t._v(" "),(!t.registration.registration_fee||t.registration.registration_fee&&"paid"==t.registration.registration_fee_status)&&"allotted"!=t.registration.status&&t.hasPermission("change-registration-status")?[n("action-form",{attrs:{registration:t.registration},on:{completed:t.getRegistration}})]:t._e()],2)])]),t._v(" "),t.editModal?n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                            "+t._s(t.trans("student.edit_registration"))+"\n                            "),n("span",{staticClass:"float-right pointer",on:{click:function(e){t.editModal=!1}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("edit-registration-form",{attrs:{registration:t.registration},on:{completed:t.getRegistration,close:function(e){t.editModal=!1}}}),t._v(" "),n("div",{staticClass:"clearfix"})]}))],2)])])])]):t._e(),t._v(" "),t.showReceiptModal&&t.registration.registration_fee&&"paid"==t.registration.registration_fee_status&&t.registration.transactions.length?n("transition",{attrs:{name:"modal"}},[n("div",{staticClass:"modal-mask"},[n("div",{staticClass:"modal-wrapper"},[n("div",{staticClass:"modal-container modal-lg"},[n("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                            "+t._s(t.trans("finance.receipt_detail"))+"\n                            "),n("span",{staticClass:"float-right pointer",on:{click:function(e){t.showReceiptModal=!1}}},[t._v("x")])]}))],2),t._v(" "),n("div",{staticClass:"modal-body"},[t._t("body",(function(){return[n("div",{staticClass:"table-responsive"},[n("table",{staticClass:"table table-bordered"},[n("tbody",[n("tr",[n("td",[t._v(t._s(t.trans("finance.receipt_no")))]),t._v(" "),n("td",[t._v("#"+t._s(t.transaction.prefix+t.transaction.number))]),t._v(" "),n("td",[t._v(t._s(t.trans("finance.account")))]),t._v(" "),n("td",[t._v(t._s(t.transaction.account.name))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("finance.amount")))]),t._v(" "),n("td",[t._v(t._s(t.formatCurrency(t.transaction.amount)))]),t._v(" "),n("td",[t._v(t._s(t.trans("finance.date")))]),t._v(" "),n("td",[t._v(t._s(t._f("moment")(t.transaction.date)))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("finance.payment_method")))]),t._v(" "),n("td",[t._v("\n                                                "+t._s(t.transaction.payment_method.name)+"\n                                                "),t.transaction.instrument_number?n("span",[n("br"),t._v(t._s(t.trans("finance.instrument_number"))+": "+t._s(t.transaction.instrument_number))]):t._e(),t._v(" "),t.transaction.instrument_date?n("span",[n("br"),t._v(t._s(t.trans("finance.instrument_date"))+": "),n("span",[t._v(t._s(t._f("moment")(t.transaction.instrument_date)))])]):t._e(),t._v(" "),t.transaction.instrument_clearing_date?n("span",[n("br"),t._v(t._s(t.trans("finance.instrument_clearing_date"))+": "),n("span",[t._v(t._s(t._f("moment")(t.transaction.instrument_clearing_date)))])]):t._e(),t._v(" "),t.transaction.instrument_bank_detail?n("span",[n("br"),t._v(t._s(t.trans("finance.instrument_bank_detail"))+": "+t._s(t.transaction.instrument_bank_detail))]):t._e(),t._v(" "),t.transaction.reference_number?n("span",[n("br"),t._v(t._s(t.trans("finance.reference_number"))+": "+t._s(t.transaction.reference_number))]):t._e()]),t._v(" "),n("td",[t._v(t._s(t.trans("finance.remarks")))]),t._v(" "),n("td",[t._v(t._s(t.transaction.remarks))])]),t._v(" "),n("tr",[n("td",[t._v(t._s(t.trans("finance.date_of_entry")))]),t._v(" "),n("td",[t._v(t._s(t._f("momentDateTime")(t.transaction.created_at)))]),t._v(" "),n("td",[t._v(t._s(t.trans("finance.entry_by")))]),t._v(" "),n("td",[t._v(t._s(t.getEmployeeName(t.transaction.user.employee)))])])])])]),t._v(" "),"pending"==t.registration.status?n("button",{staticClass:"btn btn-block btn-danger",attrs:{type:"button"},on:{click:function(e){t.cancel_fee_payment=!0}}},[t._v(t._s(t.trans("student.cancel_fee_payment")))]):t._e(),t._v(" "),t.cancel_fee_payment?["pending"==t.registration.status?n("form",{staticClass:"m-t-20",on:{submit:function(e){return e.preventDefault(),t.cancelPayment.apply(null,arguments)},keydown:function(e){return t.cancelPaymentForm.errors.clear(e.target.name)}}},[n("div",{staticClass:"row"},[n("div",{staticClass:"col-12"},[n("div",{staticClass:"form-group"},[n("autosize-textarea",{attrs:{rows:"2",name:"cancellation_remarks",placeholder:t.trans("student.cancellation_remarks")},model:{value:t.cancelPaymentForm.cancellation_remarks,callback:function(e){t.$set(t.cancelPaymentForm,"cancellation_remarks",e)},expression:"cancelPaymentForm.cancellation_remarks"}}),t._v(" "),n("show-error",{attrs:{"form-name":t.cancelPaymentForm,"prop-name":"cancellation_remarks"}})],1),t._v(" "),n("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t._v(t._s(t.trans("general.save")))])])])]):t._e()]:t._e(),t._v(" "),n("div",{staticClass:"clearfix"})]}))],2)])])])]):t._e()],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=show.js.map?id=38e789acde4369d9b1f3