(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[6318],{24290:(t,r,e)=>{"use strict";e.d(r,{Z:()=>i});var n=e(94015),s=e.n(n),o=e(23645),a=e.n(o)()(s());a.push([t.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/transport/fee/form.vue"],names:[],mappings:"AAgMA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="transportFeeForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="">{{trans(\'transport.fee_name\')}}</label>\n                        <input class="form-control" type="text" v-model="transportFeeForm.name" name="name" :placeholder="trans(\'transport.fee_name\')">\n                        <show-error :form-name="transportFeeForm" prop-name="name"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="">{{trans(\'transport.fee_description\')}}</label>\n                        <input class="form-control" type="text" v-model="transportFeeForm.description" name="description" :placeholder="trans(\'transport.fee_description\')">\n                        <show-error :form-name="transportFeeForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="row" v-for="transport_circle in transportFeeForm.transport_circles">\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="" class="m-t-10">{{transport_circle.transport_circle_name+\' (\'+trans(\'finance.per_installment\')+\')\'}}</label>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <currency-input :position="default_currency.position" :symbol="default_currency.symbol" :name="`amount_${transport_circle.transport_circle_id}`" :placeholder="trans(\'transport.amount\')" v-model="transport_circle.amount"></currency-input>\n                        <show-error :form-name="transportFeeForm" :prop-name="`amount_${transport_circle.transport_circle_id}`"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer">\n                <div class="row">\n                    <div class="col-12 col-sm-6">\n                        <button type="button" class="btn btn-info" v-if="hasPermission(\'access-configuration\')" @click="showTransportCircleModal = true">{{trans(\'transport.add_new_circle\')}}</button>\n                    </div>\n                    <div class="col-12 col-sm-6 text-right">\n                        <router-link to="/transport/fee" class="btn btn-danger waves-effect waves-light " v-show="id">{{trans(\'general.cancel\')}}</router-link>\n                        <button v-if="!id" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                        <button type="submit" class="btn btn-info waves-effect waves-light">\n                            <span v-if="id">{{trans(\'general.update\')}}</span>\n                            <span v-else>{{trans(\'general.save\')}}</span>\n                        </button>\n                    </div>\n                </div>\n            </div>\n        </form>\n\n        <transition name="modal" v-if="showTransportCircleModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'transport.add_new_circle\')}}\n                                <span class="float-right pointer" @click="showTransportCircleModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <transport-circle-form @completed="getPreRequisite" @cancel="showTransportCircleModal = false"></transport-circle-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n\n<script>\n    import transportCircleForm from \'../circle/form\'\n\n    export default {\n        components: {transportCircleForm},\n        data() {\n            return {\n                transportFeeForm: new Form({\n                    name : \'\',\n                    description : \'\',\n                    transport_circles: []\n                }),\n                default_currency: helper.getConfig(\'default_currency\'),\n                transport_circles: [],\n                showTransportCircleModal: false\n            };\n        },\n        props: [\'id\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-transport-fee\') && !helper.hasPermission(\'edit-transport-fee\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            proceed(){\n                if(this.id)\n                    this.update();\n                else\n                    this.store();\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                this.showTransportCircleModal = false;\n                axios.get(\'/api/transport/fee/pre-requisite\')\n                    .then(response => {\n                        this.transport_circles = response;\n                        this.populateTransportCircle();\n\n                        if(this.id)\n                            this.get();\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.transportFeeForm.post(\'/api/transport/fee\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.transportFeeForm.transport_circles = [];\n                        this.populateTransportCircle();\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/transport/fee/\'+this.id)\n                    .then(response => {\n                        this.transportFeeForm.name = response.name;\n                        this.transportFeeForm.description = response.description;\n                        this.transportFeeForm.transport_circles.forEach(transport_circle => {\n                            let head = response.transport_fee_details.find( o => o.transport_circle_id == transport_circle.transport_circle_id);\n                            transport_circle.amount = (head) ? head.amount : 0;\n                        });\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/transport/fee\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.transportFeeForm.patch(\'/api/transport/fee/\'+this.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/transport/fee\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            getConfig(config) {\n                return helper.getConfig(config);\n            },\n            populateTransportCircle(){\n                this.transport_circles.forEach(transport_circle => {\n                    if (this.transportFeeForm.transport_circles.findIndex(o => o.transport_circle_id == transport_circle.id) < 0) {\n                        this.transportFeeForm.transport_circles.push({\n                            transport_circle_id: transport_circle.id,\n                            transport_circle_name: transport_circle.name,\n                            amount: 0\n                        })\n                    }\n                });\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>\n'],sourceRoot:""}]);const i=a},20546:(t,r,e)=>{"use strict";e.d(r,{Z:()=>s});const n={data:function(){return{circleForm:new Form({name:"",description:""})}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var t=this,r=this.$loading.show();this.circleForm.post("/api/transport/circle").then((function(e){toastr.success(e.message),t.$emit("completed"),r.hide()})).catch((function(t){r.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,r=this.$loading.show();axios.get("/api/transport/circle/"+this.id).then((function(e){t.circleForm.name=e.name,t.circleForm.description=e.description,r.hide()})).catch((function(e){r.hide(),helper.showErrorMsg(e),t.$router.push("/transport/circle")}))},update:function(){var t=this,r=this.$loading.show();this.circleForm.patch("/api/transport/circle/"+this.id).then((function(e){toastr.success(e.message),r.hide(),t.$router.push("/transport/circle")})).catch((function(t){r.hide(),helper.showErrorMsg(t)}))}}};const s=(0,e(51900).Z)(n,(function(){var t=this,r=t.$createElement,e=t._self._c||r;return e("form",{on:{submit:function(r){return r.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(r){return t.circleForm.errors.clear(r.target.name)}}},[e("div",{staticClass:"row"},[e("div",{staticClass:"col-12 col-sm-6"},[e("div",{staticClass:"form-group"},[e("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.circle_name")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.circleForm.name,expression:"circleForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("transport.circle_name")},domProps:{value:t.circleForm.name},on:{input:function(r){r.target.composing||t.$set(t.circleForm,"name",r.target.value)}}}),t._v(" "),e("show-error",{attrs:{"form-name":t.circleForm,"prop-name":"name"}})],1)]),t._v(" "),e("div",{staticClass:"col-12 col-sm-6"},[e("div",{staticClass:"form-group"},[e("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.circle_description")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.circleForm.description,expression:"circleForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:t.trans("transport.circle_description")},domProps:{value:t.circleForm.description},on:{input:function(r){r.target.composing||t.$set(t.circleForm,"description",r.target.value)}}}),t._v(" "),e("show-error",{attrs:{"form-name":t.circleForm,"prop-name":"description"}})],1)])]),t._v(" "),e("div",{staticClass:"card-footer text-right"},[e("router-link",{directives:[{name:"show",rawName:"v-show",value:t.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/transport/circle"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),t.id?t._e():e("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(r){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),e("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.id?e("span",[t._v(t._s(t.trans("general.update")))]):e("span",[t._v(t._s(t.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports},54317:(t,r,e)=>{"use strict";e.r(r),e.d(r,{default:()=>s});const n={components:{transportFeeForm:e(46744).Z},data:function(){return{id:this.$route.params.id}},mounted:function(){helper.hasPermission("edit-transport-fee")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const s=(0,e(51900).Z)(n,(function(){var t=this,r=t.$createElement,e=t._self._c||r;return e("div",[e("div",{staticClass:"page-titles"},[e("div",{staticClass:"row"},[e("div",{staticClass:"col-12 col-sm-6"},[e("h3",{staticClass:"text-themecolor"},[t._v(t._s(t.trans("transport.edit_fee")))])]),t._v(" "),e("div",{staticClass:"col-12 col-sm-6"},[e("div",{staticClass:"action-buttons pull-right"},[e("button",{staticClass:"btn btn-info btn-sm",on:{click:function(r){return t.$router.push("/transport/fee")}}},[e("i",{staticClass:"fas fa-list"}),t._v(" "),e("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("transport.edit_fee")))])])])])])]),t._v(" "),e("div",{staticClass:"container-fluid"},[e("div",{staticClass:"card card-form"},[e("div",{staticClass:"card-body p-t-20"},[e("transport-fee-form",{attrs:{id:t.id}})],1)])])])}),[],!1,null,null,null).exports},46744:(t,r,e)=>{"use strict";e.d(r,{Z:()=>c});const n={components:{transportCircleForm:e(20546).Z},data:function(){return{transportFeeForm:new Form({name:"",description:"",transport_circles:[]}),default_currency:helper.getConfig("default_currency"),transport_circles:[],showTransportCircleModal:!1}},props:["id"],mounted:function(){helper.hasPermission("create-transport-fee")||helper.hasPermission("edit-transport-fee")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{hasPermission:function(t){return helper.hasPermission(t)},proceed:function(){this.id?this.update():this.store()},getPreRequisite:function(){var t=this,r=this.$loading.show();this.showTransportCircleModal=!1,axios.get("/api/transport/fee/pre-requisite").then((function(e){t.transport_circles=e,t.populateTransportCircle(),t.id&&t.get(),r.hide()})).catch((function(t){r.hide(),helper.showErrorMsg(t)}))},store:function(){var t=this,r=this.$loading.show();this.transportFeeForm.post("/api/transport/fee").then((function(e){toastr.success(e.message),t.transportFeeForm.transport_circles=[],t.populateTransportCircle(),t.$emit("completed"),r.hide()})).catch((function(t){r.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,r=this.$loading.show();axios.get("/api/transport/fee/"+this.id).then((function(e){t.transportFeeForm.name=e.name,t.transportFeeForm.description=e.description,t.transportFeeForm.transport_circles.forEach((function(t){var r=e.transport_fee_details.find((function(r){return r.transport_circle_id==t.transport_circle_id}));t.amount=r?r.amount:0})),r.hide()})).catch((function(e){r.hide(),helper.showErrorMsg(e),t.$router.push("/transport/fee")}))},update:function(){var t=this,r=this.$loading.show();this.transportFeeForm.patch("/api/transport/fee/"+this.id).then((function(e){toastr.success(e.message),r.hide(),t.$router.push("/transport/fee")})).catch((function(t){r.hide(),helper.showErrorMsg(t)}))},getConfig:function(t){return helper.getConfig(t)},populateTransportCircle:function(){var t=this;this.transport_circles.forEach((function(r){t.transportFeeForm.transport_circles.findIndex((function(t){return t.transport_circle_id==r.id}))<0&&t.transportFeeForm.transport_circles.push({transport_circle_id:r.id,transport_circle_name:r.name,amount:0})}))}}};var s=e(93379),o=e.n(s),a=e(24290),i={insert:"head",singleton:!1};o()(a.Z,i);a.Z.locals;const c=(0,e(51900).Z)(n,(function(){var t=this,r=t.$createElement,e=t._self._c||r;return e("div",[e("form",{on:{submit:function(r){return r.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(r){return t.transportFeeForm.errors.clear(r.target.name)}}},[e("div",{staticClass:"row"},[e("div",{staticClass:"col-12 col-sm-4"},[e("div",{staticClass:"form-group"},[e("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.fee_name")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.transportFeeForm.name,expression:"transportFeeForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("transport.fee_name")},domProps:{value:t.transportFeeForm.name},on:{input:function(r){r.target.composing||t.$set(t.transportFeeForm,"name",r.target.value)}}}),t._v(" "),e("show-error",{attrs:{"form-name":t.transportFeeForm,"prop-name":"name"}})],1)]),t._v(" "),e("div",{staticClass:"col-12 col-sm-4"},[e("div",{staticClass:"form-group"},[e("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.fee_description")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.transportFeeForm.description,expression:"transportFeeForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:t.trans("transport.fee_description")},domProps:{value:t.transportFeeForm.description},on:{input:function(r){r.target.composing||t.$set(t.transportFeeForm,"description",r.target.value)}}}),t._v(" "),e("show-error",{attrs:{"form-name":t.transportFeeForm,"prop-name":"description"}})],1)])]),t._v(" "),t._l(t.transportFeeForm.transport_circles,(function(r){return e("div",{staticClass:"row"},[e("div",{staticClass:"col-12 col-sm-4"},[e("div",{staticClass:"form-group"},[e("label",{staticClass:"m-t-10",attrs:{for:""}},[t._v(t._s(r.transport_circle_name+" ("+t.trans("finance.per_installment")+")"))])])]),t._v(" "),e("div",{staticClass:"col-12 col-sm-4"},[e("div",{staticClass:"form-group"},[e("currency-input",{attrs:{position:t.default_currency.position,symbol:t.default_currency.symbol,name:"amount_"+r.transport_circle_id,placeholder:t.trans("transport.amount")},model:{value:r.amount,callback:function(e){t.$set(r,"amount",e)},expression:"transport_circle.amount"}}),t._v(" "),e("show-error",{attrs:{"form-name":t.transportFeeForm,"prop-name":"amount_"+r.transport_circle_id}})],1)])])})),t._v(" "),e("div",{staticClass:"card-footer"},[e("div",{staticClass:"row"},[e("div",{staticClass:"col-12 col-sm-6"},[t.hasPermission("access-configuration")?e("button",{staticClass:"btn btn-info",attrs:{type:"button"},on:{click:function(r){t.showTransportCircleModal=!0}}},[t._v(t._s(t.trans("transport.add_new_circle")))]):t._e()]),t._v(" "),e("div",{staticClass:"col-12 col-sm-6 text-right"},[e("router-link",{directives:[{name:"show",rawName:"v-show",value:t.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/transport/fee"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),t.id?t._e():e("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(r){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),e("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.id?e("span",[t._v(t._s(t.trans("general.update")))]):e("span",[t._v(t._s(t.trans("general.save")))])])],1)])])],2),t._v(" "),t.showTransportCircleModal?e("transition",{attrs:{name:"modal"}},[e("div",{staticClass:"modal-mask"},[e("div",{staticClass:"modal-wrapper"},[e("div",{staticClass:"modal-container modal-lg"},[e("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                            "+t._s(t.trans("transport.add_new_circle"))+"\n                            "),e("span",{staticClass:"float-right pointer",on:{click:function(r){t.showTransportCircleModal=!1}}},[t._v("x")])]}))],2),t._v(" "),e("div",{staticClass:"modal-body"},[t._t("body",(function(){return[e("transport-circle-form",{on:{completed:t.getPreRequisite,cancel:function(r){t.showTransportCircleModal=!1}}}),t._v(" "),e("div",{staticClass:"clearfix"})]}))],2)])])])]):t._e()],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=826e98bdffc3a3fac59c