(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[6657],{24290:(t,e,r)=>{"use strict";r.d(e,{Z:()=>i});var n=r(94015),s=r.n(n),a=r(23645),o=r.n(a)()(s());o.push([t.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/transport/fee/form.vue"],names:[],mappings:"AAgMA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="transportFeeForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="">{{trans(\'transport.fee_name\')}}</label>\n                        <input class="form-control" type="text" v-model="transportFeeForm.name" name="name" :placeholder="trans(\'transport.fee_name\')">\n                        <show-error :form-name="transportFeeForm" prop-name="name"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="">{{trans(\'transport.fee_description\')}}</label>\n                        <input class="form-control" type="text" v-model="transportFeeForm.description" name="description" :placeholder="trans(\'transport.fee_description\')">\n                        <show-error :form-name="transportFeeForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="row" v-for="transport_circle in transportFeeForm.transport_circles">\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="" class="m-t-10">{{transport_circle.transport_circle_name+\' (\'+trans(\'finance.per_installment\')+\')\'}}</label>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <currency-input :position="default_currency.position" :symbol="default_currency.symbol" :name="`amount_${transport_circle.transport_circle_id}`" :placeholder="trans(\'transport.amount\')" v-model="transport_circle.amount"></currency-input>\n                        <show-error :form-name="transportFeeForm" :prop-name="`amount_${transport_circle.transport_circle_id}`"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer">\n                <div class="row">\n                    <div class="col-12 col-sm-6">\n                        <button type="button" class="btn btn-info" v-if="hasPermission(\'access-configuration\')" @click="showTransportCircleModal = true">{{trans(\'transport.add_new_circle\')}}</button>\n                    </div>\n                    <div class="col-12 col-sm-6 text-right">\n                        <router-link to="/transport/fee" class="btn btn-danger waves-effect waves-light " v-show="id">{{trans(\'general.cancel\')}}</router-link>\n                        <button v-if="!id" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                        <button type="submit" class="btn btn-info waves-effect waves-light">\n                            <span v-if="id">{{trans(\'general.update\')}}</span>\n                            <span v-else>{{trans(\'general.save\')}}</span>\n                        </button>\n                    </div>\n                </div>\n            </div>\n        </form>\n\n        <transition name="modal" v-if="showTransportCircleModal">\n            <div class="modal-mask">\n                <div class="modal-wrapper">\n                    <div class="modal-container modal-lg">\n                        <div class="modal-header">\n                            <slot name="header">\n                                {{trans(\'transport.add_new_circle\')}}\n                                <span class="float-right pointer" @click="showTransportCircleModal = false">x</span>\n                            </slot>\n                        </div>\n                        <div class="modal-body">\n                            <slot name="body">\n                                <transport-circle-form @completed="getPreRequisite" @cancel="showTransportCircleModal = false"></transport-circle-form>\n                                <div class="clearfix"></div>\n                            </slot>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </transition>\n    </div>\n</template>\n\n\n<script>\n    import transportCircleForm from \'../circle/form\'\n\n    export default {\n        components: {transportCircleForm},\n        data() {\n            return {\n                transportFeeForm: new Form({\n                    name : \'\',\n                    description : \'\',\n                    transport_circles: []\n                }),\n                default_currency: helper.getConfig(\'default_currency\'),\n                transport_circles: [],\n                showTransportCircleModal: false\n            };\n        },\n        props: [\'id\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-transport-fee\') && !helper.hasPermission(\'edit-transport-fee\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            proceed(){\n                if(this.id)\n                    this.update();\n                else\n                    this.store();\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                this.showTransportCircleModal = false;\n                axios.get(\'/api/transport/fee/pre-requisite\')\n                    .then(response => {\n                        this.transport_circles = response;\n                        this.populateTransportCircle();\n\n                        if(this.id)\n                            this.get();\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.transportFeeForm.post(\'/api/transport/fee\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.transportFeeForm.transport_circles = [];\n                        this.populateTransportCircle();\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/transport/fee/\'+this.id)\n                    .then(response => {\n                        this.transportFeeForm.name = response.name;\n                        this.transportFeeForm.description = response.description;\n                        this.transportFeeForm.transport_circles.forEach(transport_circle => {\n                            let head = response.transport_fee_details.find( o => o.transport_circle_id == transport_circle.transport_circle_id);\n                            transport_circle.amount = (head) ? head.amount : 0;\n                        });\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/transport/fee\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.transportFeeForm.patch(\'/api/transport/fee/\'+this.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/transport/fee\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            getConfig(config) {\n                return helper.getConfig(config);\n            },\n            populateTransportCircle(){\n                this.transport_circles.forEach(transport_circle => {\n                    if (this.transportFeeForm.transport_circles.findIndex(o => o.transport_circle_id == transport_circle.id) < 0) {\n                        this.transportFeeForm.transport_circles.push({\n                            transport_circle_id: transport_circle.id,\n                            transport_circle_name: transport_circle.name,\n                            amount: 0\n                        })\n                    }\n                });\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>\n'],sourceRoot:""}]);const i=o},20546:(t,e,r)=>{"use strict";r.d(e,{Z:()=>s});const n={data:function(){return{circleForm:new Form({name:"",description:""})}},props:["id"],mounted:function(){this.id&&this.get()},methods:{proceed:function(){this.id?this.update():this.store()},store:function(){var t=this,e=this.$loading.show();this.circleForm.post("/api/transport/circle").then((function(r){toastr.success(r.message),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,e=this.$loading.show();axios.get("/api/transport/circle/"+this.id).then((function(r){t.circleForm.name=r.name,t.circleForm.description=r.description,e.hide()})).catch((function(r){e.hide(),helper.showErrorMsg(r),t.$router.push("/transport/circle")}))},update:function(){var t=this,e=this.$loading.show();this.circleForm.patch("/api/transport/circle/"+this.id).then((function(r){toastr.success(r.message),e.hide(),t.$router.push("/transport/circle")})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))}}};const s=(0,r(51900).Z)(n,(function(){var t=this,e=t.$createElement,r=t._self._c||e;return r("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.circleForm.errors.clear(e.target.name)}}},[r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.circle_name")))]),t._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:t.circleForm.name,expression:"circleForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("transport.circle_name")},domProps:{value:t.circleForm.name},on:{input:function(e){e.target.composing||t.$set(t.circleForm,"name",e.target.value)}}}),t._v(" "),r("show-error",{attrs:{"form-name":t.circleForm,"prop-name":"name"}})],1)]),t._v(" "),r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.circle_description")))]),t._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:t.circleForm.description,expression:"circleForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:t.trans("transport.circle_description")},domProps:{value:t.circleForm.description},on:{input:function(e){e.target.composing||t.$set(t.circleForm,"description",e.target.value)}}}),t._v(" "),r("show-error",{attrs:{"form-name":t.circleForm,"prop-name":"description"}})],1)])]),t._v(" "),r("div",{staticClass:"card-footer text-right"},[r("router-link",{directives:[{name:"show",rawName:"v-show",value:t.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/transport/circle"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),t.id?t._e():r("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(e){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),r("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.id?r("span",[t._v(t._s(t.trans("general.update")))]):r("span",[t._v(t._s(t.trans("general.save")))])])],1)])}),[],!1,null,null,null).exports},46744:(t,e,r)=>{"use strict";r.d(e,{Z:()=>c});const n={components:{transportCircleForm:r(20546).Z},data:function(){return{transportFeeForm:new Form({name:"",description:"",transport_circles:[]}),default_currency:helper.getConfig("default_currency"),transport_circles:[],showTransportCircleModal:!1}},props:["id"],mounted:function(){helper.hasPermission("create-transport-fee")||helper.hasPermission("edit-transport-fee")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{hasPermission:function(t){return helper.hasPermission(t)},proceed:function(){this.id?this.update():this.store()},getPreRequisite:function(){var t=this,e=this.$loading.show();this.showTransportCircleModal=!1,axios.get("/api/transport/fee/pre-requisite").then((function(r){t.transport_circles=r,t.populateTransportCircle(),t.id&&t.get(),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},store:function(){var t=this,e=this.$loading.show();this.transportFeeForm.post("/api/transport/fee").then((function(r){toastr.success(r.message),t.transportFeeForm.transport_circles=[],t.populateTransportCircle(),t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,e=this.$loading.show();axios.get("/api/transport/fee/"+this.id).then((function(r){t.transportFeeForm.name=r.name,t.transportFeeForm.description=r.description,t.transportFeeForm.transport_circles.forEach((function(t){var e=r.transport_fee_details.find((function(e){return e.transport_circle_id==t.transport_circle_id}));t.amount=e?e.amount:0})),e.hide()})).catch((function(r){e.hide(),helper.showErrorMsg(r),t.$router.push("/transport/fee")}))},update:function(){var t=this,e=this.$loading.show();this.transportFeeForm.patch("/api/transport/fee/"+this.id).then((function(r){toastr.success(r.message),e.hide(),t.$router.push("/transport/fee")})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getConfig:function(t){return helper.getConfig(t)},populateTransportCircle:function(){var t=this;this.transport_circles.forEach((function(e){t.transportFeeForm.transport_circles.findIndex((function(t){return t.transport_circle_id==e.id}))<0&&t.transportFeeForm.transport_circles.push({transport_circle_id:e.id,transport_circle_name:e.name,amount:0})}))}}};var s=r(93379),a=r.n(s),o=r(24290),i={insert:"head",singleton:!1};a()(o.Z,i);o.Z.locals;const c=(0,r(51900).Z)(n,(function(){var t=this,e=t.$createElement,r=t._self._c||e;return r("div",[r("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.transportFeeForm.errors.clear(e.target.name)}}},[r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-4"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.fee_name")))]),t._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:t.transportFeeForm.name,expression:"transportFeeForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("transport.fee_name")},domProps:{value:t.transportFeeForm.name},on:{input:function(e){e.target.composing||t.$set(t.transportFeeForm,"name",e.target.value)}}}),t._v(" "),r("show-error",{attrs:{"form-name":t.transportFeeForm,"prop-name":"name"}})],1)]),t._v(" "),r("div",{staticClass:"col-12 col-sm-4"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.fee_description")))]),t._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:t.transportFeeForm.description,expression:"transportFeeForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:t.trans("transport.fee_description")},domProps:{value:t.transportFeeForm.description},on:{input:function(e){e.target.composing||t.$set(t.transportFeeForm,"description",e.target.value)}}}),t._v(" "),r("show-error",{attrs:{"form-name":t.transportFeeForm,"prop-name":"description"}})],1)])]),t._v(" "),t._l(t.transportFeeForm.transport_circles,(function(e){return r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-4"},[r("div",{staticClass:"form-group"},[r("label",{staticClass:"m-t-10",attrs:{for:""}},[t._v(t._s(e.transport_circle_name+" ("+t.trans("finance.per_installment")+")"))])])]),t._v(" "),r("div",{staticClass:"col-12 col-sm-4"},[r("div",{staticClass:"form-group"},[r("currency-input",{attrs:{position:t.default_currency.position,symbol:t.default_currency.symbol,name:"amount_"+e.transport_circle_id,placeholder:t.trans("transport.amount")},model:{value:e.amount,callback:function(r){t.$set(e,"amount",r)},expression:"transport_circle.amount"}}),t._v(" "),r("show-error",{attrs:{"form-name":t.transportFeeForm,"prop-name":"amount_"+e.transport_circle_id}})],1)])])})),t._v(" "),r("div",{staticClass:"card-footer"},[r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-6"},[t.hasPermission("access-configuration")?r("button",{staticClass:"btn btn-info",attrs:{type:"button"},on:{click:function(e){t.showTransportCircleModal=!0}}},[t._v(t._s(t.trans("transport.add_new_circle")))]):t._e()]),t._v(" "),r("div",{staticClass:"col-12 col-sm-6 text-right"},[r("router-link",{directives:[{name:"show",rawName:"v-show",value:t.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/transport/fee"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),t.id?t._e():r("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(e){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),r("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.id?r("span",[t._v(t._s(t.trans("general.update")))]):r("span",[t._v(t._s(t.trans("general.save")))])])],1)])])],2),t._v(" "),t.showTransportCircleModal?r("transition",{attrs:{name:"modal"}},[r("div",{staticClass:"modal-mask"},[r("div",{staticClass:"modal-wrapper"},[r("div",{staticClass:"modal-container modal-lg"},[r("div",{staticClass:"modal-header"},[t._t("header",(function(){return[t._v("\n                            "+t._s(t.trans("transport.add_new_circle"))+"\n                            "),r("span",{staticClass:"float-right pointer",on:{click:function(e){t.showTransportCircleModal=!1}}},[t._v("x")])]}))],2),t._v(" "),r("div",{staticClass:"modal-body"},[t._t("body",(function(){return[r("transport-circle-form",{on:{completed:t.getPreRequisite,cancel:function(e){t.showTransportCircleModal=!1}}}),t._v(" "),r("div",{staticClass:"clearfix"})]}))],2)])])])]):t._e()],1)}),[],!1,null,null,null).exports},27082:(t,e,r)=>{"use strict";r.r(e),r.d(e,{default:()=>o});var n;function s(t,e,r){return e in t?Object.defineProperty(t,e,{value:r,enumerable:!0,configurable:!0,writable:!0}):t[e]=r,t}const a={components:{transportFeeForm:r(46744).Z},data:function(){return{transport_fees:{total:0,data:[]},filter:{sort_by:"name",order:"asc",name:"",page_length:helper.getConfig("page_length")},orderByOptions:[{value:"name",translation:i18n.transport.fee_name},{value:"created_at",translation:i18n.general.created_at}],showCreatePanel:!1,showFilterPanel:!1,help_topic:""}},mounted:function(){helper.hasPermission("list-transport-fee")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getTransportFees(),helper.showDemoNotification(["transport"])},methods:(n={getConfig:function(t){return helper.getConfig(t)},hasPermission:function(t){return helper.hasPermission(t)},getTransportFees:function(t){var e=this,r=this.$loading.show();"number"!=typeof t&&(t=1);var n=helper.getFilterURL(this.filter);axios.get("/api/transport/fee?page="+t+n).then((function(t){e.transport_fees=t,r.hide()})).catch((function(t){r.hide(),helper.showErrorMsg(t)}))},editTransportFee:function(t){this.$router.push("/transport/fee/"+t.id+"/edit")},confirmDelete:function(t){var e=this;return function(r){return e.deleteTransportFee(t)}},deleteTransportFee:function(t){var e=this,r=this.$loading.show();axios.delete("/api/transport/fee/"+t.id).then((function(t){toastr.success(t.message),e.getTransportFees(),r.hide()})).catch((function(t){r.hide(),helper.showErrorMsg(t)}))}},s(n,"getConfig",(function(t){return helper.getConfig(t)})),s(n,"formatCurrency",(function(t){return helper.formatCurrency(t)})),s(n,"print",(function(){var t=this.$loading.show();axios.post("/api/transport/fee/print",{filter:this.filter}).then((function(e){var r=window.open("/print");t.hide(),r.document.write(e)})).catch((function(e){t.hide(),helper.showErrorMsg(e)}))})),s(n,"pdf",(function(){var t=this,e=this.$loading.show();axios.post("/api/transport/fee/pdf",{filter:this.filter}).then((function(r){e.hide(),window.open("/download/report/"+r+"?token="+t.authToken)})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))})),n),filters:{moment:function(t){return helper.formatDate(t)},momentDateTime:function(t){return helper.formatDateTime(t)}},watch:{"filter.sort_by":function(t){this.getTransportFees()},"filter.order":function(t){this.getTransportFees()},"filter.page_length":function(t){this.getTransportFees()}},computed:{authToken:function(){return helper.getAuthToken()}}};const o=(0,r(51900).Z)(a,(function(){var t=this,e=t.$createElement,r=t._self._c||e;return r("div",[r("div",{staticClass:"page-titles"},[r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-6"},[r("h3",{staticClass:"text-themecolor"},[t._v(t._s(t.trans("transport.fee"))+" \n                    "),t.transport_fees.total?r("span",{staticClass:"card-subtitle d-none d-sm-inline"},[t._v(t._s(t.trans("general.total_result_found",{count:t.transport_fees.total,from:t.transport_fees.from,to:t.transport_fees.to})))]):r("span",{staticClass:"card-subtitle d-none d-sm-inline"},[t._v(t._s(t.trans("general.no_result_found")))])])]),t._v(" "),r("div",{staticClass:"col-12 col-sm-6"},[r("div",{staticClass:"action-buttons pull-right"},[t.transport_fees.total&&!t.showCreatePanel&&t.hasPermission("create-transport-fee")?r("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.add_new"),expression:"trans('general.add_new')"}],staticClass:"btn btn-info btn-sm",on:{click:function(e){t.showCreatePanel=!t.showCreatePanel}}},[r("i",{staticClass:"fas fa-plus"}),t._v(" "),r("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("transport.add_new_fee")))])]):t._e(),t._v(" "),t.showFilterPanel?t._e():r("button",{staticClass:"btn btn-info btn-sm",on:{click:function(e){t.showFilterPanel=!t.showFilterPanel}}},[r("i",{staticClass:"fas fa-filter"}),t._v(" "),r("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("general.filter")))])]),t._v(" "),r("sort-by",{attrs:{"order-by-options":t.orderByOptions,"sort-by":t.filter.sort_by,order:t.filter.order},on:{updateSortBy:function(e){t.filter.sort_by=e},updateOrder:function(e){t.filter.order=e}}}),t._v(" "),r("div",{staticClass:"btn-group"},[r("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("general.more_option"),expression:"trans('general.more_option')"}],staticClass:"btn btn-info btn-sm dropdown-toggle no-caret ",attrs:{type:"button",role:"menu",id:"moreOption","data-toggle":"dropdown","aria-haspopup":"true","aria-expanded":"false"}},[r("i",{staticClass:"fas fa-ellipsis-h"}),t._v(" "),r("span",{staticClass:"d-none d-sm-inline"})]),t._v(" "),r("div",{class:["dropdown-menu","ltr"==t.getConfig("direction")?"dropdown-menu-right":""],attrs:{"aria-labelledby":"moreOption"}},[r("button",{staticClass:"dropdown-item custom-dropdown",on:{click:t.print}},[r("i",{staticClass:"fas fa-print"}),t._v(" "+t._s(t.trans("general.print")))]),t._v(" "),r("button",{staticClass:"dropdown-item custom-dropdown",on:{click:t.pdf}},[r("i",{staticClass:"fas fa-file-pdf"}),t._v(" "+t._s(t.trans("general.generate_pdf")))]),t._v(" "),t.hasPermission("list-transport-circle")?r("button",{staticClass:"dropdown-item custom-dropdown",on:{click:function(e){return t.$router.push("/transport/circle")}}},[r("i",{staticClass:"fas fa-circle-notch"}),t._v(" "+t._s(t.trans("transport.transport_circle")))]):t._e()])]),t._v(" "),r("help-button",{on:{clicked:function(e){t.help_topic="transport.fee"}}})],1)])])]),t._v(" "),r("div",{staticClass:"container-fluid"},[r("transition",{attrs:{name:"fade"}},[t.showFilterPanel?r("div",{staticClass:"card card-form"},[r("div",{staticClass:"card-body"},[r("h4",{staticClass:"card-title"},[t._v(t._s(t.trans("general.filter")))]),t._v(" "),r("div",{staticClass:"row"},[r("div",{staticClass:"col-12 col-sm-3"},[r("div",{staticClass:"form-group"},[r("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.fee_name")))]),t._v(" "),r("input",{directives:[{name:"model",rawName:"v-model",value:t.filter.name,expression:"filter.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("transport.fee_name")},domProps:{value:t.filter.name},on:{input:function(e){e.target.composing||t.$set(t.filter,"name",e.target.value)}}})])])]),t._v(" "),r("div",{staticClass:"card-footer text-right"},[r("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(e){t.showFilterPanel=!1}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),r("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"button"},on:{click:t.getTransportFees}},[t._v(t._s(t.trans("general.filter")))])])])]):t._e()]),t._v(" "),t.hasPermission("create-transport-fee")?r("transition",{attrs:{name:"fade"}},[t.showCreatePanel?r("div",{staticClass:"card card-form"},[r("div",{staticClass:"card-body"},[r("h4",{staticClass:"card-title"},[t._v(t._s(t.trans("transport.add_new_fee")))]),t._v(" "),r("transport-fee-form",{on:{completed:t.getTransportFees,cancel:function(e){t.showCreatePanel=!t.showCreatePanel}}})],1)]):t._e()]):t._e(),t._v(" "),r("div",{staticClass:"card"},[r("div",{staticClass:"card-body"},[t.transport_fees.total?r("div",{staticClass:"table-responsive"},[r("table",{staticClass:"table table-sm"},[r("thead",[r("tr",[r("th",[t._v(t._s(t.trans("transport.fee_name")))]),t._v(" "),r("th",[t._v(t._s(t.trans("transport.circle")))]),t._v(" "),r("th",[t._v(t._s(t.trans("transport.fee_description")))]),t._v(" "),r("th",{staticClass:"table-option"},[t._v(t._s(t.trans("general.action")))])])]),t._v(" "),r("tbody",t._l(t.transport_fees.data,(function(e){return r("tr",[r("td",{domProps:{textContent:t._s(e.name)}}),t._v(" "),r("td",[r("div",{staticClass:"table-responsive"},[r("table",{staticClass:"table table-borderless"},[r("tbody",t._l(e.transport_fee_details,(function(e){return r("tr",[r("td",[t._v(t._s(e.transport_circle.name))]),t._v(" "),r("td",[t._v(t._s(t.formatCurrency(e.amount)))])])})),0)])])]),t._v(" "),r("td",{domProps:{textContent:t._s(e.description)}}),t._v(" "),r("td",{staticClass:"table-option"},[r("div",{staticClass:"btn-group"},[t.hasPermission("edit-transport-fee")?r("button",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.trans("transport.edit_fee"),expression:"trans('transport.edit_fee')"}],staticClass:"btn btn-info btn-sm",on:{click:function(r){return r.preventDefault(),t.editTransportFee(e)}}},[r("i",{staticClass:"fas fa-edit"})]):t._e(),t._v(" "),t.hasPermission("delete-transport-fee")?r("button",{directives:[{name:"confirm",rawName:"v-confirm",value:{ok:t.confirmDelete(e)},expression:"{ok: confirmDelete(transport_fee)}"},{name:"tooltip",rawName:"v-tooltip",value:t.trans("transport.delete_fee"),expression:"trans('transport.delete_fee')"}],key:e.id,staticClass:"btn btn-danger btn-sm"},[r("i",{staticClass:"fas fa-trash"})]):t._e()])])])})),0)])]):t._e(),t._v(" "),t.transport_fees.total?t._e():r("module-info",{attrs:{module:"transport",title:"fee_module_title",description:"fee_module_description",icon:"list"}},[r("div",{attrs:{slot:"btn"},slot:"btn"},[!t.showCreatePanel&&t.hasPermission("create-transport-fee")?r("button",{staticClass:"btn btn-info btn-md",on:{click:function(e){t.showCreatePanel=!t.showCreatePanel}}},[r("i",{staticClass:"fas fa-plus"}),t._v(" "+t._s(t.trans("general.add_new")))]):t._e()])]),t._v(" "),r("pagination-record",{attrs:{"page-length":t.filter.page_length,records:t.transport_fees},on:{"update:pageLength":function(e){return t.$set(t.filter,"page_length",e)},"update:page-length":function(e){return t.$set(t.filter,"page_length",e)},updateRecords:t.getTransportFees}})],1)])],1),t._v(" "),r("right-panel",{attrs:{topic:t.help_topic}})],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=index.js.map?id=93874255184ae5124efb