(self.webpackChunkInstiKit=self.webpackChunkInstiKit||[]).push([[4346],{88616:(t,e,s)=>{"use strict";s.d(e,{Z:()=>p});var r=s(94015),o=s.n(r),n=s(23645),a=s.n(n)()(o());a.push([t.id,".loading-overlay.is-full-page{z-index:1060}","",{version:3,sources:["webpack://./resources/js/views/transport/route/form.vue"],names:[],mappings:"AAkKA,8BACA,YACA",sourcesContent:['<template>\n    <div>\n        <form @submit.prevent="proceed" @keydown="transportRouteForm.errors.clear($event.target.name)">\n            <div class="row">\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="">{{trans(\'transport.route_name\')}}</label>\n                        <input class="form-control" type="text" v-model="transportRouteForm.name" name="name" :placeholder="trans(\'transport.route_name\')">\n                        <show-error :form-name="transportRouteForm" prop-name="name"></show-error>\n                    </div>\n                </div>\n                <div class="col-12 col-sm-4">\n                    <div class="form-group">\n                        <label for="">{{trans(\'transport.route_description\')}}</label>\n                        <input class="form-control" type="text" v-model="transportRouteForm.description" name="description" :placeholder="trans(\'transport.route_description\')">\n                        <show-error :form-name="transportRouteForm" prop-name="description"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="row">\n                <div class="col-12 col-sm-3">\n                    <div class="form-group">\n                        <label for="">{{trans(\'transport.stoppage\')}} </label> \n                        <v-select label="name" track-by="id" v-model="selected_transport_stoppages" name="transport_stoppages" id="transport_stoppages" :options="transport_stoppages" :placeholder="trans(\'transport.select_stoppage\')" @select="onTransportStoppageSelect" :multiple="true" :close-on-select="false" :clear-on-select="false" :hide-selected="true" @remove="onTransportStoppageRemove" :selected="selected_transport_stoppages">\n                            <div class="multiselect__option" slot="afterList" v-if="!transport_stoppages.length">\n                                {{trans(\'general.no_option_found\')}}\n                            </div>\n                        </v-select>\n                        <show-error :form-name="transportRouteForm" prop-name="transport_stoppages"></show-error>\n                    </div>\n                </div>\n            </div>\n            <div class="card-footer">\n                <div class="row">\n                    <div class="col-12 col-sm-6">\n                    </div>\n                    <div class="col-12 col-sm-6 text-right">\n                        <router-link to="/transport/route" class="btn btn-danger waves-effect waves-light " v-show="id">{{trans(\'general.cancel\')}}</router-link>\n                        <button v-if="!id" type="button" class="btn btn-danger waves-effect waves-light " @click="$emit(\'cancel\')">{{trans(\'general.cancel\')}}</button>\n                        <button type="submit" class="btn btn-info waves-effect waves-light">\n                            <span v-if="id">{{trans(\'general.update\')}}</span>\n                            <span v-else>{{trans(\'general.save\')}}</span>\n                        </button>\n                    </div>\n                </div>\n            </div>\n        </form>\n    </div>\n</template>\n\n\n<script>\n    export default {\n        components: {},\n        data() {\n            return {\n                transportRouteForm: new Form({\n                    name : \'\',\n                    description : \'\',\n                    transport_stoppages: []\n                }),\n                transport_stoppages: [],\n                selected_transport_stoppages: null,\n                showTransportStoppageModal: false\n            };\n        },\n        props: [\'id\'],\n        mounted() {\n            if(!helper.hasPermission(\'create-transport-route\') && !helper.hasPermission(\'edit-transport-route\')){\n                helper.notAccessibleMsg();\n                this.$router.push(\'/dashboard\');\n            }\n\n            this.getPreRequisite();\n        },\n        methods: {\n            hasPermission(permission){\n                return helper.hasPermission(permission);\n            },\n            proceed(){\n                if(this.id)\n                    this.update();\n                else\n                    this.store();\n            },\n            getPreRequisite(){\n                let loader = this.$loading.show();\n                this.showTransportStoppageModal = false;\n                axios.get(\'/api/transport/route/pre-requisite\')\n                    .then(response => {\n                        this.transport_stoppages = response;\n\n                        if(this.id)\n                            this.get();\n\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            store(){\n                let loader = this.$loading.show();\n                this.transportRouteForm.post(\'/api/transport/route\')\n                    .then(response => {\n                        toastr.success(response.message);\n                        this.transportRouteForm.transport_stoppages = [];\n                        this.selected_transport_stoppages = null;\n                        this.$emit(\'completed\');\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            get(){\n                let loader = this.$loading.show();\n                axios.get(\'/api/transport/route/\'+this.id)\n                    .then(response => {\n                        this.transportRouteForm.name = response.transport_route.name;\n                        this.transportRouteForm.description = response.transport_route.description;\n                        this.selected_transport_stoppages = response.selected_transport_stoppages;\n                        response.selected_transport_stoppages.forEach(transport_route => {\n                            this.transportRouteForm.transport_stoppages.push(transport_route.id);\n                        });\n                        loader.hide();\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                        this.$router.push(\'/transport/route\');\n                    });\n            },\n            update(){\n                let loader = this.$loading.show();\n                this.transportRouteForm.patch(\'/api/transport/route/\'+this.id)\n                    .then(response => {\n                        toastr.success(response.message);\n                        loader.hide();\n                        this.$router.push(\'/transport/route\');\n                    })\n                    .catch(error => {\n                        loader.hide();\n                        helper.showErrorMsg(error);\n                    });\n            },\n            getConfig(config) {\n                return helper.getConfig(config);\n            },\n            onTransportStoppageSelect(selectedOption){\n                this.transportRouteForm.transport_stoppages.push(selectedOption.id);\n            },\n            onTransportStoppageRemove(removedOption){\n                this.transportRouteForm.transport_stoppages.splice(this.transportRouteForm.transport_stoppages.indexOf(removedOption.id), 1);\n            }\n        }\n    }\n<\/script>\n\n<style>\n.loading-overlay.is-full-page{\n    z-index: 1060;\n}\n</style>\n'],sourceRoot:""}]);const p=a},82234:(t,e,s)=>{"use strict";s.r(e),s.d(e,{default:()=>o});const r={components:{transportRouteForm:s(72736).Z},data:function(){return{id:this.$route.params.id}},mounted:function(){helper.hasPermission("edit-transport-route")||(helper.notAccessibleMsg(),this.$router.push("/dashboard"))}};const o=(0,s(51900).Z)(r,(function(){var t=this,e=t.$createElement,s=t._self._c||e;return s("div",[s("div",{staticClass:"page-titles"},[s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-6"},[s("h3",{staticClass:"text-themecolor"},[t._v(t._s(t.trans("transport.edit_route")))])]),t._v(" "),s("div",{staticClass:"col-12 col-sm-6"},[s("div",{staticClass:"action-buttons pull-right"},[s("button",{staticClass:"btn btn-info btn-sm",on:{click:function(e){return t.$router.push("/transport/route")}}},[s("i",{staticClass:"fas fa-list"}),t._v(" "),s("span",{staticClass:"d-none d-sm-inline"},[t._v(t._s(t.trans("transport.edit_route")))])])])])])]),t._v(" "),s("div",{staticClass:"container-fluid"},[s("div",{staticClass:"card card-form"},[s("div",{staticClass:"card-body p-t-20"},[s("transport-route-form",{attrs:{id:t.id}})],1)])])])}),[],!1,null,null,null).exports},72736:(t,e,s)=>{"use strict";s.d(e,{Z:()=>i});const r={components:{},data:function(){return{transportRouteForm:new Form({name:"",description:"",transport_stoppages:[]}),transport_stoppages:[],selected_transport_stoppages:null,showTransportStoppageModal:!1}},props:["id"],mounted:function(){helper.hasPermission("create-transport-route")||helper.hasPermission("edit-transport-route")||(helper.notAccessibleMsg(),this.$router.push("/dashboard")),this.getPreRequisite()},methods:{hasPermission:function(t){return helper.hasPermission(t)},proceed:function(){this.id?this.update():this.store()},getPreRequisite:function(){var t=this,e=this.$loading.show();this.showTransportStoppageModal=!1,axios.get("/api/transport/route/pre-requisite").then((function(s){t.transport_stoppages=s,t.id&&t.get(),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},store:function(){var t=this,e=this.$loading.show();this.transportRouteForm.post("/api/transport/route").then((function(s){toastr.success(s.message),t.transportRouteForm.transport_stoppages=[],t.selected_transport_stoppages=null,t.$emit("completed"),e.hide()})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},get:function(){var t=this,e=this.$loading.show();axios.get("/api/transport/route/"+this.id).then((function(s){t.transportRouteForm.name=s.transport_route.name,t.transportRouteForm.description=s.transport_route.description,t.selected_transport_stoppages=s.selected_transport_stoppages,s.selected_transport_stoppages.forEach((function(e){t.transportRouteForm.transport_stoppages.push(e.id)})),e.hide()})).catch((function(s){e.hide(),helper.showErrorMsg(s),t.$router.push("/transport/route")}))},update:function(){var t=this,e=this.$loading.show();this.transportRouteForm.patch("/api/transport/route/"+this.id).then((function(s){toastr.success(s.message),e.hide(),t.$router.push("/transport/route")})).catch((function(t){e.hide(),helper.showErrorMsg(t)}))},getConfig:function(t){return helper.getConfig(t)},onTransportStoppageSelect:function(t){this.transportRouteForm.transport_stoppages.push(t.id)},onTransportStoppageRemove:function(t){this.transportRouteForm.transport_stoppages.splice(this.transportRouteForm.transport_stoppages.indexOf(t.id),1)}}};var o=s(93379),n=s.n(o),a=s(88616),p={insert:"head",singleton:!1};n()(a.Z,p);a.Z.locals;const i=(0,s(51900).Z)(r,(function(){var t=this,e=t.$createElement,s=t._self._c||e;return s("div",[s("form",{on:{submit:function(e){return e.preventDefault(),t.proceed.apply(null,arguments)},keydown:function(e){return t.transportRouteForm.errors.clear(e.target.name)}}},[s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-4"},[s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.route_name")))]),t._v(" "),s("input",{directives:[{name:"model",rawName:"v-model",value:t.transportRouteForm.name,expression:"transportRouteForm.name"}],staticClass:"form-control",attrs:{type:"text",name:"name",placeholder:t.trans("transport.route_name")},domProps:{value:t.transportRouteForm.name},on:{input:function(e){e.target.composing||t.$set(t.transportRouteForm,"name",e.target.value)}}}),t._v(" "),s("show-error",{attrs:{"form-name":t.transportRouteForm,"prop-name":"name"}})],1)]),t._v(" "),s("div",{staticClass:"col-12 col-sm-4"},[s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.route_description")))]),t._v(" "),s("input",{directives:[{name:"model",rawName:"v-model",value:t.transportRouteForm.description,expression:"transportRouteForm.description"}],staticClass:"form-control",attrs:{type:"text",name:"description",placeholder:t.trans("transport.route_description")},domProps:{value:t.transportRouteForm.description},on:{input:function(e){e.target.composing||t.$set(t.transportRouteForm,"description",e.target.value)}}}),t._v(" "),s("show-error",{attrs:{"form-name":t.transportRouteForm,"prop-name":"description"}})],1)])]),t._v(" "),s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-3"},[s("div",{staticClass:"form-group"},[s("label",{attrs:{for:""}},[t._v(t._s(t.trans("transport.stoppage"))+" ")]),t._v(" "),s("v-select",{attrs:{label:"name","track-by":"id",name:"transport_stoppages",id:"transport_stoppages",options:t.transport_stoppages,placeholder:t.trans("transport.select_stoppage"),multiple:!0,"close-on-select":!1,"clear-on-select":!1,"hide-selected":!0,selected:t.selected_transport_stoppages},on:{select:t.onTransportStoppageSelect,remove:t.onTransportStoppageRemove},model:{value:t.selected_transport_stoppages,callback:function(e){t.selected_transport_stoppages=e},expression:"selected_transport_stoppages"}},[t.transport_stoppages.length?t._e():s("div",{staticClass:"multiselect__option",attrs:{slot:"afterList"},slot:"afterList"},[t._v("\n                            "+t._s(t.trans("general.no_option_found"))+"\n                        ")])]),t._v(" "),s("show-error",{attrs:{"form-name":t.transportRouteForm,"prop-name":"transport_stoppages"}})],1)])]),t._v(" "),s("div",{staticClass:"card-footer"},[s("div",{staticClass:"row"},[s("div",{staticClass:"col-12 col-sm-6"}),t._v(" "),s("div",{staticClass:"col-12 col-sm-6 text-right"},[s("router-link",{directives:[{name:"show",rawName:"v-show",value:t.id,expression:"id"}],staticClass:"btn btn-danger waves-effect waves-light ",attrs:{to:"/transport/route"}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),t.id?t._e():s("button",{staticClass:"btn btn-danger waves-effect waves-light ",attrs:{type:"button"},on:{click:function(e){return t.$emit("cancel")}}},[t._v(t._s(t.trans("general.cancel")))]),t._v(" "),s("button",{staticClass:"btn btn-info waves-effect waves-light",attrs:{type:"submit"}},[t.id?s("span",[t._v(t._s(t.trans("general.update")))]):s("span",[t._v(t._s(t.trans("general.save")))])])],1)])])])])}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=edit.js.map?id=018cd620664c5608613d